<?php

// Script to update purchase create.blade.php with raw material dropdown and tax fields

$filePath = __DIR__.'/resources/views/admin/purchase/create.blade.php';
$content = file_get_contents($filePath);

// Backup the file
file_put_contents($filePath.'.backup', $content);

// 1. Update table headers (already done, keeping for reference)
$oldHeaders = <<<'HTML'
                                <thead class="table-primary text-center">
                                    <tr>
                                        <th style="width: 60px;">Sr</th>
                                        <th style="width: 80px;">P</th>
                                        <th style="min-width: 200px;">Item Name</th>
                                        <th style="width: 100px;">Pack</th>
                                        <th style="width: 120px;">GRN No</th>
                                        <th style="width: 120px;">Quantity</th>
                                        <th style="width: 120px;">Net Rate</th>
                                        <th style="width: 120px;">Discount (₹)</th>
                                        <th style="width: 150px;">Amount</th>
                                        <th style="width: 150px;">Tax %</th>
                                        <th style="width: 150px;">Action</th>
                                    </tr>
                                </thead>
HTML;

$newHeaders = <<<'HTML'
                                <thead class="table-primary text-center">
                                    <tr>
                                        <th style="width: 60px;">Sr</th>
                                        <th style="width: 80px;">P</th>
                                        <th style="min-width: 250px;">Item Name</th>
                                        <th style="width: 100px;">Pack</th>
                                        <th style="width: 120px;">GRN No</th>
                                        <th style="width: 100px;">Quantity</th>
                                        <th style="width: 100px;">Net Rate</th>
                                        <th style="width: 100px;">Discount (₹)</th>
                                        <th style="width: 100px;">Amount</th>
                                        <th style="width: 80px;">SGST %</th>
                                        <th style="width: 80px;">CGST %</th>
                                        <th style="width: 80px;">IGST %</th>
                                        <th style="width: 100px;">Tax Amount</th>
                                        <th style="width: 120px;">Action</th>
                                    </tr>
                                </thead>
HTML;

$content = str_replace($oldHeaders, $newHeaders, $content);

// 2. Update edit mode item row (with existing data)
$oldEditRow = <<<'HTML'
                                                <td class="text-center sr-no">{{ $index + 1 }}</td>
                                                <td><input type="text" class="form-control item-field" name="items[{{ $index }}][p]" value="{{ $item->p }}" placeholder="P" data-tabindex="{{ 17 + ($index * 8) }}"></td>
                                                <td><input type="text" class="form-control item-field" name="items[{{ $index }}][item_name]" value="{{ $item->item_name }}" placeholder="Item Name" data-tabindex="{{ 18 + ($index * 8) }}"></td>
                                                <td><input type="text" class="form-control item-field" name="items[{{ $index }}][pack]" value="{{ $item->pack }}" placeholder="Pack" data-tabindex="{{ 19 + ($index * 8) }}"></td>
                                                <td><input type="text" class="form-control item-field" name="items[{{ $index }}][grn_no]" value="{{ $item->grn_no }}" placeholder="GRN No" data-tabindex="{{ 20 + ($index * 8) }}"></td>
                                                <td><input type="number" class="form-control input-number quantity item-field" name="items[{{ $index }}][quantity]" value="{{ $item->quantity }}" placeholder="Quantity" min="0" step="1" data-tabindex="{{ 21 + ($index * 8) }}"></td>
                                                <td><input type="number" class="form-control input-number net-rate item-field" name="items[{{ $index }}][net_rate]" value="{{ $item->net_rate }}" placeholder="Net Rate" min="0" step="1" data-tabindex="{{ 22 + ($index * 8) }}"></td>
                                                <td><input type="number" class="form-control input-number discount item-field" name="items[{{ $index }}][discount]" value="{{ $item->discount }}" placeholder="Discount" min="0" step="1" data-tabindex="{{ 23 + ($index * 8) }}"></td>
                                                <td><input type="number" class="form-control input-number amount" name="items[{{ $index }}][amount]" value="{{ $item->amount }}" placeholder="Amount" readonly></td>
                                                <td>
                                                    <input type="number" class="form-control tax-input tax-percent item-field" name="items[{{ $index }}][tax_percent]" value="{{ $item->tax_percent }}" placeholder="%" min="0" max="100" step="1" data-tabindex="{{ 24 + ($index * 8) }}">
                                                    <span class="tax-amount-display">{{ number_format($item->amount * $item->tax_percent / 100, 2) }}</span>
                                                </td>
HTML;

$newEditRow = <<<'HTML'
                                                <td class="text-center sr-no">{{ $index + 1 }}</td>
                                                <td><input type="text" class="form-control item-field" name="items[{{ $index }}][p]" value="{{ $item->p }}" placeholder="P" data-tabindex="{{ 17 + ($index * 11) }}"></td>
                                                <td>
                                                    <input type="hidden" class="item-id" name="items[{{ $index }}][item_id]" value="{{ $item->item_id ?? '' }}">
                                                    <select class="form-control item-dropdown select2" name="items[{{ $index }}][item_name_select]" data-tabindex="{{ 18 + ($index * 11) }}">
                                                        <option value="">Select Item</option>
                                                        @foreach($rawMaterials as $material)
                                                            <option value="{{ $material->id }}" 
                                                                data-rate="{{ $material->purchase_rate }}" 
                                                                data-sgst="{{ $material->sgst }}" 
                                                                data-cgst="{{ $material->cgst }}" 
                                                                data-igst="{{ $material->igst }}"
                                                                {{ (isset($item) && $item->item_id == $material->id) ? 'selected' : '' }}>
                                                                {{ $material->item_name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                                <td><input type="text" class="form-control item-field" name="items[{{ $index }}][pack]" value="{{ $item->pack }}" placeholder="Pack" data-tabindex="{{ 19 + ($index * 11) }}"></td>
                                                <td><input type="text" class="form-control item-field" name="items[{{ $index }}][grn_no]" value="{{ $item->grn_no }}" placeholder="GRN No" data-tabindex="{{ 20 + ($index * 11) }}"></td>
                                                <td><input type="number" class="form-control input-number quantity item-field" name="items[{{ $index }}][quantity]" value="{{ $item->quantity }}" placeholder="Quantity" min="0" step="1" data-tabindex="{{ 21 + ($index * 11) }}"></td>
                                                <td><input type="number" class="form-control input-number net-rate item-field" name="items[{{ $index }}][net_rate]" value="{{ $item->net_rate }}" placeholder="Net Rate" min="0" step="0.01" data-tabindex="{{ 22 + ($index * 11) }}"></td>
                                                <td><input type="number" class="form-control input-number discount item-field" name="items[{{ $index }}][discount]" value="{{ $item->discount }}" placeholder="Discount" min="0" step="0.01" data-tabindex="{{ 23 + ($index * 11) }}"></td>
                                                <td><input type="number" class="form-control input-number amount" name="items[{{ $index }}][amount]" value="{{ $item->amount }}" placeholder="Amount" readonly></td>
                                                <td><input type="number" class="form-control input-number sgst item-field" name="items[{{ $index }}][sgst]" value="{{ $item->sgst ?? 0 }}" placeholder="SGST" min="0" max="100" step="0.01" data-tabindex="{{ 24 + ($index * 11) }}" readonly></td>
                                                <td><input type="number" class="form-control input-number cgst item-field" name="items[{{ $index }}][cgst]" value="{{ $item->cgst ?? 0 }}" placeholder="CGST" min="0" max="100" step="0.01" data-tabindex="{{ 25 + ($index * 11) }}" readonly></td>
                                                <td><input type="number" class="form-control input-number igst item-field" name="items[{{ $index }}][igst]" value="{{ $item->igst ?? 0 }}" placeholder="IGST" min="0" max="100" step="0.01" data-tabindex="{{ 26 + ($index * 11) }}" readonly></td>
                                                <td><span class="tax-amount-display">0.00</span></td>
HTML;

$content = str_replace($oldEditRow, $newEditRow, $content);

// 3. Update create mode item row (empty/new row)
$oldCreateRow = <<<'HTML'
                                            <td class="text-center sr-no">1</td>
                                            <td><input type="text" class="form-control item-field" name="items[0][p]" placeholder="P" data-tabindex="17"></td>
                                            <td><input type="text" class="form-control item-field" name="items[0][item_name]" placeholder="Item Name" data-tabindex="18"></td>
                                            <td><input type="text" class="form-control item-field" name="items[0][pack]" placeholder="Pack" data-tabindex="19"></td>
                                            <td><input type="text" class="form-control item-field" name="items[0][grn_no]" placeholder="GRN No" data-tabindex="20"></td>
                                            <td><input type="number" class="form-control input-number quantity item-field" name="items[0][quantity]" placeholder="Quantity" min="0" step="1" data-tabindex="21"></td>
                                            <td><input type="number" class="form-control input-number net-rate item-field" name="items[0][net_rate]" placeholder="Net Rate" min="0" step="1" data-tabindex="22"></td>
                                            <td><input type="number" class="form-control input-number discount item-field" name="items[0][discount]" placeholder="Discount" min="0" step="1" data-tabindex="23"></td>
                                            <td><input type="number" class="form-control input-number amount" name="items[0][amount]" placeholder="Amount" readonly></td>
                                            <td>
                                                <input type="number" class="form-control tax-input tax-percent item-field" name="items[0][tax_percent]" placeholder="%" min="0" max="100" step="1" value="0" data-tabindex="24">
                                                <span class="tax-amount-display">0.00</span>
                                            </td>
HTML;

$newCreateRow = <<<'HTML'
                                            <td class="text-center sr-no">1</td>
                                            <td><input type="text" class="form-control item-field" name="items[0][p]" placeholder="P" data-tabindex="17"></td>
                                            <td>
                                                <input type="hidden" class="item-id" name="items[0][item_id]">
                                                <select class="form-control item-dropdown select2" name="items[0][item_name_select]" data-tabindex="18">
                                                    <option value="">Select Item</option>
                                                    @foreach($rawMaterials as $material)
                                                        <option value="{{ $material->id }}" 
                                                            data-rate="{{ $material->purchase_rate }}" 
                                                            data-sgst="{{ $material->sgst }}" 
                                                            data-cgst="{{ $material->cgst }}" 
                                                            data-igst="{{ $material->igst }}">
                                                            {{ $material->item_name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </td>
                                            <td><input type="text" class="form-control item-field" name="items[0][pack]" placeholder="Pack" data-tabindex="19"></td>
                                            <td><input type="text" class="form-control item-field" name="items[0][grn_no]" placeholder="GRN No" data-tabindex="20"></td>
                                            <td><input type="number" class="form-control input-number quantity item-field" name="items[0][quantity]" placeholder="Quantity" min="0" step="1" data-tabindex="21"></td>
                                            <td><input type="number" class="form-control input-number net-rate item-field" name="items[0][net_rate]" placeholder="Net Rate" min="0" step="0.01" data-tabindex="22"></td>
                                            <td><input type="number" class="form-control input-number discount item-field" name="items[0][discount]" placeholder="Discount" min="0" step="0.01" data-tabindex="23"></td>
                                            <td><input type="number" class="form-control input-number amount" name="items[0][amount]" placeholder="Amount" readonly></td>
                                            <td><input type="number" class="form-control input-number sgst item-field" name="items[0][sgst]" placeholder="SGST" min="0" max="100" step="0.01" value="0" data-tabindex="24" readonly></td>
                                            <td><input type="number" class="form-control input-number cgst item-field" name="items[0][cgst]" placeholder="CGST" min="0" max="100" step="0.01" value="0" data-tabindex="25" readonly></td>
                                            <td><input type="number" class="form-control input-number igst item-field" name="items[0][igst]" placeholder="IGST" min="0" max="100" step="0.01" value="0" data-tabindex="26" readonly></td>
                                            <td><span class="tax-amount-display">0.00</span></td>
HTML;

$content = str_replace($oldCreateRow, $newCreateRow, $content);

echo "Updated table headers\n";
echo "Updated edit mode item rows\n";
echo "Updated create mode item rows\n";

// Save the file
file_put_contents($filePath, $content);

echo "File updated successfully!\n";
echo "Backup saved to: {$filePath}.backup\n";
