<!DOCTYPE html>
<html lang="en">
<?php
	$sitesetting = App\Models\Sitesetting::first();
?>
<head>
	<meta charset="UTF-8">
	<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="Description" content="">
	<meta name="Author" content="">
	<meta name="Keywords" content="" />
	<title> <?php echo e($title ??'Turbo Cast'); ?> | <?php echo e(config('app.name')); ?> </title> 
	<link rel="icon" href="<?php echo e(url($sitesetting->image)); ?>" type="image/x-icon"/>
	<link href="<?php echo e(url('assets/admin')); ?>/css/icons.css" rel="stylesheet">
	<link href="<?php echo e(url('assets/admin')); ?>/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="<?php echo e(url('assets/admin')); ?>/css/style.css" rel="stylesheet">
	<link href="<?php echo e(url('assets/admin')); ?>/css/custom.css" rel="stylesheet">
	<link href="<?php echo e(url('assets/admin')); ?>/css/animate.css" rel="stylesheet">
</head>

<body class="ltr error-page1 main-body bg-light text-dark error-3">
	<div id="global-loader">
		<img src="<?php echo e(url('assets/admin')); ?>/images/loader.svg" class="loader-img" alt="Loader">
	</div>
	<div class="page max-height">
		<div class="main-container container-fluid p-0">
			<div class="row no-gutter">
				<div class="col-md-12  col-xl-9 d-none d-xl-block bg-primary-transparent p-0">
					<div class="h-100">
						<img src="<?php echo e(url('assets/admin')); ?>/images/turbo-login.jpg"
							class="w-100 h-100" alt="logo">
					</div>
				</div>
				<div class="col-md-12  col-xl-3 bg-white px-4 px-xxl-5">
					<div class="login d-flex align-items-center py-2">
						<div class="card-sigin w-100">
							<div class="mb-3 d-flex justify-content-center">
								<a href="#" class="text-center">
									<img src="<?php echo e(url($sitesetting->image)); ?>" class="sign-favicon-a " width="100%" height="100%"  alt="logo">
									<img src="<?php echo e(url($sitesetting->image)); ?>" class="sign-favicon-b " width="100%" height="100%" alt="logo">
								</a>
							</div>
							<div class="card-sigin">
								<div class="main-signup-header">
									<div class="text-center">
										<h2>Welcome back!</h2>
										<h5 class="fw-semibold mb-4">Please sign in to continue.</h5>
									</div>
									<?php if(session('success')): ?>
										<div class="alert alert-success" role="alert">
											<?php echo e(session('success')); ?>

										</div>
									<?php endif; ?>
									<form id="loginForm" action="<?php echo e(url('secure-dashboard/authenticate')); ?>"  method="post">
										<?php echo e(csrf_field()); ?>

										<div class="form-group <?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
											<label>Email</label> 
											<input class="form-control" placeholder="Enter your email" type="text" value="<?php echo e(old('email')); ?>" name="email">
											<span class="help-block" ><strong><?php echo e($errors->first('email')); ?></strong></span>
											<?php if($errors->any()): ?>
												<div class="alert alert-danger alert-dismissible fade show custom-alert-icon shadow-sm" role="alert"> 
													<svg class="svg-danger" xmlns="http://www.w3.org/2000/svg" height="1.5rem" viewBox="0 0 24 24" width="1.5rem" fill="#000000"><path d="M0 0h24v24H0z" fill="none"></path><path d="M15.73 3H8.27L3 8.27v7.46L8.27 21h7.46L21 15.73V8.27L15.73 3zM12 17.3c-.72 0-1.3-.58-1.3-1.3 0-.72.58-1.3 1.3-1.3.72 0 1.3.58 1.3 1.3 0 .72-.58 1.3-1.3 1.3zm1-4.3h-2V7h2v6z"></path></svg> 
													<?php echo e($errors->first()); ?>

													<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
														<i class="bi bi-x"></i>
													</button> 
												</div>
											<?php endif; ?>
										</div>
										<div class="form-group <?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
											<label>Password</label> 
											<div class="input-group">
												<input class="form-control eye_view_password" placeholder="Enter your password" type="password" name="password">
												<span class="input-group-text toggle-password cursur-pointer" ><i class="fa fa-eye-slash"></i></span>
											</div>
											<span class="help-block" >
												<strong><?php echo e($errors->first('password')); ?></strong>
											</span>
										</div>
										<div class="form-group d-flex align-items-center mb-0">
											<input class="form-check mx-2 " type="checkbox" id="termsCheckbox">
											<label class="form-check-label" for="termsCheckbox">
												I agree to the <a target="_blank" href="<?php echo e(url('/terms-and-conditions')); ?>">terms and conditions</a>
											</label>
										</div>
										<div id="checkboxError" class="text-danger" style="display: none;">
											You must agree to the terms and conditions.
										</div>
										<button class="btn btn-primary btn-block mt-3">Sign In</button>
										<div class="text-center mt-2">
											<a href="<?php echo e(url('secure-dashboard/password/email')); ?>" class="text-center" type="button">
												Forgot Your Password?
											</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<script src="<?php echo e(url('assets/admin')); ?>/plugins/jquery/jquery.min.js"></script>
	<script src="<?php echo e(url('assets/admin')); ?>/plugins/bootstrap/js/popper.min.js"></script>
	<script src="<?php echo e(url('assets/admin')); ?>/plugins/bootstrap/js/bootstrap.min.js"></script>
	<script src="<?php echo e(url('assets/admin')); ?>/plugins/moment/moment.js"></script>
	<script src="<?php echo e(url('assets/admin')); ?>/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
	<script src="<?php echo e(url('assets/admin')); ?>/js/eva-icons.min.js"></script>
	<script src="<?php echo e(url('assets/admin')); ?>/plugins/ratings-2/jquery.star-rating.js"></script>
	<script src="<?php echo e(url('assets/admin')); ?>/plugins/ratings-2/star-rating.js"></script>
	<script src="<?php echo e(url('assets/admin')); ?>/js/themecolor.js"></script>
	<script src="<?php echo e(url('assets/admin')); ?>/js/custom.js"></script>
	<script>
		$(document).ready(function () {
			$('#loginForm').submit(function (event) {
				if (!$('#termsCheckbox').is(':checked')) {
					event.preventDefault(); 
					$('#checkboxError').show(); 
				} else {
					$('#checkboxError').hide(); 
				}
			});
		});
		$(document).on('click', '.toggle-password', function () {
			const $input = $(this).siblings('.eye_view_password');
			const $icon = $(this).find('i');

			const type = $input.attr('type') === 'password' ? 'text' : 'password';
			$input.attr('type', type);
			$icon.toggleClass('fa-eye fa-eye-slash');
		});
	</script>
</body>

</html><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/login.blade.php ENDPATH**/ ?>