<!-- resources/views/emails/password_reset.blade.php -->

<!DOCTYPE html>
<html>
<head>
    <title>Password Reset</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            padding: 20px 0;
        }
        .logo {
            max-width: 120px;
            height: auto;
        }
        .content {
            background-color: #f8f8f8;
            border-radius: 8px;
            padding: 30px;
            margin-bottom: 20px;
        }
        .button {
            display: inline-block;
            background-color: #56736C;
            color: white !important;
            text-decoration: none;
            padding: 12px 24px;
            border-radius: 4px;
            font-weight: bold;
            margin: 20px 0;
            text-align: center;
        }
        .footer {
            font-size: 12px;
            color: #888888;
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid #eeeeee;
        }
        .help-text {
            font-size: 14px;
            color: #666666;
        }
    </style>
</head>
<body style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f5f5f5;">
    <!-- Main Table -->
    <table border="0" cellpadding="0" cellspacing="0" width="100%" style="background-color: #f5f5f5;">
        <tr>
            <td align="center" style="padding: 20px 0;">
                <!-- Content Table -->
                <table border="0" cellpadding="0" cellspacing="0" width="600" style="background-color: #ffffff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);">
                    <!-- Header -->
                    <tr>
                        <td align="center" style="padding: 30px 0 20px 0;">
                            <img src="https://project.singimarketing.com/public/uploads/sitesetting/5967881761741684453.gif" alt="Company Logo" width="90" height="90" style="display: block;" />
                        </td>
                    </tr>
                    
                    <!-- Content -->
                    <tr>
                        <td style="padding: 0 30px 30px 30px;">
                            <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                <tr>
                                    <td style="font-size: 22px; font-weight: bold; color: #333333; padding-bottom: 20px;">
                                        Password Reset Request
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size: 16px; line-height: 24px; color: #333333; padding-bottom: 15px;">
                                        Hello,
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size: 16px; line-height: 24px; color: #333333; padding-bottom: 25px;">
                                        We received a request to reset your password. If you made this request, please click the button below to create a new password:
                                    </td>
                                </tr>
                                <tr>
                                    <td align="center" style="padding: 10px 0 25px 0;">
                                        <!-- Button Table -->
                                        <table border="0" cellpadding="0" cellspacing="0">
                                            <tr>
                                                <td align="center" bgcolor="#56736C" style="border-radius: 4px;">
                                                    <a href="<?php echo e($url); ?>" target="_blank" style="display: inline-block; padding: 15px 25px; font-size: 16px; font-weight: bold; color: #ffffff; text-decoration: none;">Reset Password</a>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size: 14px; line-height: 22px; color: #666666; padding-bottom: 20px;">
                                        This link will expire in 24 hours for security reasons.
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size: 16px; line-height: 24px; color: #333333; padding-bottom: 20px;">
                                        If you didn't request a password reset, you can safely ignore this email. Your account security is important to us, and your password will remain unchanged.
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size: 16px; line-height: 24px; color: #333333; padding-bottom: 10px;">
                                        If you're having trouble with the button above, copy and paste the URL below into your web browser:
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size: 14px; line-height: 22px; color: #1a73e8; padding-bottom: 25px; word-break: break-all;">
                                        <a href="#" style="color: #1a73e8; text-decoration: underline;"><?php echo e($url); ?></a>
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size: 16px; line-height: 24px; color: #333333; padding-bottom: 5px;">
                                        Thank you,
                                    </td>
                                </tr>
                                <tr>
                                    <td style="font-size: 16px; line-height: 24px; color: #333333;">
                                        The Support Team
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                
                <!-- Footer -->
                <table border="0" cellpadding="0" cellspacing="0" width="600">
                    <tr>
                        <td align="center" style="padding: 20px 0 0 0; color: #888888; font-size: 12px; line-height: 18px;">
                            This email was sent to you because someone requested a password reset for your account.
                        </td>
                    </tr>
                    <tr>
                        <td align="center" style="padding: 10px 0 30px 0; color: #888888; font-size: 12px; line-height: 18px;">
                            © 2025 singimarketing. All rights reserved.
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/user/password/email_template.blade.php ENDPATH**/ ?>