<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Firm</h4>
                    <span class="text-muted mt-1 tx-13 ms-2 mb-0">
                        / <?php echo e($firm->id ? 'Edit Firm' : 'Create Firm'); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card box-shadow-0">
                    <div class="card-header">
                        <p class="mb-2"></p>
                    </div>

                    <form id="firmForm"
                        method="POST"
                        action="<?php echo e($firm->id ? route('admin.firms.update', $firm->id) : route('admin.firms.store')); ?>"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php if($firm->id): ?>
                            <?php echo method_field('PUT'); ?>
                        <?php endif; ?>

                        <div class="card-body pt-0">
                            <?php echo $__env->make('admin.firms.form', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>

                        <div class="card-footer">
                            <a href="<?php echo e(route('admin.firms.index')); ?>" class="btn btn-secondary">Back</a>
                            <button type="submit" id="submitBtn" class="btn btn-primary float-end">
                                <?php echo e($firm->id ? 'Update' : 'Submit'); ?>

                            </button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

$(document).ready(function () {
    $('#state, #city').select2({
        placeholder: "-- Select --",
        allowClear: true
    });

    $.validator.addMethod("pattern", function (value, element, param) {
        if (this.optional(element)) return true;
        if (typeof param === "string") param = new RegExp(param);
        return param.test(value);
    }, "Invalid format.");

    $.validator.addMethod("filesize", function (value, element, param) {
        if (!element.files || element.files.length === 0) return true;
        return element.files[0].size <= param * 1024;
    }, "File must be less than {0} KB");

    $("#firmForm").validate({
        ignore: [],
        rules: {
            firm_name: { required: true, maxlength: 255 },
            firm_type: { required: true, maxlength: 255 },
            registration_number: { required: true, maxlength: 255 },
            owner_name: { required: true, maxlength: 255 },
            email: { required: true, email: true },
            mobile_number: { required: true, digits: true, minlength: 10, maxlength: 10 },
            gst_number: {
                required: true,
                pattern: /^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}Z[0-9A-Z]{1}$/
            },
            address_line1: { required: true, maxlength: 1000 },
            state: { required: true },
            city: { required: true },
            country: { required: true, maxlength: 100 },
            pincode: { digits: true, minlength: 6, maxlength: 6 },
            bank_name: { maxlength: 255 },
            account_number: { digits: true, minlength: 8, maxlength: 20 },
            ifsc_code: { pattern: /^[A-Z]{4}0[A-Z0-9]{6}$/ },
            pan_number: { required: true, pattern: /^[A-Z]{5}[0-9]{4}[A-Z]{1}$/ },
            aadhar_number: { required: true, digits: true, minlength: 12, maxlength: 12 },
            status: { required: true },
            logo: { extension: "jpeg|jpg|png|gif", filesize: 5120 }
        },
        messages: {
            firm_name: "Please enter firm name.",
            firm_type: "Please select firm type.",
            registration_number: "Please enter registration number.",
            owner_name: "Please enter owner name.",
            email: {
                required: "Please enter email address.",
                email: "Please enter valid email address."
            },
            mobile_number: {
                required: "Please enter mobile number.",
                digits: "Mobile number must contain only digits.",
                minlength: "Mobile number must be 10 digits long.",
                maxlength: "Mobile number must be 10 digits long."
            },
            gst_number: {
                required: "Please enter GST number.",
                pattern: "Invalid GST format (e.g., 22AAAAA0000A1Z5)."
            },
            address_line1: "Please enter address.",
            state: "Please select state.",
            city: "Please select city.",
            country: "Please enter country name.",
            pincode: {
                digits: "Pincode must contain only digits.",
                minlength: "Pincode must be 6 digits long.",
                maxlength: "Pincode must be 6 digits long."
            },
            bank_name: "Please enter bank name.",
            account_number: {
                digits: "Account number must contain only digits.",
                minlength: "Account number must be at least 8 digits.",
                maxlength: "Account number cannot exceed 20 digits."
            },
            ifsc_code: {
                pattern: "Invalid IFSC format (e.g., SBIN0001234)."
            },
            pan_number: {
                required: "Please enter PAN number.",
                pattern: "Invalid PAN format (e.g., ABCDE1234F)."
            },
            aadhar_number: {
                required: "Please enter Aadhar number.",
                digits: "Aadhar number must contain only digits.",
                minlength: "Aadhar number must be 12 digits long.",
                maxlength: "Aadhar number must be 12 digits long."
            },
            status: "Please select firm status.",
            logo: "Please upload valid image (JPEG, PNG, JPG, or GIF, up to 5 MB)."
        },
        errorPlacement: function (error, element) {
            if (element.hasClass("select2-hidden-accessible")) {
                error.insertAfter(element.next('span.select2'));
            } else {
                error.insertAfter(element);
            }
        }
    });

    $('#firmForm').on('submit', function (e) {
        e.preventDefault();

        if (!$("#firmForm").valid()) return; 

        const $btn = $('#submitBtn');
        $btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');

        let formData = new FormData(this);

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            cache: false,
            success: function (response) {
                Swal.fire('Success', response.message || 'Saved!', 'success');
                if (response.redirect_url) {
                    setTimeout(() => window.location.href = response.redirect_url, 800);
                }
            },
            error: function (xhr) {
                $btn.prop('disabled', false).html('<?php echo e($firm->id ? "Update" : "Submit"); ?>');
                if (xhr.status === 422) {
                    let errors = xhr.responseJSON.errors;
                    $('.text-danger').text('');
                    $.each(errors, function (key, value) {
                        let $field = $('[name="' + key + '"]');
                        let $err = $field.closest('.mb-3').find('.text-danger');
                        if ($err.length === 0) {
                            $field.after('<span class="text-danger">' + value[0] + '</span>');
                        } else {
                            $err.text(value[0]);
                        }
                    });
                } else {
                    Swal.fire('Error', xhr.responseJSON?.message || 'Something went wrong', 'error');
                }
            }
        });
    });

    $('input[name="pan_number"]').on('keyup', function () {
        this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '').substring(0, 10);
    });

    $('input[name="aadhar_number"]').on('keyup', function () {
        this.value = this.value.replace(/\D/g, '').substring(0, 12);
    });

    $("input[type='file']").on('change', function () {
        const $input   = $(this);
        const $preview = $input.closest('.col-md-4, .col-md-6, .col-md-8')
                               .find('.image-preview');

        if (this.files && this.files[0]) {
            const reader = new FileReader();
            reader.onload = e => $preview.attr('src', e.target.result).show();
            reader.readAsDataURL(this.files[0]);
        } else {
            $preview.hide();
        }
    });

});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/firms/create.blade.php ENDPATH**/ ?>