<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration Details</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.1;
            color: #333;
            background-color: #ffffff;
            padding: 20px;
        }
        
        .main-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        .company-cell {
            width: 70%;
            vertical-align: top;
            padding: 10px;
        }

        .logo-cell {
            width: 20%;
            text-align: center;
        }

        .company-name {
            font-size: 30px;
            margin: 0;
            padding: 0;
            margin-bottom: 5px;
            font-weight: bold;
        }

        .company-tagline {
            background-color: #32A5DE;
            color: #fff;
            padding: 5px 15px;
            margin: 0;
            font-size: 14px;
            font-weight: normal;
            margin-bottom: 10px;
        }

        .customer-cell {
            padding: 3px 5px !important;
        }

        .contact-table {
            width: 100%;
            border-collapse: collapse;
        }

        .contact-left {
            width: 50%;
            vertical-align: top;
            padding-right: 10px;
        }

        .contact-right {
            width: 50%;
            vertical-align: top;
            text-align: right;
        }

        .contact-table p {
            margin: 2px 0;
            font-size: 12px;
        }

        .logo-img {
            max-width: 150px;
            max-height: 150px;
        }
        
       
        
       
        
        .content {
            padding: 30px;
        }
        
        .section-title {
            font-size: 18px;
            font-weight: bold;
            color: #2c3e50;
            margin-bottom: 15px;
            padding-bottom: 5px;
            border-bottom: 2px solid #3498db;
        }
        
        .details-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            border: 1px solid #ddd;
        }
        
        .details-table th,
        .details-table td {
            padding: 4px 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
            vertical-align: top;
        }
        
        .details-table th {
            background-color: #f8f9fa;
            font-weight: bold;
            color: #2c3e50;
            width: 35%;
        }
        
        .details-table td {
            background-color: #ffffff;
            color: #333;
        }
        
        
        
        .file-info {
            color: #27ae60;
            font-style: italic;
        }
        
        .section-divider {
            height: 20px;
            border-bottom: 1px solid #eee;
            margin: 20px 0;
        }
        
        .footer-note {
            text-align: center;
            padding: 20px;
            background-color: #f8f9fa;
            color: #666;
            font-size: 12px;
            border-top: 1px solid #ddd;
            margin-top: 30px;
        }
        
        .date-generated {
            text-align: right;
            color: #666;
            font-size: 12px;
            margin-bottom: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <table class="main-table">
            <tr>
                <td class="company-cell no-border">
                    <h1 class="company-name" style="text-transform: uppercase;"><?php echo e($sitesetting->comp_name); ?></h1>
                    <h5 class="company-tagline"><?php echo e($sitesetting->comp_name); ?></h5>
                    
                    <table class="contact-table no-border">
                        <tr class="no-border">
                            <td class="contact-left no-border">
                                <p><?php echo $sitesetting->comp_address; ?></p>
                            </td>
                            <td class="contact-right no-border">
                                <p>Tel: <?php echo e($sitesetting->comp_phone); ?></p>
                                <p>Email: <?php echo e($sitesetting->comp_email); ?></p>
                            </td>
                        </tr>
                    </table>
                </td>
                <td class="logo-cell no-border" >
                    <div style="border: 2px solid #ccc; background-color: #f9f9f9; height:120px;">
                        <img style="height:120px;" src="<?php echo e(base_path('public/'.$sitesetting->image)); ?>" class="logo-img" alt="logo">
                    </div>
                    
                </td>
            </tr>
        </table>
        
        <div class="content">
            <div class="date-generated">
                Generated on: September 26, 2025 | Registration ID: REG-2025-001
            </div>
            
            <!-- Personal Information Section -->
            <div class="section-title">Personal Information</div>
            <table class="details-table">
                <tr>
                    <th>Full Name</th>
                    <td>John Doe</td>
                </tr>
                <tr>
                    <th>Mobile Number</th>
                    <td>+91 98765 43210</td>
                </tr>
                <tr>
                    <th>Email Address</th>
                    <td>john.doe@email.com</td>
                </tr>
                <tr>
                    <th>Address</th>
                    <td>123 Main Street, Rajkot, Gujarat - 360001</td>
                </tr>
                <tr>
                    <th>City</th>
                    <td>Rajkot</td>
                </tr>
                <tr>
                    <th>State</th>
                    <td>Gujarat</td>
                </tr>
            </table>
            
            <!-- Professional Information Section -->
            <div class="section-title">Professional Information</div>
            <table class="details-table">
                <tr>
                    <th>Job Type</th>
                    <td>Office Manager</td>
                </tr>
                <tr>
                    <th>Qualification</th>
                    <td>MBA in Marketing</td>
                </tr>
                <tr>
                    <th>Total Experience</th>
                    <td>5 Years</td>
                </tr>
                <tr>
                    <th>Previous Company</th>
                    <td>ABC Marketing Ltd</td>
                </tr>
                <tr>
                    <th>Years at Previous Company</th>
                    <td>3 Years</td>
                </tr>
                <tr>
                    <th>Previous Post/Role</th>
                    <td>Marketing Executive</td>
                </tr>
            </table>
            
            <!-- Identity & Banking Information Section -->
            <div class="section-title">Identity & Banking Details</div>
            <table class="details-table">
                <tr>
                    <th>PAN Card Number</th>
                    <td>ABCDE1234F</td>
                </tr>
                <tr>
                    <th>Aadhar Card Number</th>
                    <td>1234 5678 9012</td>
                </tr>
                <tr>
                    <th>Bank Name</th>
                    <td>State Bank of India</td>
                </tr>
                <tr>
                    <th>Account Number</th>
                    <td>123456789012</td>
                </tr>
                <tr>
                    <th>IFSC Code</th>
                    <td>SBIN0001234</td>
                </tr>
            </table>

            <div class="section-title">Uploaded Documents</div>
            <table class="details-table">
                <tr>
                    <th>Resume</th>
                    <td><span class="file-info">✓ resume_johndoe.pdf (2.3 MB)</span></td>
                </tr>
                <tr>
                    <th>Aadhar Card</th>
                    <td><span class="file-info">✓ aadhar_card.pdf (1.8 MB)</span></td>
                </tr>
                <tr>
                    <th>PAN Card</th>
                    <td><span class="file-info">✓ pan_card.jpg (0.9 MB)</span></td>
                </tr>
                <tr>
                    <th>Bank Statement/Passbook</th>
                    <td><span class="file-info">✓ bank_statement.pdf (3.2 MB)</span></td>
                </tr>
                <tr>
                    <th>Profile Photo</th>
                    <td><span class="file-info">✓ profile_photo.jpg (1.1 MB)</span></td>
                </tr>
            </table>
            
        </div>
        
        <div class="footer-note">
            This is a system generated document. Registration completed successfully.<br>
            For any queries, please contact us at info@singimarketing.com or call +91-XXXXXXXXXX
        </div>
    </div>
</body>
</html><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/user/pdf/carrer_pdf_test.blade.php ENDPATH**/ ?>