<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto animate-charcter" >Purchase Group Details</h4>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
                <div class="pe-1 mb-xl-0">
                    <?php if(rolemanagement('Purchase Group', 2)): ?>
                        <button type="button" class="btn btn-primary" onclick="addPurchaseGroup();" >
                            Add Purchase Group
                        </button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="card-header pb-0 card_filter">
                <div class="d-flex justify-content-end align-items-center pb-2">
                    <button id="toggleFilter" class="btn btn-secondary"><i class="fas fa-filter"></i> Filter</button>
                </div>
            </div>
            <div class="card-body toggler_filter">
                <div class="row align-items-center my-xl-auto right-content">
                    <div class="col-md-12 mb-2">
                        <form  id="searchForm" >
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 mb-2">
                                    <label class="form-label"> Purchase Group Name</label>
                                    <input type="text" id="name"  class="form-control" placeholder="Enter Purchase Group Name">
                                </div>
                                <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 mb-2">
                                    <label class="form-label">Category</label>
                                    <select class="form-select my-select" name="category_id" id="category_id">
                                        <option value="">Choose a Category...</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-xxl-2 col-xl-3 col-md-4 mb-2">
                                    <label class="form-label">Status</label>
                                     <select class="form-select my-select" name="status" id="status">
                                        <option value="" >Choose a Status...</option>
                                        <option value="Active" >Active</option>
                                        <option value="Inactive" >Inactive</option>
                                    </select>
                                </div>
                                <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 mb-2">
                                    <label class="form-label"> Start Date</label>
                                    <input type="text" id="start_date"  class="form-control scheduleTime" placeholder="Date" >
                                </div>
                                <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 mb-2">
                                    <label class="form-label"> End Date</label>
                                    <input type="text" id="end_date"  class="form-control scheduleTime" placeholder="Date" >
                                </div>
                                <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 mb-2">
                                    <div class="d-flex flex-wrap flex-md-nowrap align-items-baseline gap-2">
                                        <div>
                                            <div class="form-label">&nbsp;</div>
                                            <button type="button" class="btn btn-primary" id="searchBtn">Search</button>
                                        </div>
                                        <div>
                                            <div class="form-label">&nbsp;</div>
                                            <button type="button" class="btn btn-danger" id="resetBtn">Reset</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="row row-sm"> 
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card ">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom " id="example1">
                                <thead>
                                    <tr>
                                        <th ><span>Sr No.</span></th>
                                        <th ><span>Name</span></th>
                                        <th ><span>Category</span></th>
                                        <th ><span>Status</span></th>
                                        <th ><span>Created At</span></th>
                                        <th ><span>Updated At</span></th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                               
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered ">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Creat Purchase Group</h5>
          <button type="button" class="btn-close" onclick="closeModal();" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="cat_form">

        </div>
        <div class="submission_loader d-none">
            <div class="submission_loader-overlay d-flex justify-content-center align-items-center">
                <div class="spinner-border text-primary submission_loader-spinner" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </div>
        </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
  var myModal = new bootstrap.Modal(document.getElementById('exampleModal'), {
    keyboard: true 
  });
</script>
<script>
    flatpickr(".scheduleTime", {
        enableTime: true,
        dateFormat: "d-m-Y H:i:S",
        time_24hr: true,
        defaultDate: false,
        allowClear: true,
        onChange: function(selectedDates, dateStr, instance) {
            const selected = selectedDates[0];
            const selectedTime = selected.getHours() * 60 + selected.getMinutes();

            const [startHour, startMin] = $("#start_date").val().split(":").map(Number);
            const [endHour, endMin] = $("#end_date").val().split(":").map(Number);
            const startTime = startHour * 60 + startMin;
            const endTime = endHour * 60 + endMin;

            if (selectedTime < startTime || selectedTime > endTime) {
                alert(`Please select a time between ${$("#start_date").val()} and ${$("#end_date").val()}`);
                instance.clear();
            }
        }
    });
    jQuery(document).ready(function () {
        var oTable = $('#example1').DataTable({
            "responsive": false, "lengthChange": true, "autoWidth": false, "pageLength": 10,
            "buttons": [],
                stateSave: true,
                processing: true,
                serverSide: true,
                searching: false,
                dom:'lBfrtip',
                ajax:{ 
                    url: "<?php echo e(route('admin.purchasegroup.index')); ?>",
                    type: 'get',
                    data: function (d) {
                        d._token = "<?php echo e(csrf_token()); ?>";
                        d.name = $('#name').val();
                        d.start_date = $('#start_date').val();
                        d.end_date = $('#end_date').val();  
                        d.status = $('#status').val();
                        d.category_id = $('#category_id').val();
                        d.search = {
                            value: $('input[type="search"]').val()  
                        };
                    },
                    },
                columns: [
                    {data: 'id', name: 'id',orderable : false, searchable: false,className : 'text-center custom',defaultContent:'-'},
                    {data: 'name', name: 'name',className : 'text-center'},
                    {data: 'category_name', name: 'category_name',className : 'text-center'},
                    {data: 'status', name: 'status',orderable : false,className : 'text-center check-align-center', searchable: false},
                    {data: 'created_at', name: 'created_at',orderable : false,className : 'text-center', searchable: false},
                    {data: 'updated_at', name: 'updated_at',orderable : false,className : 'text-center', searchable: false},
                    {data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
                ]
                
        });
        $('#searchBtn').on('click', function () {
            oTable.ajax.reload();
        });
        $('#resetBtn').on('click', function () {
            $('input').val('');
            $('#searchForm select').val('').trigger('change');
            oTable.ajax.reload();
        });
        $("body").on("change", "#statusToggle", function () {
            var id = $(this).data('id');
            var currentStatus = jQuery(this).data('status');
            console.log(currentStatus);
            var toggleButton = $(this);
            Swal.fire({
                title: "Are you sure?",
                text: "you want to change this status ?",
                icon: "question",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, confirm it!"
                }).then((result) => {
                if (result.isConfirmed) {
                    jQuery.ajax({
                        url: "<?php echo e(route('admin.purchasegroup.sequence_update')); ?>",
                        type: 'post',
                        data: {
                            "_token": "<?php echo e(csrf_token()); ?>",
                            "id": id,
                            "currentStatus": currentStatus,
                        },
                        success: function (data) {
                            if(data.success == true){
                                toastr.success(data.message);
                                oTable.ajax.reload();
                            }
                        },
                        error: function (xhr, status, error) {
                            console.error(xhr.responseText);
                        }
                    });
                }else{
                    if(currentStatus == 'Active'){
                        $(this).prop('checked',true);
                    }else{
                        $(this).prop('checked',false);
                    }
                }
            });
        });

        $("body").on("click", ".data-delete", function () {
            Swal.fire({
                title: "Are you sure?",
                text: "Do you want to delete this record?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete it!"
                }).then((result) => {
                if (result.isConfirmed) {
                    var obj = jQuery(this);
                    var id = obj.attr('data-id');
                    var currentPage = oTable.page();
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(route('admin.purchasegroup.destroy')); ?>",
                            data: {
                                id: id,
                                _token: "<?php echo e(csrf_token()); ?>"
                            },
                            dataType: 'json',
                            beforeSend: function () {
                                obj.attr('disabled', true);
                                jQuery('.alert .msg-content').html('');
                                jQuery('.alert').hide();
                            },
                            success: function (resp) {
                                if(resp.success == true)
                                {
                                    toastr.success(resp.message);
                                    oTable.ajax.reload(null, false); 
                                    oTable.page(currentPage).draw(false);
                                }
                            }
                            
                        });
                }else{
                    oTable.ajax.reload();
                }
            });
        });

        $(document).on('change', '.image-input', function(e) {
            var file = this.files[0];
            var previewId = jQuery(this).data('preview');
            console.log(previewId);
            if (file) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    jQuery('#' + previewId).attr('src', e.target.result);
                };
                reader.readAsDataURL(file);
            } else {
                jQuery('#' + previewId).attr('src', '');
            }
        });

        $(document).on('input', '.digitonly', function() {
            this.value = this.value.replace(/[^0-9.]/g, ''); 
            if ((this.value.match(/\./g) || []).length > 1) {
                this.value = this.value.replace(/\.+$/, ''); 
            }
        });
        $(document).on('submit', '#purchaseGroupForm', function(e) {
            e.preventDefault();
            const $form = $(this);
            
            if (!validatePurchaseForm($form)) {
                return false;
            }
            
            $('.submission_loader').removeClass('d-none');
            $form.find("button[type='submit']").prop("disabled", true);
            
            submitForm($form, "<?php echo e(route('admin.purchasegroup.store')); ?>");
        });

        // Handle edit form submission
        $(document).on('submit', '#purchaseGroupEditForm', function(e) {
            e.preventDefault();
            $('.submission_loader').removeClass('d-none');
            $(this).find("button[type='submit']").prop("disabled", true);
            submitForm($(this), "<?php echo e(route('admin.purchasegroup.update')); ?>");
        });

        // Add this validation function
        function validatePurchaseForm(form) {
            let isValid = true;
            const $form = $(form);
            
            // Clear previous errors
            $form.find('.is-invalid').removeClass('is-invalid');
            $form.find('.invalid-feedback').remove();
            
            // Validate category_id
            const $category = $form.find('[name="category_id"]');
            if (!$category.val()) {
                showFieldError($category, 'Please select a category');
                isValid = false;
            }
            
            // Validate name
            const $name = $form.find('[name="name"]');
            if (!$name.val()) {
                showFieldError($name, 'Name is required');
                isValid = false;
            }
            
            return isValid;
        }

        // Add this helper function
        function showFieldError($field, message) {
            $field.addClass('is-invalid');
            $field.after(`<span class="invalid-feedback">${message}</span>`);
        }
        

        function submitForm(form, url) {
            $('select, input').removeClass('is-invalid');
            $('.invalid-feedback').remove();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
                }
            });
            let formData = new FormData(form[0]);
            
            $.ajax({
                url: url,
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                dataType: 'json',
                success: function(response) {
                    $('.submission_loader').addClass('d-none');
                    form.find("button[type='submit']").prop("disabled", false);
                    
                    if (response.success) {
                        oTable.ajax.reload();
                        toastr.success(response.message);
                        form[0].reset();
                        $('#exampleModal').modal('hide');
                    } else {
                        showErrors(response.message || response);
                    }
                },
                error: function(xhr) {
                    $('.submission_loader').addClass('d-none');
                    form.find("button[type='submit']").prop("disabled", false);
                    
                    try {
                        const response = JSON.parse(xhr.responseText);
                        showErrors(response.message || response.errors || 'An error occurred');
                    } catch (e) {
                        showErrors('An unexpected error occurred');
                    }
                }
            });
        }

        function showErrors(errors) {
            if (typeof errors === 'string') {
                toastr.error(errors);
                return;
            }
            Object.entries(errors).forEach(([key, value]) => {
                let input = $('[name="' + key + '"]');
                input.addClass('is-invalid');
                input.after('<span class="invalid-feedback" role="alert">' + value + '</span>');
            });
        }
    });

    function addPurchaseGroup(){
        $('#exampleModalLabel').html('Creat Purchase Group');
        $.ajax({
            url: "<?php echo e(route('admin.purchasegroup.create')); ?>",
            type: "POST",
            data: {
                "_token": "<?php echo e(csrf_token()); ?>",
            },
            dataType: 'json',
            success: function(response) {
                if (response.code === -1) {
                    Swal.fire({
                        title: 'Login Required',
                        text: response.message,
                        icon: 'warning',
                        confirmButtonText: 'Login Now'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = "<?php echo e(url('/login')); ?>";
                        }
                    });
                    return;
                }
                if (response.success == true) {
                    $('.cat_form').html(response.html);
                    $('#exampleModal').modal({
                                backdrop: 'static',
                                keyboard: false,
                        }).modal('show');
                }
            }
        });
    }
    function catedit(id){
        $('#exampleModalLabel').html('Edit Purchase Group');
        $.ajax({
            url: "<?php echo e(route('admin.purchasegroup.edit')); ?>",
            type: "POST",
            data: {
                "_token": "<?php echo e(csrf_token()); ?>",
                id:id,
            },
            dataType: 'json',
            success: function(response) {
                if (response.code === -1) {
                    Swal.fire({
                        title: 'Login Required',
                        text: response.message,
                        icon: 'warning',
                        confirmButtonText: 'Login Now'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = "<?php echo e(url('/login')); ?>";
                        }
                    });
                    return;
                }
                if (response.success == true) {
                    $('#purchaseGroupForm').hide();
                    $('.cat_form').html(response.html);
                    $('#exampleModal').modal({
                                backdrop: 'static',
                                keyboard: false,
                        }).modal('show');
                }
            }
        });
    }
    function closeModal(){
        $('#exampleModal').modal('hide');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/purchasegroup/index.blade.php ENDPATH**/ ?>