<form id="productForm"
    action="<?php echo e(isset($product) ? route('admin.raw_materials.update', $product->id) : route('admin.raw_materials.store')); ?>"
    method="POST">
    <?php echo csrf_field(); ?>
    <?php if(isset($product)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

    <div class="modal-body">

        <div class="row g-2">
            <!-- Column 1: Basic Information -->
            <div class="col-md-4">
                <div class="add_products_structure_col_wrapper">
                    <div class="add_products_structure_section">
                        <div class="add_products_structure_row">
                            <label>Item Name <span class="text-danger">*</span></label>
                            <div class="input_box">
                                <input type="text" name="item_name" class="form-control"
                                    value="<?php echo e(old('item_name', $product->item_name ?? '')); ?>">
                            </div>
                        </div>

                        <div class="add_products_structure_row">
                            <label>Billing Name</label>
                            <input type="text" name="billing_name" class="form-control"
                                value="<?php echo e(old('billing_name', $product->billing_name ?? '')); ?>">
                        </div>

                        <div class="add_products_structure_row">
                            <label>Short Name</label>
                            <input type="text" name="short_name" class="form-control"
                                value="<?php echo e(old('short_name', $product->short_name ?? '')); ?>">
                        </div>

                        <div class="add_products_structure_row">
                            <label>Unit Name <span class="text-danger">*</span></label>
                            <div class="input_box">
                                <input type="text" name="unit_name" class="form-control"
                                    value="<?php echo e(old('unit_name', $product->unit_name ?? '')); ?>">
                            </div>
                        </div>

                        <div class="add_products_structure_row">
                            <label>Purchase Rate <span class="text-danger">*</span></label>
                            <div class="input_box">
                                <input type="text" name="purchase_rate" class="form-control"
                                    value="<?php echo e(old('purchase_rate', $product->purchase_rate ?? '')); ?>">
                            </div>
                        </div>

                        <div class="add_products_structure_row">
                            <label>Opening Rate <span class="text-danger">*</span></label>
                            <div class="input_box">
                                <input type="text" name="opening_rate" class="form-control"
                                    value="<?php echo e(old('opening_rate', $product->opening_rate ?? '')); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Column 2: Category & Classification -->
            <div class="col-md-4">
                <div class="add_products_structure_col_wrapper">
                    <div class="add_products_structure_section">
                        <div class="add_products_structure_row">
                            <label>Category <span class="text-danger">*</span></label>
                            <div class="input_box">
                                <select name="category" id="category" class="form-control select2">
                                    <option value="">-- Select --</option>
                                    <?php $__currentLoopData = \App\Models\Category::where('status', 'Active')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cat->id); ?>" <?php echo e(old('category', $product->category_id ?? '') == $cat->id ? 'selected' : ''); ?>>
                                            <?php echo e($cat->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="add_products_structure_row">
                            <label>Group <span class="text-danger">*</span></label>
                            <div class="input_box">
                                <select name="group" id="group" class="form-control select2">
                                    <option value="">-- Select --</option>
                                    <?php if(isset($product) && $product->purchase_group_id): ?>
                                        <?php
                                            $group = \App\Models\PurchaseData\PurchaseGroup::find($product->purchase_group_id);
                                        ?>
                                        <?php if($group): ?>
                                            <option value="<?php echo e($group->id); ?>" selected><?php echo e($group->name); ?></option>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>

                        

                        <div class="add_products_structure_row">
                            <label>Bar Code</label>
                            <input type="text" name="bar_code" class="form-control"
                                value="<?php echo e(old('bar_code', $product->bar_code ?? '')); ?>">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Column 3: Tax Information -->
            <div class="col-md-4">
                <div class="add_products_structure_col_wrapper">
                    <div class="add_products_structure_section">
                        <div class="add_products_structure_row">
                            <label>Inclusive Tax <span class="text-danger">*</span></label>
                            <div class="input_box">
                                <select name="inclusive_tax1" id="inclusive_tax1" class="form-control select2">
                                    <option value="">-- Select --</option>
                                    <option value="Yes" <?php echo e(old('inclusive_tax1', $product->inclusive_tax ?? '') == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                                    <option value="No" <?php echo e(old('inclusive_tax1', $product->inclusive_tax ?? '') == 'No' ? 'selected' : ''); ?>>No</option>
                                </select>
                            </div>
                        </div>

                        <div class="gst-fields " style="display: none;" id="gst-fields">
                            <div class="add_products_structure_row">
                                <label>SGST - CGST % <span class="text-danger">*</span></label>
                                <div class="add_products_structure_input_group">
                                    <input type="text" name="sgst" class="form-control" placeholder="SGST"
                                        value="<?php echo e(old('sgst', $product->sgst ?? '')); ?>">
                                    <input type="text" name="cgst" class="form-control" placeholder="CGST"
                                        value="<?php echo e(old('cgst', $product->cgst ?? '')); ?>">
                                </div>
                            </div>

                            <div class="add_products_structure_row">
                                <label>IGST - Cess % <span class="text-danger">*</span></label>
                                <div class="input_box">
                                    <div class="add_products_structure_input_group">
                                        <input type="text" name="igst" class="form-control" placeholder="IGST"
                                            value="<?php echo e(old('igst', $product->igst ?? '')); ?>">
                                        <input type="text" name="cess" class="form-control" placeholder="Cess"
                                            value="<?php echo e(old('cess', $product->cess ?? '')); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="add_products_structure_row">
                            <label>HSN Code</label>
                            <input type="text" name="hsn_code" class="form-control"
                                value="<?php echo e(old('hsn_code', $product->hsn_code ?? '')); ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-2">
            <!-- Column 4: Inventory Management -->
            <div class="col-md-6">
                <div class="add_products_structure_col_wrapper">
                    <div class="add_products_structure_section">
                        <div class="add_products_structure_row">
                            <label>Maximum Qty</label>
                            <input type="text" name="maximum_qty" class="form-control"
                                value="<?php echo e(old('maximum_qty', $product->maximum_qty ?? '')); ?>">
                        </div>

                        <div class="add_products_structure_row">
                            <label>Minimum Qty</label>
                            <input type="text" name="minimum_qty" class="form-control"
                                value="<?php echo e(old('minimum_qty', $product->minimum_qty ?? '')); ?>">
                        </div>

                        <div class="add_products_structure_row">
                            <label>ReOrder Level</label>
                            <input type="text" name="reorder_level" class="form-control"
                                value="<?php echo e(old('reorder_level', $product->reorder_level ?? '')); ?>">
                        </div>

                        <div class="add_products_structure_row">
                            <label>ReOrder Qty</label>
                            <input type="text" name="reorder_qty" class="form-control"
                                value="<?php echo e(old('reorder_qty', $product->reorder_qty ?? '')); ?>">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Column 5: Additional Information -->
            <div class="col-md-6">
                <div class="add_products_structure_col_wrapper">
                    <div class="add_products_structure_section">
                        <div class="add_products_structure_row">
                            <label>Distribution Rate</label>
                            <select name="distribution_rate" class="form-control select2">
                                <option value="No" <?php echo e(old('distribution_rate', $product->distribution_rate ?? 'No') == 'No' ? 'selected' : ''); ?>>No</option>
                                <option value="Yes" <?php echo e(old('distribution_rate', $product->distribution_rate ?? '') == 'Yes' ? 'selected' : ''); ?>>Yes</option>
                            </select>
                        </div>

                        <div class="add_products_structure_row">
                            <label>Launch Date</label>
                            <input type="date" name="launch_date" class="form-control"
                                value="<?php echo e(old('launch_date', $product->launch_date ?? '')); ?>">
                        </div>

                        <div class="add_products_structure_row">
                            <label>Receipt Item</label>
                            <input type="text" name="receipt_item" class="form-control"
                                value="<?php echo e(old('receipt_item', $product->receipt_item ?? '')); ?>">
                        </div>

                        <div class="add_products_structure_row">
                            <label>Cost Rate</label>
                            <input type="text" name="cost_rate" class="form-control"
                                value="<?php echo e(old('cost_rate', $product->cost_rate ?? '')); ?>">
                        </div>

                        <div class="add_products_structure_row">
                            <label>RR Item</label>
                            <input type="text" name="rr_item" class="form-control"
                                value="<?php echo e(old('rr_item', $product->rr_item ?? '')); ?>">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal-footer">
        <button type="submit" class="btn btn-primary">
            <?php echo e(isset($product) ? 'Update' : 'Save'); ?> Product
        </button>
        <button type="button" class="btn btn-secondary" onclick="closeModal();">Close</button>
    </div>
</form>

<script>


    $(document).ready(function () {

        $('.select2').select2({
            placeholder: 'Choose one',
            searchInputPlaceholder: 'Search',
            width: '100%'
        });

        $('#category').on('change', function () {
            let categoryId = $(this).val();
            let groupSelect = $('#group');

            groupSelect.empty().append('<option value="">-- Select --</option>');

            if (categoryId) {
                $.ajax({
                    url: '/secure-dashboard/get-purchase-groups/' + categoryId,
                    type: 'GET',
                    success: function (response) {
                        if (response.length > 0) {
                            $.each(response, function (index, group) {
                                groupSelect.append(
                                    $('<option>', { value: group.id, text: group.name })
                                );
                            });
                        }
                    },
                    error: function () {
                        toastr.error('Failed to load groups');
                    }
                });
            }
        });


        // ✅ GST toggle function
        function toggleGSTFields() {
            const selectedValue = $('#inclusive_tax1').val();
            const gstFields = $('.gst-fields');

            if (selectedValue === 'Yes') {
                gstFields.slideDown(200);
            } else {
                gstFields.slideUp(200);
                gstFields.find('input').val('');
            }
        }

        // ✅ Bind event to Select2 & native change using delegated listener
        $(document).on('change select2:select', '#inclusive_tax1', function () {
            toggleGSTFields();
        });

        // ✅ Run on page load to set correct state based on old value
        toggleGSTFields();

    });



</script><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/raw_material/form.blade.php ENDPATH**/ ?>