<!DOCTYPE html>
<html lang="en">
    <head>
    <?php 
            $sitesetting = \App\Models\Sitesetting::first();
    ?>
        <title>Singi Marketing | Reset Password</title>
        <base href="<?php echo e(url('/')); ?>" />
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="author" content="Singi Marketing">
        <link rel="shortcut icon" href="<?php echo e((!empty($sitesetting) && !empty('$sitesetting->fevicon'))?url('/'.$sitesetting->fevicon):''); ?>" type="image/x-icon"> 
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Marcellus&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/bootstrap.min.css">
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/slick.css">
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/animate.min.css">
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/all.min.css">
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/youtube-popup.css">
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/select2.min.css">
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/style.css">
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/responsive.css">
        <link href="<?php echo e(url('public/assets/user')); ?>/toastr/toastr.min.css" rel="stylesheet">
    </head>
    <style>
         body {
            background: linear-gradient(135deg, #000000, #7a7e36);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .reset_password_form {
            background-color: white;
            border-radius: 10px;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
            padding: 30px;
            width: 100%;
            margin: 0 auto;
            max-width: 450px;
        }

        .logo-container {
            text-align: center;
            margin-bottom: 30px;
        }

        .company-logo {
            max-width: 150px;
            height: auto;
        }

        .form-title {
            text-align: center;
            color: #444;
            font-weight: 600;
            margin-bottom: 25px;
        }

        .form-floating {
            margin-bottom: 20px;
        }

        .password-container {
            position: relative;
        }

        .toggle-password {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #6c757d;
            z-index: 10;
        }

        .submit-btn {
            background: #56736C;
            border: none;
            color: #fff !important;
            font-weight: 500;
            font-size: 16px;
            padding: 12px;
            transition: all 0.3s ease;
        }

        .submit-btn:hover {
            transform: translateY(-2px);
            background:rgb(66, 87, 82);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
    </style>
    <body>
    
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12">
                <div class="logo-container">
                    <img src="<?php echo e((!empty($sitesetting) && !empty($sitesetting->image))?$sitesetting->image_url:''); ?>" style="width:90px;height:90px;" alt="header-logo">
                </div>
                
                <form class="reset_password_form">
                    <h2 class="form-title"><?php echo e(__('Reset Password')); ?></h2>
                    
                    <div class="form-floating mb-4">
                        <input id="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" value="<?php echo e(Request::get('email') ?? old('email')); ?>" required autocomplete="email" readonly autofocus>
                        <label for="email"><?php echo e(__('Email Address')); ?></label>
                    </div>
                    
                    <div class="form-floating mb-4 password-container">
                        <input name="password" type="password" class="form-control account__login--input <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="password"  autocomplete="off" required autocomplete="new-password">
                        <label for="password"><?php echo e(__('Password')); ?></label>
                        <span class="toggle-password" data-target="password">
                            <i class="fas fa-eye"></i>
                        </span>
                        <strong class="text-danger mt-2"><?php echo e($errors->first('password')); ?></strong>
                    </div>
                    
                    <div class="form-floating mb-4 password-container">
                        <input name="password_confirmation" type="password" class="form-control account__login--input <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="password-confirm"  autocomplete="off" required autocomplete="new-password">
                        <label for="confirmPassword"><?php echo e(__('Confirm Password')); ?></label>
                        <span class="toggle-password" data-target="password-confirm">
                            <i class="fas fa-eye"></i>
                        </span>
                    </div>
                    
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary btn-lg submit-btn"> <?php echo e(__('Reset Password')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
        <script src="<?php echo e(url('public/assets/user')); ?>/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo e(url('public/assets/user')); ?>/js/jquery-3.7.1.min.js"></script>
        <script src="<?php echo e(url('public/assets/user')); ?>/js/slick.min.js"></script>
        <script src="<?php echo e(url('public/assets/user')); ?>/js/wow.js"></script>
        <script src="<?php echo e(url('public/assets/user')); ?>/js/select2.min.js"></script>
        <script src="<?php echo e(url('public/assets/user')); ?>/js/youtube-popup.jquery.js"></script>
        <script src="<?php echo e(url('public/assets/user')); ?>/js/custom.js"></script>
        <script src="<?php echo e(url('public/assets/user')); ?>/toastr/toastr.min.js"></script>
        <script>
            $(document).ready(function() {
                $('.toggle-password').on('click', function() {
                    const targetId = $(this).data('target');
                    const passwordInput = $('#' + targetId);
                    const icon = $(this).find('i');
                    
                    if (passwordInput.attr('type') === 'password') {
                        passwordInput.attr('type', 'text');
                        icon.removeClass('fa-eye').addClass('fa-eye-slash');
                    } else {
                        passwordInput.attr('type', 'password');
                        icon.removeClass('fa-eye-slash').addClass('fa-eye');
                    }
                });
            });
        </script>  
    </body>
</html><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/user/password/reset.blade.php ENDPATH**/ ?>