<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Vendor Details</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ <?php if(empty($vendor)): ?> New   <?php else: ?> Edit <?php endif; ?> Vendor Details</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1"><?php if(empty($vendor)): ?> New   <?php else: ?> Edit <?php endif; ?> Vendor Details</h4>  
                        <p class="mb-2"></p>
                    </div>
                 
                    <?php echo e(html()->modelForm($vendor ?? new App\Models\VendorData\Vendor, !empty($vendor) ? 'PUT' : 'POST', !empty($vendor) ? route('admin.vendor.update', $vendor->id) : route('admin.vendor.store'))
                        ->attribute('id', 'myForm')  ->attribute('enctype', 'multipart/form-data') 
                        ->open()); ?>


                        <div class="card-body pt-0">
                            <?php echo $__env->make('admin.vendor.form', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>

                        <div class="card-footer ">
                            <a href="<?php echo e(url('secure-dashboard/vendor')); ?>" class="btn btn-secondary mb-3">Back</a>
                            
                        </div>

                    <?php echo e(html()->closeModelForm()); ?>


                </div>
            </div>
        </div>
	</div>
    <div class="submission_loader d-none">
        <div class="submission_loader-overlay d-flex justify-content-center align-items-center">
            <div class="spinner-border text-primary submission_loader-spinner" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

$(document).ready(function () {

  

    $.validator.addMethod("pattern", function (value, element, param) {
        if (this.optional(element)) return true;
        if (typeof param === "string") param = new RegExp(param);
        return param.test(value);
    }, "Invalid format.");

    // $.validator.addMethod("filesize", function (value, element, param) {
    //     if (!element.files || element.files.length === 0) return true;
    //     return element.files[0].size <= param * 1024;
    // }, "File must be less than {0} KB");

    $("#myForm").validate({
        ignore: [],
        rules: {
            name: { required: true, maxlength: 255 },
            billing_name: { required: true, maxlength: 255 },
            short_name: { required: true, maxlength: 255 },
            email: { required: true, email: true },
            // gst_no: {
            //     required: true,
            //     pattern: /^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}Z[0-9A-Z]{1}$/
            // },
           
        },
        messages: {
            name: "Please enter firm name.",
            billing_name: "Please enter Billing name.",
            short_name: "Please enter Short name.",
            email: "Please enter email address.",
            // email: {
            //     required: "Please enter email address.",
            //     email: "Please enter valid email address."
            // },
            mobile_number: {
                required: "Please enter mobile number.",
                digits: "Mobile number must contain only digits.",
                minlength: "Mobile number must be 10 digits long.",
                maxlength: "Mobile number must be 10 digits long."
            },
            // gst_no: {
            //     required: "Please enter GST number.",
            //     pattern: "Invalid GST format (e.g., 22AAAAA0000A1Z5)."
            // }
        },
        errorPlacement: function (error, element) {
            if (element.hasClass("select2-hidden-accessible")) {
                error.insertAfter(element.next('span.select2'));
            } else {
                error.insertAfter(element);
            }
        }
    });

  $('#myForm').on('submit', function (e) {
    e.preventDefault();
    if (!$("#myForm").valid()) return;

    // let method = $('#myForm').find('input[name="_method"]').val() || 'POST';
    $('.submission_loader').removeClass('d-none');
    const $btn = $('#submitBtn');
    $btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');


    let formData = new FormData(this);

    // // ✅ Ensure CSRF token is present
    // formData.append('_token', $('meta[name="csrf-token"]').attr('content'));

    $.ajax({
        url: $(this).attr('action'),
        type :'POST', // keep POST; Laravel detects PUT via _method
        data: formData,
        processData: false,
        contentType: false,

        success: function (response) {
            Swal.fire('Success', response.message || 'Saved!', 'success');
            $('.submission_loader').addClass('d-none');
            if (response.redirect_url) {
                setTimeout(() => window.location.href = response.redirect_url, 800);
            }
        },
        error: function (xhr) {
            $('.submission_loader').addClass('d-none');
            $btn.prop('disabled', false).html('<?php echo e(isset($vendor) ? "Update" : "Submit"); ?>');
            if (xhr.status === 422) {
                let errors = xhr.responseJSON.errors;
                $('.text-danger').text('');
                $.each(errors, function (key, value) {
                    let $field = $('[name="' + key + '"]');
                    let $err = $field.closest('.mb-3').find('.text-danger');
                    if ($err.length === 0) {
                        $field.after('<span class="text-danger">' + value[0] + '</span>');
                    } else {
                        $err.text(value[0]);
                    }
                });
            } else {
                Swal.fire('Error', xhr.responseJSON?.message || 'Something went wrong', 'error');
            }
        }
    });
});


});

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/vendor/create.blade.php ENDPATH**/ ?>