<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($title ?? 'Campaign Report'); ?></title>
    <style>
        body, table, td, p, a, li, blockquote {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        .header-gradient {
            background-color:rgb(24, 42, 55); 
            padding: 30px 30px;
            text-align: center;
        }
        .logo-container {
            background-color:#fff;
            border-radius: 16px;
            padding: 10px;
            display: inline-block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
        .logo-text {
            color: #ffffff;
            font-size: 28px;
            font-weight: 700;
            margin: 0px 0 5px 0;
            padding: 0;
            letter-spacing: 0.5px;
        }
        .tagline-text {
            color: rgba(255, 255, 255, 0.85);
            font-size: 16px;
            margin: 0;
        }
    </style>
</head>
<body style="margin:0; padding:0; font-family:Arial,sans-serif; font-size:14px; background:#f4f4f4; color:#333;">

    <table width="100%" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td align="center">

                <table width="600" cellpadding="0" cellspacing="0" border="0" style="background:#fff; margin:0 auto;">

                    <!-- Header -->
                    <tr>
                        <td class="header-gradient">
                            <div class="logo-container">
                                <a href="<?php echo e(url('/')); ?>" target="_blank"> 
                                    <img src="<?php echo e(asset($sitesetting->image)); ?>" alt="<?php echo e($sitesetting->comp_name); ?>" style="max-width:80px; height:auto;">
                                </a>
                            </div>
                            <h1 class="logo-text">
                                <a href="<?php echo e(url('/')); ?>" style="text-decoration:none; color:inherit;" target="_blank">
                                    <?php echo e($sitesetting->comp_name); ?>

                                </a>
                            </h1>
                            <p class="tagline-text">Elevating Your Business Through Strategic Marketing</p>
                        </td>                        
                    </tr>  

                    <!-- Campaign Information -->
                    <tr>
                        <td style="padding:20px;">
                            <table width="100%" style="background:#ecf0f1; border-radius:5px;">
                                <tr>
                                    <td style="padding:15px;">
                                        <h2 style="margin:0 0 10px 0; color:#2c3e50;">Campaign Details</h2>

                                        <p><strong>Campaign Name:</strong> <?php echo e($campaign->campaign_name); ?></p>
                                        <p><strong>Company Name:</strong> <?php echo e($campaign->company_name ?? '-'); ?></p>
                                        <p><strong>Subject:</strong> <?php echo e($campaign->subject ?? '-'); ?></p>
                                        <p><strong>Details:</strong> <?php echo e($campaign->details ?? '-'); ?></p>
                                        <p><strong>Area Development:</strong> <?php echo e(ucwords(str_replace('_', ' ', $campaign->area_devlopment ?? '-'))); ?></p>
                                        <p><strong>Report Generated:</strong> <?php echo e(now()->format('F d, Y h:i A')); ?></p>
                                        <p><strong>Status:</strong> <?php echo e(ucfirst($campaign->status ?? 'Completed')); ?></p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>


                    <!-- Campaign Summary -->
                    <tr>
                        <td style="padding:0 20px 20px 20px;">
                            <h3 style="color:#2c3e50; margin:25px 0 15px 0;">Campaign Summary</h3>
                            <table width="100%" style="border-collapse:collapse; background:#fff; box-shadow:0 1px 3px rgba(0,0,0,0.1);">
                                <tr>
                                    <td style="background:#34495e; color:#fff; padding:12px; font-weight:bold;">Metric</td>
                                    <td style="background:#34495e; color:#fff; padding:12px; text-align:right; font-weight:bold;">Value</td>
                                </tr>
                                <tr><td>Total Calls</td><td style="text-align:right;"><?php echo e($totals['total_calls']); ?></td></tr>
                                <tr><td>Sell Price</td><td style="text-align:right; color:#27ae60;">$<?php echo e(number_format($totals['sell_price'],2)); ?></td></tr>
                                <tr><td>Commission Total</td><td style="text-align:right; color:#27ae60;">$<?php echo e(number_format($totals['commission_total'],2)); ?></td></tr>
                                <tr><td>Working Earnings</td><td style="text-align:right; color:#27ae60;">$<?php echo e(number_format($totals['working_earn'],2)); ?></td></tr>
                                <tr><td>Lead Earnings</td><td style="text-align:right; color:#27ae60;">$<?php echo e(number_format($totals['lead_earn'],2)); ?></td></tr>
                                <tr><td>Total Call Time</td><td style="text-align:right;"><?php echo e($totals['per_user_call_time']); ?></td></tr>
                                <tr><td>Penalty</td><td style="text-align:right; color:#e74c3c;">$<?php echo e(number_format($totals['penalty'],2)); ?></td></tr>
                            </table>
                        </td>
                    </tr>

                    <!-- Detailed Records -->
                    <?php if(count($rows)): ?>
                        <tr>
                            <td style="padding:0 20px;">
                                <h3 style="color:#2c3e50; margin:25px 0 15px 0;">Detailed Records</h3>
                            </td>
                        </tr>
                        <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td style="padding:0 20px 25px 20px;">
                                <table width="100%" style="border:1px solid #ddd; border-radius:5px;">
                                    <tr>
                                        <td colspan="2" style="background:#34495e; color:#fff; padding:10px; font-weight:bold;">
                                            Record #<?php echo e($index+1); ?> - <?php echo e($row->user->name ?? 'N/A'); ?>

                                        </td>
                                    </tr>
                                    <tr><td>Commission</td><td style="text-align:right; color:#27ae60;">$<?php echo e(number_format($row->commission_total,2)); ?></td></tr>
                                    <tr><td>Working Earn</td><td style="text-align:right; color:#27ae60;">$<?php echo e(number_format($row->working_earn,2)); ?></td></tr>
                                    <tr><td>Lead Earn</td><td style="text-align:right; color:#27ae60;">$<?php echo e(number_format($row->lead_earn,2)); ?></td></tr>
                                    <tr><td>Call Time</td><td style="text-align:right;"><?php echo e($row->per_user_call_time); ?></td></tr>
                                    <tr><td>Penalty</td><td style="text-align:right; color:#e74c3c;">$<?php echo e(number_format($row->penalty,2)); ?></td></tr>
                                </table>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    <!-- Note -->
                    <tr>
                        <td style="padding:0 20px 20px 20px;">
                            <table width="100%" style="background:#fff3cd; border-left:4px solid #ffc107;">
                                <tr>
                                    <td style="padding:15px; color:#856404;">
                                        <p style="margin:0; font-size:12px;">
                                            <strong>Note:</strong> This is an automated report generated upon campaign completion. 
                                            All monetary values are displayed in USD. Call times are shown in HH:MM:SS format.
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <!-- Footer -->
                    <tr>
                        <td style="padding:15px; text-align:center; background:#0d5a92;">
                            <p style="color:#fff; margin:0;">© <?php echo e(now()->year); ?> <?php echo e($sitesetting->comp_name); ?>. All rights reserved.</p>                            
                            <p style="margin:10px 0 0;">
                                <a href="<?php echo e(url('/privacy-policy')); ?>" style="color:#fff; text-decoration:none;" target="_blank">Privacy Policy</a> | 
                                <a href="<?php echo e(url('/terms-and-conditions')); ?>" style="color:#fff; text-decoration:none;" target="_blank">Terms</a> | 
                                <a href="<?php echo e(url('/')); ?>" style="color:#fff; text-decoration:none;" target="_blank">Login To Dashboard</a>
                            </p>
                        </td>
                    </tr>

                </table>
            </td>
        </tr>
    </table>
</body>
</html>
<?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/mail/complete-campaign-details-mail.blade.php ENDPATH**/ ?>