<?php $__env->startSection('content'); ?>

<style>
.dt-buttons.btn-group {
    position: absolute;
    top: 50px;
    left: 178px;
}
.custom {
    display:flex;
    justify-content: center;
}

</style>
<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto animate-charcter">Tax Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ View Taxes</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    <a href="<?php echo e(url('admin/tax/create')); ?>"><button type="button" class="btn btn-primary">Add Tax</button></a>
				 </div>
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card gradient-border">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0 animate-charcter">Tax Details</h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom gradient-border" id="example1">
                                <thead>
                                    <tr>
                                    <th ><span>Sequence</span></th>
                                        <th ><span>Tax Name</span></th>
                                       
                                        <th ><span>Status</span></th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                               
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->


<!-- main-content closed -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Tax Details</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <div id="tax_detail_append"></div>
        </div>
        <div class="modal-footer">
             <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
</div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
jQuery(document).ready(function () {
    var oTable = $('#example1').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 10,
            "buttons": [],
            stateSave: true,
            processing: true,
            serverSide: true,
            dom:'lBfrtip',
            ajax:{ 
                url: "<?php echo e(url('admin/tax')); ?>",
                type: 'get',
                data: function (d) {
                    d._token = "<?php echo e(csrf_token()); ?>";
                    d.startDate = $('#startDate').val();
                    d.endDate = $('#endDate').val();  
                    d.search = {
                        value: $('input[type="search"]').val()  
                    };
                },
                
                },
            columns: [
                {data: 'sequence', name: 'sequence',orderable : false, searchable: false,className : 'text-center custom',defaultContent:'-'},
                {data: 'name', name: 'name',className : 'text-center'},
                {data: 'status', name: 'status',orderable : false,className : 'text-center', searchable: false},
                {data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
            ]
            
    });


    $("body").on("change", "#statusToggle", function () {
        var toggleButton = $(this);
        Swal.fire({
            title: "Are you sure?",
            text: "you want to change this status ?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, confirm it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var id = $(this).data('id');
                var currentStatus = jQuery(this).data('status');

                jQuery.ajax({
                    url: "<?php echo e(url('admin/tax')); ?>/" + id ,
                    type: 'PUT',
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        "id": id,
                        "currentStatus": currentStatus,
                    },
                    success: function (data) {
                        if(data.success == true)
                        {
                            toastr.success(data.message);
                            // oTable.ajax.reload();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            }else{
                if(currentStatus == 'Active'){
                    $(this).prop('checked',true);
                }else{
                    $(this).prop('checked',false);
                }
            }
        });
    });

    $("body").on("focusout", ".sequence_update", function () {
       
			var field = $(this).attr('field');
			var value = $(this).val();
			var id = $(this).attr('row_id');
           
			var obj = $(this);
			$.ajax({
				type: "PUT",
				url: "<?php echo e(url('admin/tax')); ?>/"+id,
				data: {
					"_token": "<?php echo e(csrf_token()); ?>",
					"id": id,
					"sequence": value,
				},
				error: function (e) {
					if (e.success == true) {
						alert('Unauthorized: Access is denied due to invalid credentials.');
					}else{
						alert('internal error occurred.');
					}
				},
				success: function (result) {
                    // data_table(page_url=false);
					$(obj).after('<span class="text-success txt_inline_notification">Saved</span>');
					$('.txt_inline_notification').delay(1000).fadeOut('slow');
					oTable.ajax.reload();
				}
			});
			
    });
		

    $("body").on("click", ".data-delete", function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                    jQuery.ajax({
                        type: "DELETE",
                        url: "<?php echo e(url('admin/tax')); ?>/" + id,
                        data: {
                            id: id,
                            _token: "<?php echo e(csrf_token()); ?>"
                        },
                        dataType: 'json',
                        beforeSend: function () {
                            // Use the stored reference to the clicked element
                            obj.attr('disabled', true);
                            jQuery('.alert .msg-content').html('');
                            jQuery('.alert').hide();
                        },
                        success: function (resp) {
                            if(resp.success == true)
                            {
                                toastr.success(resp.message);
                                oTable.ajax.reload();
                            }
                        }
                        
                    });
            }else{
                oTable.ajax.reload();
            }
        });
    });

    $("#example1").on('click', '.taxView', function () {
        
        var obj = jQuery(this);
        var id = obj.attr('data-id');
        jQuery.ajax({
            type: "POST",
            url: "<?php echo e(url('admin/taxView')); ?>",
            data: {
                id: id,
                _token: "<?php echo e(csrf_token()); ?>"
            },
            dataType: 'json',
            beforeSend: function () {
                
            },
            success: function (resp) {
                if(resp.success == true)
                {
                   $('#exampleModal').modal({
                                        backdrop: 'static',
                                        keyboard: false,
                                    }).modal('show');
                   $('#tax_detail_append').html(resp.html);
                }
            }
            
        });

    });
});
   

$(function () {    	 
    var start = moment().subtract(29, 'days');
        var end = moment();
        $('#reportrange').daterangepicker({
            startDate: start,
            endDate: end,
            ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
            }
        }, 
        function cb(start, end) {
            $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                $('#example1').DataTable().ajax.reload();
        }
        )
});
		

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/tax/index.blade.php ENDPATH**/ ?>