<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto animate-charcter">Permission Details</h4>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    <?php if(rolemanagement('Permission', 2)): ?>
                        <button type="button" class="btn btn-primary" onclick="openModal();" >
                            Add Permission
                        </button>
                    <?php endif; ?>
				 </div>
            </div>
        </div>
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card gradient-border">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom gradient-border" id="example1">
                                <thead>
                                    <tr>
                                        <!-- <th >Sequence</th> -->
                                        <th >Name</th>
                                        <th >Permission Type</th>
                                        <th >Created At</th>
                                        <th >Updated At</th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                               
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Create Permission</h5>
          <button type="button" class="btn-close" onclick="closeModal();" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="role_form">

        </div>
        <div class="submission_loader d-none">
            <div class="submission_loader-overlay d-flex justify-content-center align-items-center">
                <div class="spinner-border text-primary submission_loader-spinner" role="status">
                    <span class="visually-hidden">Loading...</span>
                </div>
            </div>
        </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
  var myModal = new bootstrap.Modal(document.getElementById('exampleModal'), {
    keyboard: true 
  });
</script>
<script>
jQuery(document).ready(function () {
    var oTable = $('#example1').DataTable({
        "responsive": false, "lengthChange": true, "autoWidth": false, "pageLength": 10,
          "buttons": [],
            stateSave: true,
            processing: true,
            serverSide: true,
            dom:'lBfrtip',
            ajax:{ 
                url: "<?php echo e(route('admin.permission.index')); ?>",
                type: 'get',
                data: function (d) {
                    d._token = "<?php echo e(csrf_token()); ?>";
                    d.search = {
                        value: $('input[type="search"]').val()  
                    };
                },
                
                },
            columns: [
                // {data: 'sequence', name: 'sequence',orderable : false, searchable: false,className : 'text-center custom',defaultContent:'-'},
                {data: 'name', name: 'name',className : 'text-center'},
                {data: 'permission_type', name: 'permission_type',orderable : false,className : 'text-center', searchable: false},
                {data: 'created_at', name: 'created_at',orderable : false,className : 'text-center', searchable: false},
                {data: 'updated_at', name: 'updated_at',orderable : false,className : 'text-center', searchable: false},
                {data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
            ]
            
    });
    $("body").on("change", "#statusToggle", function () {
        var toggleButton = $(this);
        var id = $(this).data('id');
        var currentStatus = jQuery(this).data('status');
        Swal.fire({
            title: "Are you sure?",
            text: "you want to change this status ?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, confirm it!"
            }).then((result) => {
            if (result.isConfirmed) {
                jQuery.ajax({
                    url: "<?php echo e(route('admin.permission.sequence_update')); ?>",
                    type: 'post',
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        "id": id,
                        "currentStatus": currentStatus,
                    },
                    success: function (data) {
                        if(data.success == true)
                        {
                            toastr.success(data.message);
                            oTable.ajax.reload();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            }else{
                if(currentStatus == 'Active'){
                    $(this).prop('checked',true);
                }else{
                    $(this).prop('checked',false);
                }
            }
        });
    });
    $("body").on("focusout", ".sequence_update", function () {
			var field = $(this).attr('field');
			var value = $(this).val();
			var id = $(this).attr('row_id');
			var obj = $(this);
			$.ajax({
				type: "post",
				url: "<?php echo e(route('admin.permission.sequence_update')); ?>",
				data: {
					"_token": "<?php echo e(csrf_token()); ?>",
					"id": id,
					"sequence": value,
				},
				error: function (e) {
					if (e.success == true) {
						alert('Unauthorized: Access is denied due to invalid credentials.');
					}else{
						alert('internal error occurred.');
					}
				},
				success: function (result) {
                    // data_table(page_url=false);
					$(obj).after('<span class="text-success txt_inline_notification">Saved</span>');
					$('.txt_inline_notification').delay(1000).fadeOut('slow');
					oTable.ajax.reload();
				}
			});
			
    });
    $("body").on("click", ".data-delete", function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                    jQuery.ajax({
                        type: "DELETE",
                        url: "<?php echo e(url('secure-dashboard/permission')); ?>/" + id,
                        data: {
                            id: id,
                            _token: "<?php echo e(csrf_token()); ?>"
                        },
                        dataType: 'json',
                        beforeSend: function () {
                            // Use the stored reference to the clicked element
                            obj.attr('disabled', true);
                            jQuery('.alert .msg-content').html('');
                            jQuery('.alert').hide();
                        },
                        success: function (resp) {
                            if(resp.success == true)
                            {
                                toastr.success(resp.message);
                                oTable.ajax.reload();
                            }
                        }
                        
                    });
            }else{
                oTable.ajax.reload();
            }
        });
    });
    $(document).on('input', '.digitonly', function() {
        this.value = this.value.replace(/[^0-9.]/g, ''); 
        if ((this.value.match(/\./g) || []).length > 1) {
            this.value = this.value.replace(/\.+$/, ''); 
        }
    });
    $(document).on('submit', '#form', function(e) {
        e.preventDefault();
        $('.submission_loader').removeClass('d-none');
        $(this).find("button[type='submit']").prop("disabled", true);
        submitForm($(this), "<?php echo e(route('admin.permission.store')); ?>");
    });

    $(document).on('submit', '#editform', function(e) {
        e.preventDefault();
        $('.submission_loader').removeClass('d-none');
        $(this).find("button[type='submit']").prop("disabled", true);
        submitForm($(this), "<?php echo e(route('admin.permission.update')); ?>");
    });
    function submitForm(form, url) {
        $('select, input').removeClass('is-invalid');
        $('.invalid-feedback').remove();
        $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
                }
            });
        let formData = new FormData(form[0]);
        $.ajax({
            url: url,
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            dataType: 'json',
            success: function(response) {
                 $('.submission_loader').addClass('d-none');
                $(form).find("button[type='submit']").prop("disabled", false);
                if (response.success) {
                    oTable.ajax.reload();
                    toastr.success(response.message);
                    form[0].reset();
                    $('#exampleModal').modal('hide');
                } else {
                    $('.submission_loader').addClass('d-none');
                    $(form).find("button[type='submit']").prop("disabled", false);
                    showErrors(response.message);
                }
            }
        });
    }

    function showErrors(errors) {
        $.each(errors, function(key, value) {
            let input = $('[name="' + key + '"]');
            input.addClass('is-invalid');
            input.after('<span class="invalid-feedback" role="alert">' + value + '</span>');
        });
    }
    // $('body').on('shown.bs.modal', '.modal', function() {
    //     $(this).find('.my-select').select2({
    //         dropdownParent: $(this),
    //     });
    //     $(this).on('scroll', function (event) {
    //         $(this).find(".my-select").each(function () {
    //             $(this).select2({ dropdownParent: $(this).parent() });
    //         });
    //     });
    // });
    $('body').on('shown.bs.modal', '.modal', function() {
    $(this).find('.my-select').each(function () {
        $(this).select2({
            dropdownParent: $(this).closest('.modal')
        });
    });
});
});
function openModal(){
    $('#exampleModalLabel').html('Create Permission');
    $.ajax({
        url: "<?php echo e(route('admin.permission.create')); ?>",
        type: "POST",
        data: {
            "_token": "<?php echo e(csrf_token()); ?>",
        },
        dataType: 'json',
        success: function(response) {
            if (response.code === -1) {
                Swal.fire({
                    title: 'Login Required',
                    text: response.message,
                    icon: 'warning',
                    confirmButtonText: 'Login Now'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = "<?php echo e(url('/login')); ?>";
                    }
                });
                return;
            }
            if (response.success == true) {
                $('.role_form').html(response.html);
                $('#exampleModal').modal({
                            backdrop: 'static',
                            keyboard: false,
                    }).modal('show');
            }
        }
    });
}
function editmodal(id){
    $('#exampleModalLabel').html('Edit Permission');
    $.ajax({
        url: "<?php echo e(route('admin.permission.edit')); ?>",
        type: "POST",
        data: {
            "_token": "<?php echo e(csrf_token()); ?>",
            id:id,
        },
        dataType: 'json',
        success: function(response) {
            if (response.code === -1) {
                Swal.fire({
                    title: 'Login Required',
                    text: response.message,
                    icon: 'warning',
                    confirmButtonText: 'Login Now'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = "<?php echo e(url('/login')); ?>";
                    }
                });
                return;
            }
            if (response.success == true) {
                $('#catform').hide();
                $('.role_form').html(response.html);
                $('#exampleModal').modal({
                            backdrop: 'static',
                            keyboard: false,
                    }).modal('show');
            }
        }
    });
}
function closeModal(){
    $('#exampleModal').modal('hide');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/permission/index.blade.php ENDPATH**/ ?>