<?php $__env->startSection('content'); ?>
    <div class="main-content app-content">
        <div class="main-container container-fluid">
            <div class="breadcrumb-header justify-content-between">
                <div class="my-auto">
                    <div class="d-flex">
                        <h4 class="content-title mb-0 my-auto animate-charcter">Raw Material Details</h4>
                    </div>
                </div>
                <div class="d-flex my-xl-auto right-content">
                    <div class="pe-1 mb-xl-0">

                        <a class="btn btn-primary text-white" onclick="openModal();">
                            Add
                        </a>

                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-header pb-0 card_filter">
                    <div class="d-flex justify-content-end align-items-center pb-2">
                        <button id="toggleFilter" class="btn btn-secondary">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                    </div>
                </div>
                <div class="card-body toggler_filter">
                    <div class="row align-items-center my-xl-auto right-content">
                        <div class="col-md-12 mb-2">
                            <form id="searchForm">
                                <?php echo csrf_field(); ?>
                                <div class="row">


                                    <!-- Date Range -->
                                    <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 mb-2">
                                        <label class="form-label">Start Date</label>
                                        <input type="text" id="start_date" name="start_date"
                                            class="form-control scheduleTime" placeholder="Start Date">
                                    </div>

                                    <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 mb-2">
                                        <label class="form-label">End Date</label>
                                        <input type="text" id="end_date" name="end_date" class="form-control scheduleTime"
                                            placeholder="End Date">
                                    </div>

                                    <!-- Buttons -->
                                    <div class="col-xxl-2 col-xl-3 col-lg-3 col-md-4 mb-2">
                                        <div class="d-flex flex-wrap flex-md-nowrap align-items-baseline gap-2">
                                            <div>
                                                <div class="form-label">&nbsp;</div>
                                                <button type="button" class="btn btn-primary" id="searchBtn">Search</button>
                                            </div>
                                            <div>
                                                <div class="form-label">&nbsp;</div>
                                                <button type="button" class="btn btn-danger" id="resetBtn">Reset</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row row-sm">
                <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                    <div class="card gradient-border">
                        <div class="card-header pb-0">
                            <div class="d-flex justify-content-between"></div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="border-top-0 table table-bordered key-buttons border-bottom gradient-border"
                                    id="productTable">
                                    <thead>
                                        <tr>
                                            <th>Item Name</th>
                                            <th>Billing Name</th>
                                            <th>Unit</th>
                                            <th style="min-width:101px;">Rate</th>
                                            <th>Category</th>
                                            <th>Group</th>
                                            <th>Inclusive Tax</th>
                                            <th style="min-width:101px;">GST</th>
                                            <th>HSN Code</th>
                                            <th>Quantity</th>
                                            <th>Reorder Level</th>
                                            <th>Reorder Qty</th>
                                            <th>Receipt Item</th>
                                            <th>RR Item</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Create Product</h5>
                    <button type="button" class="btn-close" onclick="closeModal();" data-bs-dismiss="modal"></button>
                </div>
                <div class="role_form"></div>
                <div class="submission_loader d-none">
                    <div class="submission_loader-overlay d-flex justify-content-center align-items-center">
                        <div class="spinner-border text-primary submission_loader-spinner" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        var myModal = new bootstrap.Modal(document.getElementById('exampleModal'), { keyboard: true });
    </script>

    <script>
        flatpickr(".scheduleTime", {
            enableTime: false,
            dateFormat: "d-m-Y",
            allowClear: true,
        });

        var oTable;
        jQuery(document).ready(function () {
            oTable = $('#productTable').DataTable({
                "responsive": false, "lengthChange": true, "autoWidth": false, "pageLength": 10,
                stateSave: true,
                processing: true,
                serverSide: true,
                dom: 'lBfrtip',
                ajax: {
                    url: "<?php echo e(route('admin.raw_materials.index')); ?>",
                    type: 'GET',
                    data: function (d) {
                        d._token = "<?php echo e(csrf_token()); ?>";
                        d.search = { value: $('input[type="search"]').val() };

                        // d.firm_id = $('#firm_id').val();
                        d.category_id = $('#category_id').val();
                        d.purchase_group_id = $('#purchase_group_id').val();
                        d.inclusive_tax = $('#inclusive_tax').val();
                        d.start_date = $('#start_date').val();
                        d.end_date = $('#end_date').val();
                    },
                },
                columns: [
                    { data: 'item_details', name: 'item_details', className: 'text-center', orderable: false, searchable: false },
                    { data: 'billing_name', name: 'billing_name', className: 'text-center' },
                    { data: 'unit_name', name: 'unit_name', className: 'text-center' },
                    { data: 'rates', name: 'rates', className: 'text-center', orderable: false, searchable: false },
                    { data: 'category', name: 'category', className: 'text-center', orderable: false, searchable: false },
                    { data: 'purchaseGroup', name: 'purchaseGroup', className: 'text-center', orderable: false, searchable: false },
                    { data: 'inclusive_tax', name: 'inclusive_tax', className: 'text-center' },
                    { data: 'gst_details', name: 'gst_details', className: 'text-center', orderable: false, searchable: false },
                    { data: 'hsn_code', name: 'hsn_code', className: 'text-center' },
                    { data: 'quantity', name: 'quantity', className: 'text-center' },
                    { data: 'reorder_level', name: 'reorder_level', className: 'text-center' },
                    { data: 'reorder_qty', name: 'reorder_qty', className: 'text-center' },
                    { data: 'receipt_item', name: 'receipt_item', className: 'text-center' },
                    { data: 'rr_item', name: 'rr_item', className: 'text-center' },
                    { data: 'action', name: 'action', className: 'text-center', orderable: false, searchable: false },
                ]

            });

            $("body").on("click", ".data-delete", function () {
                Swal.fire({
                    title: "Are you sure?",
                    text: "Do you want to delete this record?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Yes, delete it!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        var id = $(this).attr('data-id');
                        $.ajax({
                            type: "DELETE",
                            url: "<?php echo e(url('secure-dashboard/raw_materials')); ?>/" + id,
                            data: { _token: "<?php echo e(csrf_token()); ?>" },
                            dataType: 'json',
                            success: function (resp) {
                                if (resp.success == true) {
                                    oTable.ajax.reload(null, false);
                                    toastr.success(resp.message);
                                }
                            }
                        });
                    }
                });
            });

            $(document).on('submit', '#productForm', function (e) {
                e.preventDefault();
                if (!validateProductForm()) return false;
                $('.submission_loader').removeClass('d-none');
                $(this).find("button[type='submit']").prop("disabled", true);
                submitForm($(this));
            });

            function validateProductForm() {
                let isValid = true;
                $('input, select').removeClass('is-invalid');
                $('.invalid-feedback').remove();

                let requiredFields = [
                    // { name: 'firm', label: 'Firm' },
                    { name: 'item_name', label: 'Item Name' },
                    { name: 'unit_name', label: 'Unit Name' },
                    { name: 'category', label: 'Category' },
                    { name: 'group', label: 'Group' },
                    { name: 'purchase_rate', label: 'Purchase Rate' },
                    { name: 'opening_rate', label: 'Opening Rate' },
                    { name: 'inclusive_tax1', label: 'Inclusive Tax' },
                ];

                // requiredFields.forEach(field => {
                //     let input = $('[name="' + field.name + '"]');
                //     if ($.trim(input.val()) === '') {
                //         input.addClass('is-invalid');
                //         input.after('<div class="invalid-feedback">Please enter ' + field.label.toLowerCase() + '.</div>');
                //         isValid = false;
                //     }
                // });

                requiredFields.forEach(field => {
                    let input = $('[name="' + field.name + '"]');

                    // Remove previous error message if already exists
                    input.closest('.input_box').find('.invalid-feedback').remove();

                    if ($.trim(input.val()) === '') {
                        input.addClass('is-invalid');
                        isValid = false;

                        // Check if input is a Select2
                        if (input.hasClass('select2-hidden-accessible')) {
                            // Put error message after the select2 container
                            input.next('.select2').after(
                                '<div class="invalid-feedback d-block">Please enter ' + field.label.toLowerCase() + '.</div>'
                            );
                        } else {
                            // Default behavior (for normal input)
                            input.after(
                                '<div class="invalid-feedback">Please enter ' + field.label.toLowerCase() + '.</div>'
                            );
                        }
                    } else {
                        input.removeClass('is-invalid');
                    }
                });

                if ($('#inclusive_tax1').val() === 'Yes') {
                    ['sgst', 'cgst', 'igst', 'cess'].forEach(name => {
                        let input = $('[name="' + name + '"]');
                        if ($.trim(input.val()) === '') {
                            input.addClass('is-invalid');
                            input.after('<div class="invalid-feedback">' + name.toUpperCase() + ' is required</div>');
                            isValid = false;
                        }
                    });
                }

                return isValid;
            }

            function submitForm(form) {
                let formData = new FormData(form[0]);
                let url = form.attr('action');

                $.ajax({
                    url: url,
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            $('.submission_loader').addClass('d-none');
                            form.find("button[type='submit']").prop("disabled", false);
                            oTable.ajax.reload(null, false);
                            toastr.success(response.message);
                            form[0].reset();
                            $('#exampleModal').modal('hide');
                        } else {
                            showErrors(response.message);
                        }
                    },
                    error: function (xhr) {
                        $('.submission_loader').addClass('d-none');
                        form.find("button[type='submit']").prop("disabled", false);
                        if (xhr.status === 422) {
                            showErrors(xhr.responseJSON.errors);
                        }
                    }
                });
            }


            function showErrors(errors) {
                $.each(errors, function (key, value) {
                    let input = $('[name="' + key + '"]');
                    input.addClass('is-invalid');
                    input.after('<span class="invalid-feedback">' + value + '</span>');
                });
            }
        });





        function openModal() {
            $('#exampleModalLabel').html('Create Product');
            $.ajax({
                url: "<?php echo e(route('admin.raw_materials.create')); ?>",
                type: "POST",
                data: { "_token": "<?php echo e(csrf_token()); ?>" },
                dataType: 'json',
                success: function (response) {
                    if (response.code === -1) {
                        Swal.fire({ title: 'Login Required', text: response.message, icon: 'warning' })
                            .then(() => window.location.href = "<?php echo e(url('/login')); ?>");
                        return;
                    }
                    if (response.success) {
                        $('.role_form').html(response.html);
                        $('#exampleModal').modal({ backdrop: 'static', keyboard: false }).modal('show');
                    }
                }
            });
        }

        function editmodal(id) {
            $('#exampleModalLabel').html('Edit Product');
            $.ajax({
                url: "<?php echo e(route('admin.raw_materials.edit')); ?>",
                type: "POST",
                data: { "_token": "<?php echo e(csrf_token()); ?>", id: id },
                dataType: 'json',
                success: function (response) {
                    if (response.code === -1) {
                        Swal.fire({ title: 'Login Required', text: response.message, icon: 'warning' })
                            .then(() => window.location.href = "<?php echo e(url('/login')); ?>");
                        return;
                    }
                    if (response.success) {
                        $('.role_form').html(response.html);
                        $('#exampleModal').modal({ backdrop: 'static', keyboard: false }).modal('show');
                    }
                }
            });
        }

        function closeModal() {
            $('#exampleModal').modal('hide');
        }

        $(document).ready(function () {
            $('#category_id').on('change', function () {
                let categoryId = $(this).val();
                let groupSelect = $('#purchase_group_id');

                groupSelect.empty().append('<option value="">-- Select --</option>');

                if (categoryId) {
                    $.ajax({
                        url: '/secure-dashboard/get-purchase-groups/' + categoryId,
                        type: 'GET',
                        success: function (response) {
                            if (response.length > 0) {
                                $.each(response, function (index, group) {
                                    groupSelect.append(
                                        $('<option>', { value: group.id, text: group.name })
                                    );
                                });
                            }
                        },
                        error: function () {
                            toastr.error('Failed to load groups');
                        }
                    });
                }
            });

            $('#searchBtn').on('click', function () {
                oTable.ajax.reload();
            });

            $('#resetBtn').on('click', function () {
                $('#searchForm')[0].reset();
                oTable.ajax.reload();
            });

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/raw_material/index.blade.php ENDPATH**/ ?>