<!DOCTYPE html>
<html lang="en">
    <head>
    <?php 
            $sitesetting = \App\Models\Sitesetting::first();
    ?>
        <title>Singi Marketing | Reset Password</title>
        <base href="<?php echo e(url('/')); ?>" />
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="author" content="Singi Marketing">
        <link rel="shortcut icon" href="<?php echo e((!empty($sitesetting) && !empty('$sitesetting->fevicon'))?url('/'.$sitesetting->fevicon):''); ?>" type="image/x-icon"> 
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Marcellus&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/bootstrap.min.css">
        <link href="<?php echo e(url('assets/admin')); ?>/css/icons.css" rel="stylesheet">
        <link href="<?php echo e(url('assets/admin')); ?>/css/style.css" rel="stylesheet">	
        <link rel="stylesheet" href="<?php echo e(url('public/assets/user')); ?>/css/reset-password.css">
    </head>
    <body class="ltr error-page1 main-body bg_light text-dark error-3">

    <div id="global-loader" style="display: none;">
        <div class="loader-img">
            <i class="fas fa-spinner fa-spin" style="font-size: 30px; color: white;"></i>
        </div>
    </div>

    <div class="page">
        <!-- Reset Password Form -->
        <div class="form-container">
            <div class="glass-card">
                <div class="form-header">
                    <div class="reset-icon">
                        <img src="<?php echo e($sitesetting->image_url); ?>" alt="Logo">
                    </div>
                    <h2>
                        <i class="fas fa-lock-open"></i>
                        Reset Password
                    </h2>
                    <p>Enter your email address and we'll send you a link to reset your password</p>
                </div>

                <!-- Success Message -->
                <?php if(session('status')): ?>
                    <div class="alert alert-success" role="alert">
                        <?php echo e(session('status')); ?>

                    </div>
                <?php endif; ?>

                <form class="reset-form" method="POST"action="<?php echo e(route('password.email')); ?>">
                    <?php echo e(csrf_field()); ?>

                    
                    <div class="form-group">
                        <label for="email"><?php echo e(__('Email Address')); ?></label> 
                        <div class="input-container">
                            <i class="input-icon fas fa-envelope"></i>
                            <input id="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="Enter your email" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email" autofocus>
                        </div>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="help-block">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <button type="submit" class="btn-primary"><i class="fas fa-paper-plane"></i> <?php echo e(__('Send Password Reset Link')); ?></button>
                </form>

                <!-- Back to Login -->
                <div style="text-align: center; margin-top: 25px;">
                    <a href="<?php echo e(url('secure-dashboard/login')); ?>" style="color: rgba(255, 255, 255, 0.8); text-decoration: none; font-size: 14px; transition: color 0.3s ease;">
                        <i class="fas fa-arrow-left"></i>
                        Back to Login
                    </a>
                </div>
            </div>
        </div>

        <!-- Video Section -->
        <?php
            $videoId = null;
            if (!empty($sitesetting->youtube_link)) {
                $url = $sitesetting->youtube_link;
                if (strpos($url, 'youtu.be/') !== false) {
                    $videoId = \Illuminate\Support\Str::after($url, 'youtu.be/');
                    $videoId = strtok($videoId, '?'); // Agar ?si=... ho to cut kar dega
                }
                elseif (strpos($url, 'v=') !== false) {
                    $videoId = \Illuminate\Support\Str::after($url, 'v=');
                    $videoId = strtok($videoId, '&'); // Agar aur params ho to remove
                }
            }
        ?>
        <?php if(!empty($videoId)): ?>
        <div class="video-container">
            <div class="video-header">
                <h4>
                    <i class="fas fa-play-circle"></i>
                    <?php echo e($sitesetting->youtube_title); ?>

                </h4>
            </div>
            <div class="video-wrapper">
                <!-- Demo YouTube Video - Replace with your dynamic content -->
                <iframe
                    src="https://www.youtube.com/embed/<?php echo e($videoId); ?>"
                    allowfullscreen>
                </iframe>
            </div>
        </div>
        <?php endif; ?>
    </div>
        
        <script>
        document.getElementById('global-loader').style.display = 'flex';
        
        window.addEventListener('load', function() {
            setTimeout(() => {
                document.getElementById('global-loader').style.display = 'none';
            }, 1000);
        });
        
        document.querySelectorAll('.form-control').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'scale(1.02)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'scale(1)';
            });
        });

    </script>
    </body>
</html>
<?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/user/password/email.blade.php ENDPATH**/ ?>