<?php $__env->startSection('content'); ?>

<style>
.group-box-erp {
    border: 1px solid #b5b5b5;
    padding: 15px;
    border-radius: 5px;
    background: #ffffff;
    margin-top: 10px;
}

.group-grid {
    display: grid;
    grid-template-columns: 180px 150px 150px;
    gap: 10px 15px;
    align-items: center;
}

.group-grid label {
    margin: 0;
    font-weight: 600;
    font-size: 14px;
}

.input-number {
    text-align: right;
}

.tax-input {
    width: 70px;
    display: inline-block;
}

.tfoot-totals td {
    font-weight: bold;
    padding: 10px 5px;
    text-align: right;
}

.tfoot-totals span {
    display: block;
    margin-top: 5px;
    font-size: 14px;
    color: #495057;
}

/* Keyboard navigation highlights */
.form-control:focus,
.select2-container--focus .select2-selection {
    border-color: #007bff !important;
    box-shadow: 0 0 0 2px rgba(0, 123, 255, 0.25) !important;
    outline: none;
}

.keyboard-hint {
    font-size: 12px;
    color: #6c757d;
    margin-top: 5px;
}

.shortcut-key {
    display: inline-block;
    background: #e9ecef;
    border: 1px solid #adb5bd;
    border-radius: 3px;
    padding: 1px 4px;
    margin: 0 2px;
    font-size: 11px;
    font-family: monospace;
    color: black !important;
}
.gap-1 {
    gap: 5px;
}

/* Gray out read-only inputs visually */
input[readonly].bg-light {
    background-color: #e9ecef !important;
    opacity: 0.7;
    pointer-events: none; /* Prevents clicking into it */
}

.table-primary th {
    vertical-align: middle;
    font-size: 13px;
}

kbd.shortcut-key {
    color: black !important;
    border-color: #adb5bd !important;
}

.table td,
.table th {
    padding: 9px 4px !important;
}
</style>

<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Purchase</h4>
                    <span class="text-muted mt-1 tx-13 ms-2 mb-0">
                        / <?php echo e(isset($purchase) ? 'Edit' : 'Create'); ?>

                    </span>
                </div>
            </div>
            <div class="keyboard-hint">
                <small>
                    Use <kbd class="shortcut-key">Tab</kbd> to navigate •
                    <kbd class="shortcut-key">Enter</kbd> to submit •
                    <kbd class="shortcut-key">Alt + N</kbd> for new item
                </small>
            </div>
        </div>

        <div class="mt-2">
            <form action="<?php echo e(isset($purchase) ? route('admin.purchase.update', $purchase->id) : route('admin.purchase.store')); ?>"
                method="POST" id="purchaseForm">

                <?php echo csrf_field(); ?>
                <?php if(isset($purchase)): ?>
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>

                <input type="hidden" name="total_discount" id="input_total_discount"
                    value="<?php echo e(isset($purchase) ? $purchase->total_discount : old('total_discount')); ?>">
                <input type="hidden" name="subtotal" id="input_subtotal"
                    value="<?php echo e(isset($purchase) ? $purchase->subtotal : old('subtotal')); ?>">
                <input type="hidden" name="tax_amount" id="input_tax_amount"
                    value="<?php echo e(isset($purchase) ? $purchase->tax_amount : old('tax_amount')); ?>">
                <input type="hidden" name="grand_total" id="input_grand_total"
                    value="<?php echo e(isset($purchase) ? $purchase->grand_total : old('grand_total')); ?>">
                <input type="hidden" name="total_cess" id="input_total_cess"
                    value="<?php echo e(isset($purchase) ? $purchase->total_cess : old('total_cess')); ?>">

                <input type="hidden" name="total_cgst" id="input_total_cgst"
                    value="<?php echo e(isset($purchase) ? $purchase->total_cgst : old('total_cgst')); ?>">
                <input type="hidden" name="total_sgst" id="input_total_sgst"
                    value="<?php echo e(isset($purchase) ? $purchase->total_sgst : old('total_sgst')); ?>">
                <input type="hidden" name="total_igst" id="input_total_igst"
                    value="<?php echo e(isset($purchase) ? $purchase->total_igst : old('total_igst')); ?>">

                <!-- Calculated via JS based on RCM -->
                <input type="hidden" name="payable_amount" id="input_payable_amount"
                    value="<?php echo e(isset($purchase) ? $purchase->payable_amount : old('payable_amount')); ?>">

                <div class="row">
                    <div class="card py-2 box-shadow-0">
                        <div class="card-body">
                            <div class="row mb-0">
                                <!-- LEFT SECTION -->
                                <div class="col-md-4 col-lg-4 col-xxl-3">
                                    <div class="custom-card row">
                                        <div class="col-md-12">

                                            <div class="mb-2">
                                                <label for="vendor_id">Party Name <small class="text-muted"></small></label>
                                                <select name="vendor_id" id="vendor_id" class="form-control select2"
                                                    data-tabindex="1">
                                                    <option value="">Select Party Name</option>
                                                    <?php $__currentLoopData = $vendors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($vendor->id); ?>"
                                                            data-gst="<?php echo e($vendor->gst_no); ?>"
                                                            <?php echo e((isset($purchase) && $purchase->vendor_id == $vendor->id) ? 'selected' : ''); ?>

                                                            <?php echo e(old('vendor_id') == $vendor->id ? 'selected' : ''); ?>>
                                                            <?php echo e($vendor->name); ?> - <?php echo e($vendor->city); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                            <div class="mb-2">
                                                <label for="gst_name">GST Name</label>
                                                <input type="text" name="gst_name" id="gst_name" class="form-control"
                                                    data-tabindex="2"
                                                    value="<?php echo e(isset($purchase) ? $purchase->gst_name : old('gst_name')); ?>"
                                                    placeholder="Press Tab to move next">
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <!-- RIGHT MAIN SECTION -->
                                <div class="col-md-8 col-lg-8 col-xxl-9">
                                    <!-- VOUCHER / REF / PO GROUP -->
                                    <div class="group-box-erp mb-3">
                                        <div class="group-grid">
                                            <label for="voucher_no">Voucher No - Date</label>
                                            <input type="text" name="voucher_no" id="voucher_no" class="form-control"
                                                placeholder="Voucher No" data-tabindex="7"
                                                value="<?php echo e(isset($purchase) ? $purchase->voucher_no : old('voucher_no', $voucher_no)); ?>">

                                            <input type="hidden" name="voucher_no_int" id="voucher_no_int" class=""
                                                placeholder="Voucher No"
                                                value="<?php echo e(isset($purchase) ? $purchase->voucher_no_int : old('voucher_no_int', $voucher_no_int)); ?>">

                                            <input type="text" name="voucher_date" id="voucher_date"
                                                class="form-control flatpicker" placeholder="Voucher Date"
                                                data-tabindex="8"
                                                value="<?php echo e(isset($purchase) ? _d($purchase->voucher_date) : (old('voucher_date') ?? date('d-m-Y'))); ?>">

                                            <label for="">Party's Ref No - Date</label>
                                            <input type="text" name="party_ref_no" id="party_ref_no"
                                                class="form-control" placeholder="Party's Ref No" data-tabindex="9"
                                                value="<?php echo e(isset($purchase) ? $purchase->party_ref_no : old('party_ref_no')); ?>">
                                            <input type="text" name="ref_date" id="ref_date"
                                                class="form-control flatpicker" placeholder="Date" data-tabindex="10"
                                                value="<?php echo e(isset($purchase) ? _d($purchase->ref_date) : (old('ref_date') ?? date('d-m-Y'))); ?>">

                                            <label>P.O No - Date</label>
                                            <input type="text" name="po_no" id="po_no" class="form-control"
                                                placeholder="P.O No" data-tabindex="11"
                                                value="<?php echo e(isset($purchase) ? $purchase->po_no : old('po_no')); ?>">
                                            <input type="text" name="po_date" id="po_date"
                                                class="form-control flatpicker" placeholder="P.O Date"
                                                data-tabindex="12"
                                                value="<?php echo e(isset($purchase) ? _d($purchase->po_date) : (old('po_date') ?? date('d-m-Y'))); ?>">
                                        </div>
                                    </div>

                                    <!-- BILL / INVOICE / GST / RCM SECTION -->
                                    <div class="row">
                                        <div class="col-md-6 col-lg-3 mb-1">
                                            <label for="payment_dr_cr">Bill</label>
                                            <select class="form-control select2" name="payment_dr_cr"
                                                id="payment_dr_cr" data-tabindex="13">
                                                <option value="Debit"
                                                    <?php echo e((isset($purchase) && $purchase->payment_dr_cr == 'Debit') ? 'selected' : ''); ?>

                                                    <?php echo e(old('payment_dr_cr') == 'Debit' ? 'selected' : ''); ?>>Debit</option>
                                                <option value="Credit"
                                                    <?php echo e((isset($purchase) && $purchase->payment_dr_cr == 'Credit') ? 'selected' : ''); ?>

                                                    <?php echo e(old('payment_dr_cr') == 'Credit' ? 'selected' : ''); ?>>Credit</option>
                                            </select>
                                        </div>

                                        <div class="col-md-6 col-lg-3 mb-1">
                                            <label for="invoice">Invoice</label>
                                            <select class="form-control select2" name="invoice" id="invoice"
                                                data-tabindex="14">
                                                <option value="1"
                                                    <?php echo e((isset($purchase) && $purchase->invoice == '1') ? 'selected' : ''); ?>

                                                    <?php echo e(old('invoice') == '1' ? 'selected' : ''); ?>>Tax Invoice</option>
                                            </select>
                                        </div>

                                        <div class="col-md-6 col-lg-3 mb-1">
                                            <label for="gst_rcm_itc">GST / RCM / ITC
                                                <span class="text-red">*</span></label>
                                            <select class="form-control select2" name="gst_rcm_itc" id="gst_rcm_itc"
                                                data-tabindex="15" required>
                                                <option value="">Select</option>
                                                <option value="GST"
                                                    <?php echo e((isset($purchase) && $purchase->gst_rcm_itc == 'GST') ? 'selected' : ''); ?>

                                                    <?php echo e(old('gst_rcm_itc') == 'GST' ? 'selected' : ''); ?>>GST</option>
                                                <option value="RCM"
                                                    <?php echo e((isset($purchase) && $purchase->gst_rcm_itc == 'RCM') ? 'selected' : ''); ?>

                                                    <?php echo e(old('gst_rcm_itc') == 'RCM' ? 'selected' : ''); ?>>RCM</option>
                                                <option value="ITC"
                                                    <?php echo e((isset($purchase) && $purchase->gst_rcm_itc == 'ITC') ? 'selected' : ''); ?>

                                                    <?php echo e(old('gst_rcm_itc') == 'ITC' ? 'selected' : ''); ?>>ITC</option>
                                            </select>
                                        </div>

                                        <div class="col-md-3 mb-1 d-flex align-items-end">
                                            <label class="checkbox-item w-100">
                                                <input type="checkbox" class="me-2" name="rcm" id="rcm"
                                                    value="1" data-tabindex="16"
                                                    <?php echo e((isset($purchase) && $purchase->rcm) ? 'checked' : ''); ?>

                                                    <?php echo e(old('rcm') ? 'checked' : ''); ?>>
                                                <span>RCM</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <!-- /RIGHT MAIN SECTION -->
                            </div>
                        </div>
                    </div>
                </div>

                <!-- ITEMS TABLE -->
                <div class="card">
                    <div class="card-header">
                        <div>
                            Items
                            <small class="text-muted">
                                (Press <kbd class="shortcut-key">Alt + N</kbd> to add new row)
                            </small>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered align-middle" id="itemsTable">
                                <thead class="table-primary text-center">
                                    <tr>
                                        <th style="width: 50px;">Sr</th>
                                        <th style="width: 50px;">P</th>
                                        <th style="width: 250px;">Item Name</th>
                                        <th style="width: 80px;">Pack</th>
                                        <th style="width: 100px;">GRN No</th>
                                        <th style="width: 80px;">Qty</th>
                                        <th style="width: 100px;">Net Rate</th>
                                        <th style="width: 120px;">Amount</th>
                                        <th style="width: 140px;">CGST | SGST (%)</th>
                                        <th style="width: 70px;">IGST (%)</th>
                                        <th style="width: 70px;">CESS (%)</th>
                                        <th style="width: 80px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody class="item-table-body">
                                    <?php if(isset($purchase) && $purchase->items->count() > 0): ?>
                                        <?php $__currentLoopData = $purchase->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="item-row">
                                                <?php if(isset($item->id)): ?>
                                                    <input type="hidden" name="items[<?php echo e($index); ?>][id]"
                                                        value="<?php echo e($item->id); ?>">
                                                <?php endif; ?>

                                                <td class="text-center sr-no"><?php echo e($index + 1); ?></td>

                                                <td>
                                                    <input type="text" class="form-control item-field"
                                                        name="items[<?php echo e($index); ?>][p]"
                                                        value="<?php echo e($item->p ?? ''); ?>"
                                                        placeholder="P">
                                                </td>

                                                <td>
                                                    <select class="form-control item-field item-select"
                                                        name="items[<?php echo e($index); ?>][item_id]">
                                                        <option value="">Select Item</option>
                                                        <?php $__currentLoopData = $rawMaterials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($rm->id); ?>"
                                                                data-cgst="<?php echo e($rm->cgst); ?>"
                                                                data-sgst="<?php echo e($rm->sgst); ?>"
                                                                data-igst="<?php echo e($rm->igst); ?>"
                                                                data-cess="<?php echo e($rm->cess); ?>"
                                                                data-pack="<?php echo e($rm->unit_name ?? ''); ?>"
                                                                data-rate="<?php echo e($rm->purchase_rate ?? ''); ?>"
                                                                <?php echo e((isset($item) && $item->item_id == $rm->id) ? 'selected' : ''); ?>>
                                                                <?php echo e($rm->item_name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                    <input type="hidden" class="form-control item-field"
                                                        name="items[<?php echo e($index); ?>][item_name]"
                                                        value="<?php echo e($item->item_name ?? ''); ?>">
                                                </td>

                                                <td>
                                                    <input type="text" class="form-control item-field"
                                                        name="items[<?php echo e($index); ?>][pack]"
                                                        value="<?php echo e($item->pack ?? ''); ?>"
                                                        placeholder="Pack">
                                                </td>

                                                <td>
                                                    <input type="text" class="form-control item-field"
                                                        name="items[<?php echo e($index); ?>][grn_no]"
                                                        value="<?php echo e($item->grn_no ?? ''); ?>"
                                                        placeholder="GRN">
                                                </td>

                                                <td>
                                                    <input type="number"
                                                        class="form-control input-number quantity item-field"
                                                        name="items[<?php echo e($index); ?>][quantity]"
                                                        value="<?php echo e($item->quantity ?? ''); ?>"
                                                        placeholder="Qty" min="0" step="1">
                                                </td>

                                                <td>
                                                    <input type="number"
                                                        class="form-control input-number net-rate item-field"
                                                        name="items[<?php echo e($index); ?>][net_rate]"
                                                        value="<?php echo e($item->net_rate ?? ''); ?>"
                                                        placeholder="Rate" min="0" step="0.01">
                                                </td>

                                                <td>
                                                    <input type="number"
                                                        class="form-control input-number amount"
                                                        name="items[<?php echo e($index); ?>][amount]"
                                                        value="<?php echo e($item->amount ?? ''); ?>"
                                                        placeholder="Amount" readonly>
                                                </td>

                                                <td>
                                                    <div class="d-flex gap-1">
                                                        <div class="text-center">
                                                            <input type="number"
                                                                class="form-control tax-input cgst item-field p-1"
                                                                name="items[<?php echo e($index); ?>][cgst]"
                                                                value="<?php echo e($item->cgst ?? 0); ?>"
                                                                placeholder="C%" min="0" max="100" step="1">
                                                            <small class="text-muted d-block"
                                                                style="font-size:9px">CGST</small>
                                                        </div>
                                                        <div class="text-center">
                                                            <input type="number"
                                                                class="form-control tax-input sgst item-field p-1"
                                                                name="items[<?php echo e($index); ?>][sgst]"
                                                                value="<?php echo e($item->sgst ?? 0); ?>"
                                                                placeholder="S%" min="0" max="100" step="1">
                                                            <small class="text-muted d-block"
                                                                style="font-size:9px">SGST</small>
                                                        </div>
                                                    </div>
                                                </td>

                                                <td>
                                                    <div class="text-center">
                                                        <input type="number"
                                                            class="form-control tax-input igst item-field p-1"
                                                            name="items[<?php echo e($index); ?>][igst]"
                                                            value="<?php echo e($item->igst ?? 0); ?>"
                                                            placeholder="I%" min="0" max="100" step="1">
                                                        <small class="text-muted d-block"
                                                            style="font-size:9px">IGST</small>
                                                    </div>
                                                </td>

                                                <td>
                                                    <div class="text-center">
                                                        <input type="number"
                                                            class="form-control tax-input cess item-field p-1"
                                                            name="items[<?php echo e($index); ?>][cess]"
                                                            value="<?php echo e($item->cess ?? 0); ?>"
                                                            placeholder="C%" min="0" max="100" step="1">
                                                        <small class="text-muted d-block"
                                                            style="font-size:9px">CESS</small>
                                                    </div>
                                                </td>

                                                <td class="text-center">
                                                    <?php if($index === 0 && (!isset($purchase) || $purchase->items->count() <= 1)): ?>
                                                        <button type="button"
                                                            class="btn btn-primary btn-sm add-row">
                                                            <i class="fa fa-plus"></i>
                                                        </button>
                                                    <?php else: ?>
                                                        <button type="button"
                                                            class="btn btn-danger btn-sm remove-row">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <!-- Default Empty Row -->
                                        <tr class="item-row">
                                            <td class="text-center sr-no">1</td>
                                            <td>
                                                <input type="text" class="form-control item-field"
                                                    name="items[0][p]" placeholder="P">
                                            </td>
                                            <td>
                                                <select class="form-control item-field item-select"
                                                    name="items[0][item_id]">
                                                    <option value="">Select Item</option>
                                                    <?php $__currentLoopData = $rawMaterials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($rm->id); ?>"
                                                            data-cgst="<?php echo e($rm->cgst); ?>"
                                                            data-sgst="<?php echo e($rm->sgst); ?>"
                                                            data-igst="<?php echo e($rm->igst); ?>"
                                                            data-cess="<?php echo e($rm->cess); ?>"
                                                            data-pack="<?php echo e($rm->unit_name ?? ''); ?>"
                                                            data-rate="<?php echo e($rm->purchase_rate ?? ''); ?>">
                                                            <?php echo e($rm->item_name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <input type="hidden" class="form-control item-field"
                                                    name="items[0][item_name]" value="">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control item-field"
                                                    name="items[0][pack]" placeholder="Pack">
                                            </td>
                                            <td>
                                                <input type="text" class="form-control item-field"
                                                    name="items[0][grn_no]" placeholder="GRN No">
                                            </td>
                                            <td>
                                                <input type="number"
                                                    class="form-control input-number quantity item-field"
                                                    name="items[0][quantity]" placeholder="Qty"
                                                    min="0" step="1">
                                            </td>
                                            <td>
                                                <input type="number"
                                                    class="form-control input-number net-rate item-field"
                                                    name="items[0][net_rate]" placeholder="Rate"
                                                    min="0" step="1">
                                            </td>
                                            <td>
                                                <input type="number"
                                                    class="form-control input-number amount"
                                                    name="items[0][amount]" placeholder="Amount"
                                                    readonly>
                                            </td>

                                            <td>
                                                <div class="d-flex justify-content-center gap-1">
                                                    <div class="text-center">
                                                        <input type="number"
                                                            class="form-control tax-input cgst item-field p-1"
                                                            name="items[0][cgst]" value="0"
                                                            placeholder="C%" min="0" max="100" step="1">
                                                        <small class="text-muted d-block"
                                                            style="font-size:9px">CGST</small>
                                                    </div>
                                                    <div class="text-center">
                                                        <input type="number"
                                                            class="form-control tax-input sgst item-field p-1"
                                                            name="items[0][sgst]" value="0"
                                                            placeholder="S%" min="0" max="100" step="1">
                                                        <small class="text-muted d-block"
                                                            style="font-size:9px">SGST</small>
                                                    </div>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="text-center">
                                                    <input type="number"
                                                        class="form-control tax-input igst item-field p-1"
                                                        name="items[0][igst]" value="0"
                                                        placeholder="I%" min="0" max="100" step="0.01">
                                                    <small class="text-muted d-block"
                                                        style="font-size:9px">IGST</small>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="text-center">
                                                    <input type="number"
                                                        class="form-control tax-input cess item-field p-1"
                                                        name="items[0][cess]" value="0"
                                                        placeholder="C%" min="0" max="100" step="0.01">
                                                    <small class="text-muted d-block"
                                                        style="font-size:9px">CESS</small>
                                                </div>
                                            </td>

                                            <td class="text-center">
                                                <button type="button"
                                                    class="btn btn-primary btn-sm add-row">
                                                    <i class="fa fa-plus"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                                <tfoot class="bg-light">
                                    <!-- Detailed Totals -->
                                    <tr>
                                        <td colspan="8" class="text-end font-weight-bold">Basic Total :</td>
                                        <td class="text-end">
                                            <span id="subtotal">0.00</span>
                                        </td>
                                        <td colspan="3"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="8" class="text-end text-muted">Total CGST :</td>
                                        <td class="text-end text-muted">
                                            <span id="footer-total-cgst">0.00</span>
                                        </td>
                                        <td colspan="3"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="8" class="text-end text-muted">Total SGST :</td>
                                        <td class="text-end text-muted">
                                            <span id="footer-total-sgst">0.00</span>
                                        </td>
                                        <td colspan="3"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="8" class="text-end text-muted">Total IGST :</td>
                                        <td class="text-end text-muted">
                                            <span id="footer-total-igst">0.00</span>
                                        </td>
                                        <td colspan="3"></td>
                                    </tr>
                                    <tr>
                                        <td colspan="8" class="text-end text-muted">Total CESS :</td>
                                        <td class="text-end text-muted">
                                            <span id="footer-total-cess">0.00</span>
                                        </td>
                                        <td colspan="3"></td>
                                    </tr>

                                    <!-- Grand Total (Total Value including Tax) -->
                                    <tr>
                                        <td colspan="8"
                                            class="text-end tx-14 font-weight-bold text-muted">
                                            Grand Total :
                                        </td>
                                        <td class="text-end tx-14 font-weight-bold text-muted">
                                            <span id="grand-total">0.00</span>
                                        </td>
                                        <td colspan="3"></td>
                                    </tr>

                                    <!-- Payable Amount (Dynamic based on RCM) -->
                                    <tr class="table-success border-top border-2">
                                        <td colspan="8"
                                            class="text-end tx-16 font-weight-bold text-success">
                                            Payable Amount :
                                        </td>
                                        <td class="text-end tx-16 font-weight-bold text-success">
                                            <span id="footer-payable-amount">0.00</span>
                                        </td>
                                        <td colspan="3"></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- FORM BUTTONS -->
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12 text-end">
                                <button type="submit" class="btn btn-primary me-2"
                                    data-tabindex="1000">
                                    <?php echo e(isset($purchase) ? 'Update Purchase' : 'Create Purchase'); ?>

                                </button>
                                <a href="<?php echo e(route('admin.purchase.index')); ?>"
                                    class="btn btn-secondary" data-tabindex="1001">
                                    Cancel
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /FORM BUTTONS -->
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Initialize Select2 for vendor dropdown
    $('#vendor_id').select2();

    // Initialize other Select2 dropdowns
    $('#payment_dr_cr').select2();
    $('#invoice').select2();
    $('#gst_rcm_itc').select2();

    // Initialize Select2 for item dropdowns with a small delay
    setTimeout(function () {
        $('.item-select').select2({
            placeholder: 'Select Item',
            allowClear: true
        });
    }, 100);

    $('.flatpicker').flatpickr({
        dateFormat: "d-m-Y",
        allowInput: true,
    });

    // --- TABINDEX RE-INDEXING (for all item rows) ---
    function reIndexTabIndex() {
        // 17 is the starting tabindex for first item row (after header fields)
        const startIndex = 17;
        const perRow = 11; // p, item_id, pack, grn_no, qty, net_rate, cgst, sgst, igst, cess, action

        $("#itemsTable tbody tr").each(function (rowIndex) {
            const base = startIndex + (rowIndex * perRow);

            const row = $(this);
            row.find('input[name^="items["][name$="[p]"]').attr('data-tabindex', base);
            row.find('select[name^="items["][name$="[item_id]"]').attr('data-tabindex', base + 1);
            row.find('input[name^="items["][name$="[pack]"]').attr('data-tabindex', base + 2);
            row.find('input[name^="items["][name$="[grn_no]"]').attr('data-tabindex', base + 3);
            row.find('.quantity').attr('data-tabindex', base + 4);
            row.find('.net-rate').attr('data-tabindex', base + 5);
            row.find('.cgst').attr('data-tabindex', base + 6);
            row.find('.sgst').attr('data-tabindex', base + 7);
            row.find('.igst').attr('data-tabindex', base + 8);
            row.find('.cess').attr('data-tabindex', base + 9);
            row.find('.add-row, .remove-row').attr('data-tabindex', base + 10);
        });
    }

    // --- GST FIELD STATE (Readonly/Editable) ---
    function toggleGstFields() {
        const vendorGst = $('#vendor_id option:selected').data('gst') || '';
        const isSameState = vendorGst.toString().startsWith('24'); // Example: Gujarat = 24

        $('.item-row').each(function () {
            const cgstInput = $(this).find('.cgst');
            const sgstInput = $(this).find('.sgst');
            const igstInput = $(this).find('.igst');
            // CESS is NOT controlled by state now (keeps raw material value)
            const cessInput = $(this).find('.cess');

            if (isSameState) {
                // Local State: Enable CGST/SGST, Disable IGST
                cgstInput.prop('readonly', false).removeClass('bg-light');
                sgstInput.prop('readonly', false).removeClass('bg-light');

                igstInput.val(0).prop('readonly', true).addClass('bg-light');

                // CESS remains as per raw material / user input
                cessInput.prop('readonly', false).removeClass('bg-light');
            } else {
                // Inter State: Enable IGST, Disable CGST/SGST
                igstInput.prop('readonly', false).removeClass('bg-light');

                cgstInput.val(0).prop('readonly', true).addClass('bg-light');
                sgstInput.val(0).prop('readonly', true).addClass('bg-light');

                // CESS remains as per raw material / user input
                cessInput.prop('readonly', false).removeClass('bg-light');
            }
        });

        calculateTotals();
    }

    // Trigger on Vendor Change
    $('#vendor_id').on('change', function () {
        toggleGstFields();

        // Refill GST + CESS if item is already selected
        $("#itemsTable tbody tr").each(function () {
            const row = $(this);
            const selectedOption = row.find('.item-select option:selected');

            if (selectedOption.val()) {
                row.find('.cgst').val(selectedOption.data('cgst') || 0);
                row.find('.sgst').val(selectedOption.data('sgst') || 0);
                row.find('.igst').val(selectedOption.data('igst') || 0);
                row.find('.cess').val(selectedOption.data('cess') || 0);

                toggleGstFields();
            }
        });

        calculateTotals();
    });

    // --- RCM CHECKBOX CHANGED ---
    $('#rcm').on('change', function () {
        calculateTotals();
    });

    // --- ADD NEW ROW ---
    function addNewRow() {
        const tableBody = $("#itemsTable tbody");
        const newIndex = tableBody.find("tr").length;

        // Tabindex base is auto handled by reIndexTabIndex after append
        const newRow = `
        <tr class="item-row">
            <td class="text-center sr-no">${newIndex + 1}</td>

            <td>
                <input type="text" class="form-control item-field"
                    name="items[${newIndex}][p]" placeholder="P">
            </td>

            <td>
                <select class="form-control item-field item-select"
                    name="items[${newIndex}][item_id]">
                    <option value="">Select Item</option>
                    <?php $__currentLoopData = $rawMaterials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($rm->id); ?>"
                            data-cgst="<?php echo e($rm->cgst); ?>"
                            data-sgst="<?php echo e($rm->sgst); ?>"
                            data-igst="<?php echo e($rm->igst); ?>"
                            data-cess="<?php echo e($rm->cess); ?>"
                            data-pack="<?php echo e($rm->unit_name ?? ''); ?>"
                            data-rate="<?php echo e($rm->purchase_rate ?? ''); ?>">
                            <?php echo e($rm->item_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <input type="hidden" class="form-control item-field"
                    name="items[${newIndex}][item_name]" value="">
            </td>

            <td>
                <input type="text" class="form-control item-field"
                    name="items[${newIndex}][pack]" placeholder="Pack">
            </td>

            <td>
                <input type="text" class="form-control item-field"
                    name="items[${newIndex}][grn_no]" placeholder="GRN No">
            </td>

            <td>
                <input type="number"
                    class="form-control input-number quantity item-field"
                    name="items[${newIndex}][quantity]" placeholder="Qty"
                    min="0" step="1">
            </td>

            <td>
                <input type="number"
                    class="form-control input-number net-rate item-field"
                    name="items[${newIndex}][net_rate]" placeholder="Rate"
                    min="0" step="0.01">
            </td>

            <td>
                <input type="number"
                    class="form-control input-number amount"
                    name="items[${newIndex}][amount]" placeholder="Amount"
                    readonly>
            </td>

            <td>
                <div class="d-flex justify-content-center gap-1">
                    <div class="text-center">
                        <input type="number"
                            class="form-control tax-input cgst item-field p-1"
                            name="items[${newIndex}][cgst]" value="0"
                            placeholder="C%" min="0" max="100" step="1">
                        <small class="text-muted d-block"
                            style="font-size:9px">CGST</small>
                    </div>
                    <div class="text-center">
                        <input type="number"
                            class="form-control tax-input sgst item-field p-1"
                            name="items[${newIndex}][sgst]" value="0"
                            placeholder="S%" min="0" max="100" step="1">
                        <small class="text-muted d-block"
                            style="font-size:9px">SGST</small>
                    </div>
                </div>
            </td>

            <td>
                <div class="text-center">
                    <input type="number"
                        class="form-control tax-input igst item-field p-1"
                        name="items[${newIndex}][igst]" value="0"
                        placeholder="I%" min="0" max="100" step="1">
                    <small class="text-muted d-block"
                        style="font-size:9px">IGST</small>
                </div>
            </td>

            <td>
                <div class="text-center">
                    <input type="number"
                        class="form-control tax-input cess item-field p-1"
                        name="items[${newIndex}][cess]" value="0"
                        placeholder="C%" min="0" max="100" step="1">
                    <small class="text-muted d-block"
                        style="font-size:9px">CESS</small>
                </div>
            </td>

            <td class="text-center">
                <button type="button"
                    class="btn btn-danger btn-sm remove-row">
                    <i class="fa fa-trash"></i>
                </button>
            </td>
        </tr>`;

        tableBody.append(newRow);

        // Initialize Select2 on new element
        tableBody.find('.item-select').last().select2({
            placeholder: 'Select Item',
            allowClear: true
        });

        updateSrNumbers();
        reIndexTabIndex();
        toggleGstFields();
    }

    $(document).on("click", ".add-row", addNewRow);

    // Remove row
    $(document).on("click", ".remove-row", function () {
        $(this).closest("tr").remove();
        updateSrNumbers();
        reIndexTabIndex();
        calculateTotals();
    });

    // --- Item Select Change Logic ---
    $(document).on('change', '.item-select', function () {
        const row = $(this).closest('tr');
        const selectedOption = $(this).find('option:selected');

        row.find('input[name*="[item_name]"]').val(selectedOption.text());
        if (!row.find('input[name*="[pack]"]').val()) {
            row.find('input[name*="[pack]"]').val(selectedOption.data('pack') || '');
        }
        if (!row.find('.net-rate').val()) {
            row.find('.net-rate').val(selectedOption.data('rate') || '');
        }

        row.find('.cgst').val(selectedOption.data('cgst') || 0);
        row.find('.sgst').val(selectedOption.data('sgst') || 0);
        row.find('.igst').val(selectedOption.data('igst') || 0);
        row.find('.cess').val(selectedOption.data('cess') || 0);

        toggleGstFields();
        calculateTotals();
    });

    // --- Calculation Logic ---
    $(document).on('input change',
        '.quantity, .net-rate, .cgst, .sgst, .igst, .cess', function () {
            calculateTotals();
        });

    function calculateTotals() {
        let globalSubtotal = 0;
        let globalCgstTotal = 0;
        let globalSgstTotal = 0;
        let globalIgstTotal = 0;
        let globalCessTotal = 0;

        $("#itemsTable tbody tr").each(function () {
            const row = $(this);
            const qty = parseFloat(row.find('.quantity').val()) || 0;
            const rate = parseFloat(row.find('.net-rate').val()) || 0;
            const cgstRate = parseFloat(row.find('.cgst').val()) || 0;
            const sgstRate = parseFloat(row.find('.sgst').val()) || 0;
            const igstRate = parseFloat(row.find('.igst').val()) || 0;
            const cessRate = parseFloat(row.find('.cess').val()) || 0;

            // Row Amount (Base)
            const baseAmount = qty * rate;
            row.find('.amount').val(baseAmount.toFixed(2));

            // Calculate individual Taxes
            const rowCgstAmt = baseAmount * (cgstRate / 100);
            const rowSgstAmt = baseAmount * (sgstRate / 100);
            const rowIgstAmt = baseAmount * (igstRate / 100);
            const rowCessAmt = baseAmount * (cessRate / 100);

            // Add to globals
            globalSubtotal += baseAmount;
            globalCgstTotal += rowCgstAmt;
            globalSgstTotal += rowSgstAmt;
            globalIgstTotal += rowIgstAmt;
            globalCessTotal += rowCessAmt;
        });

        const totalTax =
            globalCgstTotal + globalSgstTotal + globalIgstTotal + globalCessTotal;
        const grandTotal = globalSubtotal + totalTax;

        // RCM LOGIC
        const isRcmChecked = $('#rcm').is(':checked');
        const payableAmount = isRcmChecked ? globalSubtotal : grandTotal;

        // Update HTML Footer Display
        $('#subtotal').text(globalSubtotal.toFixed(2));
        $('#footer-total-cgst').text(globalCgstTotal.toFixed(2));
        $('#footer-total-sgst').text(globalSgstTotal.toFixed(2));
        $('#footer-total-igst').text(globalIgstTotal.toFixed(2));
        $('#footer-total-cess').text(globalCessTotal.toFixed(2));
        $('#grand-total').text(grandTotal.toFixed(2));
        $('#footer-payable-amount').text(payableAmount.toFixed(2));

        // Update Hidden Inputs for Form Submission
        $('#input_subtotal').val(globalSubtotal.toFixed(2));
        $('#input_tax_amount').val(totalTax.toFixed(2));
        $('#input_grand_total').val(grandTotal.toFixed(2));
        $('#input_total_cess').val(globalCessTotal.toFixed(2));
        $('#input_payable_amount').val(payableAmount.toFixed(2));
        $('#input_total_cgst').val(globalCgstTotal.toFixed(2));
        $('#input_total_sgst').val(globalSgstTotal.toFixed(2));
        $('#input_total_igst').val(globalIgstTotal.toFixed(2));
    }

    function updateSrNumbers() {
        $("#itemsTable tbody tr").each(function (index) {
            $(this).find(".sr-no").text(index + 1);
        });
    }

    // ALT+N shortcut for new row
    $(document).on('keydown', function (e) {
        if (e.altKey && (e.key === 'n' || e.key === 'N')) {
            e.preventDefault();
            addNewRow();
        }
    });

    // Init Logic
    setTimeout(function () {
        reIndexTabIndex();
        toggleGstFields();
        calculateTotals();
    }, 200);
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/purchase/create.blade.php ENDPATH**/ ?>