<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="main-container container-fluid">

        
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <h4 class="content-title mb-0 my-auto animate-charcter">Purchase List</h4>
            </div>
            <div class="d-flex my-xl-auto right-content">
                <a class="btn btn-primary" href="<?php echo e(route('admin.purchase.create')); ?>">Add Purchase</a>
            </div>
        </div>

        
        <div class="card">
            <div class="card-header pb-0 card_filter">
                <div class="d-flex justify-content-end align-items-center pb-2">
                    <button id="toggleFilter" class="btn btn-secondary">
                        <i class="fas fa-filter"></i> Filter
                    </button>
                </div>
            </div>

            <div class="card-body toggler_filter">
                <form id="searchForm">
                    <?php echo csrf_field(); ?>
                    <div class="row">

                        
                        <div class="col-xl-3 col-md-4 mb-2">
                            <label class="form-label">Vendor</label>
                            <select name="vendor_id" id="vendor_id" class="form-control">
                                <option value="">-- All Vendors --</option>
                                <?php $__currentLoopData = \App\Models\VendorData\Vendor::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($vendor->id); ?>"><?php echo e($vendor->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        
                        <div class="col-xl-3 col-md-4 mb-2">
                            <label class="form-label">Start Date</label>
                            <input type="text" id="start_date" name="start_date" class="form-control scheduleTime" placeholder="Start Date">
                        </div>

                        
                        <div class="col-xl-3 col-md-4 mb-2">
                            <label class="form-label">End Date</label>
                            <input type="text" id="end_date" name="end_date" class="form-control scheduleTime" placeholder="End Date">
                        </div>

                        
                        <div class="col-xl-3 col-md-3 mb-2">
                            <div class="form-label">&nbsp;</div>
                            <button type="button" class="btn btn-primary" id="searchBtn">Search</button>
                            <button type="button" class="btn btn-danger" id="resetBtn">Reset</button>
                        </div>

                    </div>
                </form>
            </div>
        </div>

        
        <div class="row row-sm">
            <div class="col-12 grid-margin">
                <div class="card gradient-border">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered" id="purchaseTable">
                                <thead>
                                    <tr>
                                        <th>Sr.</th>
                                        <th>Vendor</th>
                                        <th>Voucher No</th>
                                        <th>Voucher Date</th>
                                        <th>Total</th>
                                        <th>Item Count</th>
                                        <th>Payment (DR/CR)</th>
                                        <th>GST Type</th>
                                        <th>Created At</th>
                                        <th style="width:120px;">Action</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
flatpickr(".scheduleTime", {
    enableTime: false,
    dateFormat: "d-m-Y",
    allowClear: true,
});

var purchaseTable;

$(document).ready(function() {

    purchaseTable = $('#purchaseTable').DataTable({
        responsive: false,
        autoWidth: false,
        pageLength: 10,
        stateSave: true,
        processing: true,
        serverSide: true,

        ajax: {
            url: "<?php echo e(route('admin.purchase.index')); ?>",
            type: "GET",
            data: function (d) {
                d.vendor_id  = $('#vendor_id').val();
                d.start_date = $('#start_date').val();
                d.end_date   = $('#end_date').val();
                d._token     = "<?php echo e(csrf_token()); ?>";
            },
        },

        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', className: 'text-center',orderable:false,searchable:false },
            { data: 'vendor_name', name: 'vendor_name' },
            { data: 'voucher_no', name: 'voucher_no', className: 'text-center' },
            { data: 'voucher_date', name: 'voucher_date', className: 'text-center' },
            { data: 'grand_total', name: 'grand_total', className: 'text-end' },
            { data: 'item_count', name: 'item_count', className: 'text-center' },
            { data: 'payment_dr_cr', name: 'payment_dr_cr', className: 'text-center' },
            { data: 'gst_rcm_itc', name: 'gst_rcm_itc', className: 'text-center' },
            { data: 'created_at', name: 'created_at', className: 'text-center' },
            { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-center' },
        ]

    });

    // Search
    $('#searchBtn').click(function() {
        purchaseTable.ajax.reload();
    });

    // Reset
    $('#resetBtn').click(function() {
        $('#searchForm')[0].reset();
        purchaseTable.ajax.reload();
    });

    // Delete Record
    $(document).on("click", ".data-delete", function () {
        let id = $(this).data('id');

        Swal.fire({
            title: "Are you sure?",
            text: "Delete this Purchase?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
        }).then((result) => {
            if (result.isConfirmed) {

                $.ajax({
                    type: "DELETE",
                    url: "/secure-dashboard/purchase/" + id,
                    data: { _token: "<?php echo e(csrf_token()); ?>" },
                    success: function(resp) {
                        if (resp.success) {
                            purchaseTable.ajax.reload(null, false);
                            toastr.success(resp.message);
                        }
                    }
                });

            }
        });
    });

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/turbo1cast/public_html/erp.turbo1cast.com/resources/views/admin/purchase/index.blade.php ENDPATH**/ ?>