<?php

use App\Http\Controllers\AdminAuth\LoginRegisterController as AdminloginController;
use App\Http\Controllers\UserAuth\CareerController;
use App\Http\Controllers\UserAuth\HomeController;
use App\Http\Controllers\UserAuth\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/clearcache', function () {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    Artisan::call('optimize');

    return '<h1>Cache facade value cleared</h1>';
});

Route::get('/queuerestart', function () {
    Artisan::call('queue:restart');

    return '<h1>Queue facade value cleared</h1>';
});

Route::get('/welcome', function () {
    return view('welcome');
});
Route::get('/', [HomeController::class, 'home']);

Route::get('/contact', [HomeController::class, 'contact']);
Route::get('/service', [HomeController::class, 'service']);
Route::get('/download', [HomeController::class, 'download']);
Route::get('/about', [HomeController::class, 'about']);
Route::get('/testimonial', [HomeController::class, 'testimonial']);
Route::get('/privacy-policy', [HomeController::class, 'privacy_policy']);
Route::get('/terms-and-conditions', [HomeController::class, 'terms_and_conditions']);
Route::get('/servicedetail/{slug}', [HomeController::class, 'service_detail']);
Route::get('/member-grid', function () {
    return view('user.membergrid');
});
Route::get('/userpdf', [HomeController::class, 'userpdf']);
Route::get('/branding-partner', function () {
    return view('user.branding-partner');
});

Route::post('/memberlogin', [UserController::class, 'memberlogin'])->name('memberlogin');
Route::post('/userregistor', [UserController::class, 'userreqister'])->name('member.userregistor');
Route::get('/password/email', [UserController::class, 'pass_email'])->name('pass_email');
Route::post('/password/email', [UserController::class, 'sendResetLink'])->name('password.email');
Route::get('password/reset/{token}', [UserController::class, 'showResetForm'])->name('password.reset');
Route::post('password/reset', [UserController::class, 'reset'])->name('password.update');
Route::controller(AdminloginController::class)->group(function () {
    Route::get('secure-dashboard/login', 'login')->name('admin.login');
    Route::post('secure-dashboard/authenticate', 'authenticate')->name('admin.authenticate');
});
Route::post('careersave', [CareerController::class, 'careersave'])->name('careersave');
Route::get('checkreferredBy', [UserController::class, 'checkreferredBy'])->name('checkreferredBy');
Route::post('inquirysave', [UserController::class, 'inquirysave'])->name('inquirysave');

Route::get('/test-welcome-mail', function () {
    return view('mail.member.welcome-mail');
});

Route::get('/test-campaign-complete', function () {
    return view('mail.campaign-complete');
});

Route::any('boi-callback', [HomeController::class, 'boi_callback'])->name('boi.callback');

Route::any('webhook', [HomeController::class, 'webhook'])->name('webhook');
Route::any('webhook2', [HomeController::class, 'webhook2'])->name('webhook2');
Route::get('getreport', [HomeController::class, 'getreport'])->name('getreport');
Route::get('testivr/{id}', [HomeController::class, 'testivr'])->name('testivr');
