<?php
use App\Http\Controllers\MemberAuth\HomeController;
use App\Http\Controllers\MemberAuth\LedgerController;
use App\Http\Controllers\MemberAuth\MemberloginController;
use App\Http\Controllers\MemberAuth\CampaignController;
use App\Http\Controllers\MemberAuth\AgencyReportController;
use App\Http\Controllers\MemberAuth\BillPaymentController;
use App\Http\Controllers\MemberAuth\HelpSupportController;
use App\Http\Controllers\MemberAuth\SucseesLeadsReportController;


Route::group(['middleware' => ['is_member']], function() {
    Route::get('dashboard', [HomeController::class, 'dashboard'])->name('dashboard');
    Route::get('profile/edit', [HomeController::class, 'profile_edit'])->name('profile_edit');
    Route::post('profile/update', [HomeController::class, 'profile_update'])->name('profile_update');
    Route::get('setting', [HomeController::class, 'setting'])->name('setting');
    Route::any('logout', [MemberloginController::class, 'logout'])->name('logout');
    Route::any('gettoken', [HomeController::class, 'gettoken']);
    Route::any('uploadfiletobonvoice/{id}', [HomeController::class, 'uploadfiletobonvoice']);
    Route::any('voicecalllist', [HomeController::class, 'voicecalllist']);

    Route::get('ledger',[LedgerController::class, 'index'])->name('ledger.index');
    Route::post('ledger/create',[LedgerController::class, 'create'])->name('ledger.create');
    Route::post('ledger/store',[LedgerController::class, 'store'])->name('ledger.store');
    Route::post('ledger/edit',[LedgerController::class, 'edit'])->name('ledger.edit');
    Route::post('ledger/update',[LedgerController::class, 'update'])->name('ledger.update');
    Route::post('ledger/sequence_update',[LedgerController::class, 'sequence_update'])->name('ledger.sequence_update');
    Route::get('ledger/excelExport',[LedgerController::class, 'excelExport'])->name('ledger.excelExport');
    Route::post('ledger/delete', [LedgerController::class, 'destroy'])->name('ledger.destroy');

    Route::get('agency-report',[AgencyReportController::class, 'index'])->name('agencyreport.index');
    Route::get('memberbalance',[AgencyReportController::class, 'memberbalance'])->name('memberbalance');
    Route::get('agencycommisonreport',[AgencyReportController::class, 'agencycommisonreport'])->name('agencycommisonreport');
    Route::get('agencymemberexport',[AgencyReportController::class, 'agencymemberexport'])->name('agencymemberexport');
    Route::post('transfer-member', [AgencyReportController::class, 'transferMember']);
    Route::post('check-member-mobile', [AgencyReportController::class, 'checkMemberMobile']);

    Route::post('commisonnoteupdate', [AgencyReportController::class, 'commisonnoteupdate'])->name('agencyreport.commisonnoteupdate');
    Route::post('membernoteupdate', [AgencyReportController::class, 'membernoteupdate'])->name('agencyreport.membernoteupdate');




    Route::get('help-support',[HelpSupportController::class, 'index'])->name('helpsupport.index');


    Route::get('bill-payment',[BillPaymentController::class, 'index'])->name('billpayment');
    Route::get('bill-payment/excelExport',[BillPaymentController::class, 'excelExport'])->name('billpayment.excelExport'); 
    Route::get('bill-payment/invoice/{id}',[BillPaymentController::class, 'invoice'])->name('billpayment.invoice'); 


   
    Route::controller(CampaignController::class)->prefix('campaign')->name('campaign.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::post('/audience', 'audience')->name('audience');
        Route::post('/store', 'store')->name('store');
        Route::post('/edit', 'edit')->name('edit');
        Route::post('/update', 'update')->name('update');
        Route::post('/destroy', 'destroy')->name('destroy');
        Route::post('/view', 'view')->name('view');
        Route::post('/feedback', 'feedback')->name('feedback');
        Route::get('/report/{id}', 'report')->name('report');
        Route::get('/reportexcel/{id}', 'reportexcel')->name('reportexcel');
        Route::post('/checkcampaign', 'checkcampaign')->name('checkcampaign');
        Route::post('/checkCampaignName', 'checkCampaignName')->name('checkCampaignName');
        Route::post('/getCity', 'getCity')->name('getCity');
        Route::post('/get-balances', 'getBalances')->name('getBalances');

        /* Route::get('/sucseesleads', 'sucseesleads')->name('sucseesleads');
        Route::get('/sucseesleads/excel', 'sucseesleadsexcel')->name('sucseesleadsexcel'); */
    });

    Route::get('sucseesleads',[CampaignController::class, 'sucseesleads'])->name('sucseesleads'); 
    Route::get('sucseesleads/excel',[CampaignController::class, 'sucseesleadsexcel'])->name('sucseesleads.excel'); 

});