<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use App\Console\Commands\LoginCheck;
use App\Console\Commands\SyncVoicePrompts;
use App\Console\Commands\IVRTokenGenerate;
use App\Console\Commands\MonthlyRevenueTargetCheck;
use Illuminate\Support\Facades\Schedule;

// Artisan::command('inspire', function () {
//     $this->comment(Inspiring::quote());
// })->purpose('Display an inspiring quote')->hourly();

Schedule::command(LoginCheck::class)->everyFiveMinutes()->withoutOverlapping();
Schedule::command(SyncVoicePrompts::class)->everyFiveMinutes()->withoutOverlapping();
Schedule::command(IVRTokenGenerate::class)->everyFiveMinutes()->withoutOverlapping();
Schedule::command(CampaignCallMemberDebitStore::class)->dailyAt('01:00')->withoutOverlapping();
Schedule::command(MonthlyRevenueTargetCheck::class)->monthlyOn(1, '05:00')->withoutOverlapping();