<?php

use App\Http\Controllers\AdminAuth\CategoryController;
use App\Http\Controllers\AdminAuth\FirmController;
use App\Http\Controllers\AdminAuth\HomeController;
use App\Http\Controllers\AdminAuth\LoginRegisterController as AdminloginController;
use App\Http\Controllers\AdminAuth\PermissionController;
use App\Http\Controllers\AdminAuth\PurchaseController;
use App\Http\Controllers\AdminAuth\PurchaseGroupController;
use App\Http\Controllers\AdminAuth\RawMaterialController;
use App\Http\Controllers\AdminAuth\RoleController;
use App\Http\Controllers\AdminAuth\SitesettingController;
use App\Http\Controllers\AdminAuth\UserController;
use App\Http\Controllers\AdminAuth\VendorController;
use Illuminate\Support\Facades\Route;

// middle group

// Route::middleware('auth:admin')->group(function () {
Route::get('/password/email', [AdminloginController::class, 'pass_email'])->name('pass_email');
Route::post('/password/email', [AdminloginController::class, 'sendResetLink'])->name('password.email');
Route::get('password/reset/{token}', [AdminloginController::class, 'showResetForm'])->name('password.reset');
Route::post('password/reset', [AdminloginController::class, 'reset'])->name('password.update');

Route::group(['middleware' => ['is_admin']], function () {
    Route::any('logout', [AdminloginController::class, 'logout'])->name('logout');

    Route::get('sitesetting', [SitesettingController::class, 'sitesetting'])->name('sitesetting');
    Route::post('update', [SitesettingController::class, 'updatesitesetting'])->name('sitesetting.update');

    Route::get('dashboard', [HomeController::class, 'dashboard'])->name('dashboard');
    Route::get('visual-meeting', function () {
        return view('admin.visualmeeting');
    })->name('visual-meeting');

    Route::get('profile/edit', [HomeController::class, 'profile_edit'])->name('profile_edit');
    Route::post('profile/update', [HomeController::class, 'profile_update'])->name('profile_update');
    Route::get('setting', [HomeController::class, 'setting'])->name('setting');

    Route::get('category', [CategoryController::class, 'index'])->name('category.index');
    Route::post('category/create', [CategoryController::class, 'create'])->name('category.create');
    Route::post('category/store', [CategoryController::class, 'store'])->name('category.store');
    Route::post('category/edit', [CategoryController::class, 'edit'])->name('category.edit');
    Route::post('category/update', [CategoryController::class, 'update'])->name('category.update');
    Route::post('category/destroy', [CategoryController::class, 'destroy'])->name('category.destroy');
    Route::post('category/sequence_update', [CategoryController::class, 'sequence_update'])->name('category.sequence_update');

    Route::get('purchasegroup', [PurchaseGroupController::class, 'index'])->name('purchasegroup.index');
    Route::post('purchasegroup/create', [PurchaseGroupController::class, 'create'])->name('purchasegroup.create');
    Route::post('purchasegroup/store', [PurchaseGroupController::class, 'store'])->name('purchasegroup.store');
    Route::post('purchasegroup/edit', [PurchaseGroupController::class, 'edit'])->name('purchasegroup.edit');
    Route::post('purchasegroup/update', [PurchaseGroupController::class, 'update'])->name('purchasegroup.update');
    Route::post('purchasegroup/destroy', [PurchaseGroupController::class, 'destroy'])->name('purchasegroup.destroy');
    Route::post('purchasegroup/sequence_update', [PurchaseGroupController::class, 'sequence_update'])->name('purchasegroup.sequence_update');
    Route::get('/get-purchase-groups/{categoryId}', [PurchaseGroupController::class, 'getPurchaseGroups']);

    Route::resource('firms', FirmController::class);
    Route::post('/firms/{id}/toggle-status', [FirmController::class, 'toggleStatus'])->name('firms.toggle-status');

    Route::resource('vendor', VendorController::class);
    Route::resource('purchase', PurchaseController::class);

    // Route::resource('role', RoleController::class);
    // Route::resource('role', RoleController::class);
    Route::get('role', [RoleController::class, 'index'])->name('role.index');
    Route::post('role/create', [RoleController::class, 'create'])->name('role.create');
    Route::post('role/store', [RoleController::class, 'store'])->name('role.store');
    Route::post('role/edit', [RoleController::class, 'edit'])->name('role.edit');
    Route::post('role/update', [RoleController::class, 'update'])->name('role.update');
    Route::post('role/sequence_update', [RoleController::class, 'sequence_update'])->name('role.sequence_update');

    // Route::resource('permission', PermissionController::class);
    Route::get('permission', [PermissionController::class, 'index'])->name('permission.index');
    Route::post('permission/create', [PermissionController::class, 'create'])->name('permission.create');
    Route::post('permission/store', [PermissionController::class, 'store'])->name('permission.store');
    Route::post('permission/edit', [PermissionController::class, 'edit'])->name('permission.edit');
    Route::post('permission/update', [PermissionController::class, 'update'])->name('permission.update');
    Route::post('permission/sequence_update', [PermissionController::class, 'sequence_update'])->name('permission.sequence_update');

    Route::get('raw_materials', [RawMaterialController::class, 'index'])->name('raw_materials.index');
    Route::post('raw_materials/create', [RawMaterialController::class, 'create'])->name('raw_materials.create');
    Route::post('raw_materials', [RawMaterialController::class, 'store'])->name('raw_materials.store');
    Route::post('raw_materials/edit', [RawMaterialController::class, 'edit'])->name('raw_materials.edit');
    Route::put('raw_materials/{id}', [RawMaterialController::class, 'update'])->name('raw_materials.update');
    Route::delete('raw_materials/{id}', [RawMaterialController::class, 'destroy'])->name('raw_materials.destroy');

    // Route::resource('user', UserController::class);
    Route::get('user', [UserController::class, 'index'])->name('user.index');
    Route::post('transfer-employee', [UserController::class, 'transferEmployee']);
    Route::post('check-user-mobile', [UserController::class, 'checkUserMobile']);
    Route::post('/careercheckmobile', [UserController::class, 'careerCheckMobile'])->name('careercheckmobile');

    Route::get('createWebhook', [HomeController::class, 'createWebhook'])->name('createWebhook');
    Route::get('testpdf222', [HomeController::class, 'testpdf222'])->name('testpdf222');
});
