@extends('user.layout.app')
@php $sitesetting = \App\Models\Sitesetting::first(); @endphp
@section('meta')
<meta name="description" content="{{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
<meta name="author" content="{{$sitesetting->comp_name}}" />
<meta name="robots" content="index, follow" />
<link rel="canonical" href="{{url('/')}}" />
<meta property="og:title" content="{{$sitesetting->comp_name}} | Testimonials" />
<meta property="og:description" content="{{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta property="og:image" content="{{$sitesetting->image_url}}" />
<meta property="og:url" content="{{ url('/') }}" />
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="website" />
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{$sitesetting->comp_name}} | Testimonials" />
<meta name="twitter:description" content="{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta name="twitter:image" content="{{$sitesetting->image_url}}" />
<meta name="twitter:image:width" content="1200">
<meta name="twitter:image:height" content="675">
@endsection

@section('pagetitle')
<title>Testimonials | {{$sitesetting->web_title}} </title>
@endsection
@section('content')

<div class="page-header-section" style="background-image: url('{{ url('public/assets/user/images/contact-page-bg.jpg') }}');">
    <div class="container">
        <div class="row">
            <div class="col-xl-6 col-lg-8">
                <div class="page-header-heading animate fadeInLeft wow" data-wow-duration="2000ms">
                    <h2>Marvelous Members</h2>
                    <p class="lead">In The Era Of Throat-Cut Competition Our Members Have Boosted Up Their Businesses With Our Assistance. </p>
                </div>
            </div>
        </div>
        <nav aria-label="breadcrumb">
            <ul class="breadcrumb">
                <li>
                    <a href="{{url('/')}}">Home</a>
                </li>
                <li>
                    <img src="{{url('public/assets/user')}}/images/arrow-brudcrumb.svg" alt="icon">
                </li>
                <li>
                    <span>Members Corner</span>
                </li>
            </ul>
        </nav>
    </div>
</div>

 <!-- Testimonials one start -->
 <div class="testimonial-page-section">
        <div class="container">
            <div class="row gutter-x-15 gutter-y-30">
                @foreach($testimonial as $tes)
                <div class="col-lg-6">
                    <div class="testimonial-box animate fadeInUp wow animated" data-wow-duration="1500ms" data-wow-delay="200ms">
                        <span class="testimonial-icon">
                            <img src="{{url('public/assets/user')}}/images/testimonial-detail-qute.png"  alt="icon">
                        </span>
                        <div class="testimonial-heading">
                            <img src="{{$tes->image_url}}" style="width:109px;height:109px;" alt="testimonial-image">
                            <div class="testimonial-title">
                                <h4>{{$tes->name}}</h4>
                               
                            </div>
                        </div>
                        <div class="testimonial-body">
                            <p>{!! $tes->short_description !!}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- Testimonials one end -->
    <!-- cta  two start -->
    <div class="cta-section-three">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-10 m-auto">
                    <div class="heading-box text-center">
                        <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms"
                            data-wow-delay="200ms">Get free Marketing Ideas…</h2>
                    </div>
                    <a href="{{url('contact')}}" class="btn btn-primary btn-theme animate fadeInUp wow"
                        data-wow-duration="1500ms" data-wow-delay="400ms">Get Started +</a>
                </div>
            </div>
        </div>
    </div>
    <!-- cta  two end -->

@endsection