@extends('user.layout.app')
@php $sitesetting = \App\Models\Sitesetting::first(); @endphp
@section('meta')
<meta name="description" content="{{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
<meta name="author" content="{{$sitesetting->comp_name}}" />
<meta name="robots" content="index, follow" />
<link rel="canonical" href="{{url('/')}}" />
<meta property="og:title" content="{{$sitesetting->comp_name}} | Service" />
<meta property="og:description" content="{{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta property="og:image" content="{{$sitesetting->image_url}}" />
<meta property="og:url" content="{{ url('/') }}" />
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="website" />
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{$sitesetting->comp_name}} | Service" />
<meta name="twitter:description" content="{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta name="twitter:image" content="{{$sitesetting->image_url}}" />
<meta name="twitter:image:width" content="1200">
<meta name="twitter:image:height" content="675">
@endsection

@section('pagetitle')
<title>Service | {{$sitesetting->web_title}} </title>
@endsection
@section('content')


<!-- page header start -->
<div class="page-header-section" style="background-image: url(('public/assets/user')}}/images/service-page-bg.jpg);">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-8">
                    <div class="page-header-heading animate fadeInLeft wow" data-wow-duration="2000ms">
                        <h2>Services</h2>
                        <p class="lead">We Are Changing Scenario Of Marketing- Be With Us.</p>
                    </div>
                </div>
            </div>
            <ul class="breadcrumb">
                <li>
                    <a href="{{url('/')}}">Home</a>
                </li>
                <li>
                    <img src="{{url('public/assets/user')}}/images/arrow-brudcrumb.svg" alt="icon">
                </li>
                <li>
                    <span>Services</span>
                </li>
            </ul>
        </div>
    </div>
    <!-- page header start -->
    <!-- service two start -->
    <div class="service-section-two srvice">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 m-auto">
                    <div class="heading-box text-center">
                        <span class="sub-title animate fadeInUp wow" data-wow-duration="1500ms">Services</span>
                        <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms"
                            data-wow-delay="200ms">We are building great future together Be with us</h2>
                    </div>
                </div>
            </div>
            <div class="row gutter-y-30">
            @foreach($service as $ser)
                <div class="col-lg-4 col-md-6">
                    <div class="service-box-two animate fadeInUp wow" data-wow-duration="1500ms">
                    <a href="{{url('servicedetail/'.$ser->slug)}}">
                        <div class="service-image-two">
                            <img src="{{$ser->image_url}}" alt="service-image">
                          
                        </div>
                        </a>
                        <div class="service-details-two">
                            <h4><a href="{{url('servicedetail/'.$ser->slug)}}">{{$ser->name}}</a></h4>
                            <p>{{$ser->short_description}}</p>
                        </div>
                    </div>
                </div>
                @endforeach 
            </div>
        </div>
    </div>
    <!-- service two end -->
    <!-- cta  two start -->
    <div class="cta-section-three">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-10 m-auto">
                    <div class="heading-box text-center">
                        <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms"
                            data-wow-delay="200ms">Get free Marketing Ideas…</h2>
                    </div>
                    <a href="{{url('contact')}}" class="btn btn-primary btn-theme animate fadeInUp wow"
                        data-wow-duration="1500ms" data-wow-delay="400ms">Get Started +</a>
                </div>
            </div>
        </div>
    </div>
    <!-- cta  two end -->

@endsection