@extends('user.layout.app')
@php $sitesetting = \App\Models\Sitesetting::first(); @endphp
@section('meta')
<meta name="description" content="{{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
<meta name="author" content="{{$sitesetting->comp_name}}" />
<meta name="robots" content="index, follow" />
<link rel="canonical" href="{{url('/')}}" />
<meta property="og:title" content="{{$sitesetting->comp_name}} | Service Detail" />
<meta property="og:description" content="{{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta property="og:image" content="{{$sitesetting->image_url}}" />
<meta property="og:url" content="{{ url('/') }}" />
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="website" />
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{$sitesetting->comp_name}} | Service Detail" />
<meta name="twitter:description" content="{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta name="twitter:image" content="{{$sitesetting->image_url}}" />
<meta name="twitter:image:width" content="1200">
<meta name="twitter:image:height" content="675">
@endsection

@section('pagetitle')
<title>Service Details | {{$sitesetting->web_title}} </title>
@endsection
@section('content')
    <!-- page header start -->
    <div class="page-header-section" style="background-image: url('{{ asset('assets/user/images/service-page-bg.jpg') }}');">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-8">
                    <div class="page-header-heading animate fadeInLeft wow" data-wow-duration="2000ms">
                        <h2>Services</h2>
                       
                    </div>
                </div>
            </div>
            <ul class="breadcrumb">
                <li>
                    <a href="{{url('/')}}">Home</a>
                </li>
                <li>
                    <img src="{{url('public/assets/user')}}/images/arrow-brudcrumb.svg" alt="icon">
                </li>
                <li>
                    <span>{{$service->name}}</span>
                </li>
            </ul>
        </div>
    </div>
    <!-- page header start -->
    <!-- service details start -->
    <div class="service-details-section">
        <div class="container">
            <div class="row gutter-x-15 gutter-y-30">
                <div class="col-lg-12">
                    <div class="service-details-block animate fadeInLeft wow" data-wow-duration="1500ms" data-wow-delay="200ms">
                        <h4>{{$service->name}}</h4>
                        
                    </div>
                    
                    <div class="service-details-block animate fadeInLeft wow" data-wow-duration="1500ms" data-wow-delay="1000ms">
                        <div class="service-details-tag-inner">
                            <div class="service-details-tag">
                                <span><img src="{{$service->image_url}}" alt="icon"></span>
                                <p class="mb-0">{!! $service->short_description !!}</p>
                            </div>
                            
                        </div>
                    </div>
                    
                   
                   
                   
                </div>
                
            </div>
        </div>
    </div>
    <!-- service details end -->
    <!-- cta  two start -->
    
    <!-- cta  two end -->


@endsection