@extends('user.layout.app')
@section('meta')
    <meta name="description" content="{{strip_tags($sitesetting->comp_name)}}" />
    <meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
    <meta name="author" content="{{$sitesetting->comp_name}}" />
    <meta name="robots" content="index, follow" />
    <link rel="canonical" href="{{url('/')}}" />
    <meta property="og:title" content="{{$sitesetting->comp_name}} | Privacy-Policy" />
    <meta property="og:description" content="{{strip_tags($sitesetting->comp_name)}}" />
    <meta property="og:image" content="{{$sitesetting->image_url}}" />
    <meta property="og:url" content="{{ url('/') }}" />
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:type" content="website" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="{{$sitesetting->comp_name}} | Privacy-Policy" />
    <meta name="twitter:description" content="{{strip_tags($sitesetting->comp_name)}}" />
    <meta name="twitter:image" content="{{$sitesetting->image_url}}" />
    <meta name="twitter:image:width" content="1200">
    <meta name="twitter:image:height" content="675">
@endsection

@section('pagetitle')
    <title>Privacy-Policy | {{$sitesetting->web_title}} </title>
@endsection
@section('content')
<div class="page-header-section privacy-policy" >
    <div class="container">
        <div class="row">
            <div class="col-xl-6 col-lg-8">
                <div class="page-header-heading animate fadeInLeft wow" data-wow-duration="2000ms">
                    <h2>Privacy Policy</h2>
                </div>
            </div>
        </div>
        <ul class="breadcrumb">
            <li>
                <a href="{{url('/')}}">Home</a>
            </li>
            <li>
                <img src="{{url('public/assets/user')}}/images/arrow-brudcrumb.svg" alt="icon">
            </li>
            <li>
                <span>Privacy Policy</span>
            </li>
        </ul>
    </div>
</div>
<div class="container my-3">
    <div class="privacy-policy">
        {!!$condition->m_privacy_policy!!}
    </div>
</div>
@endsection