<!DOCTYPE html>
<html lang="en">
    <head>
    @php 
            $sitesetting = \App\Models\Sitesetting::first();
    @endphp
        <title>Singi Marketing | Reset Password</title>
        <base href="{{url('/')}}" />
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="author" content="Singi Marketing">
        <link rel="shortcut icon" href="{{(!empty($sitesetting) && !empty('$sitesetting->fevicon'))?url('/'.$sitesetting->fevicon):''}}" type="image/x-icon"> 
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&family=Marcellus&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="{{url('public/assets/user')}}/css/bootstrap.min.css">
        <link href="{{ url('assets/admin') }}/css/icons.css" rel="stylesheet">
        <link href="{{ url('assets/admin') }}/css/style.css" rel="stylesheet">	
        <link rel="stylesheet" href="{{url('public/assets/user')}}/css/reset-password.css">
    </head>
    <body class="ltr error-page1 main-body bg_light text-dark error-3">

    <div id="global-loader" style="display: none;">
        <div class="loader-img">
            <i class="fas fa-spinner fa-spin" style="font-size: 30px; color: white;"></i>
        </div>
    </div>

    <div class="page">
        <!-- Reset Password Form -->
        <div class="form-container">
            <div class="glass-card">
                <div class="form-header">
                    <div class="reset-icon">
                        <img src="{{$sitesetting->image_url}}" alt="Logo">
                    </div>
                    <h2>
                        <i class="fas fa-lock-open"></i>
                        Reset Password
                    </h2>
                    <p>Enter your email address and we'll send you a link to reset your password</p>
                </div>

                <!-- Success Message -->
                @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif

                <form class="reset-form" method="POST"action="{{ route('password.email') }}">
                    {{ csrf_field() }}
                    
                    <div class="form-group">
                        <label for="email">{{ __('Email Address') }}</label> 
                        <div class="input-container">
                            <i class="input-icon fas fa-envelope"></i>
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" placeholder="Enter your email" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                        </div>
                        @error('email')
                            <span class="help-block">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <button type="submit" class="btn-primary"><i class="fas fa-paper-plane"></i> {{ __('Send Password Reset Link') }}</button>
                </form>

                <!-- Back to Login -->
                <div style="text-align: center; margin-top: 25px;">
                    <a href="{{ url('secure-dashboard/login') }}" style="color: rgba(255, 255, 255, 0.8); text-decoration: none; font-size: 14px; transition: color 0.3s ease;">
                        <i class="fas fa-arrow-left"></i>
                        Back to Login
                    </a>
                </div>
            </div>
        </div>

        <!-- Video Section -->
        @php
            $videoId = null;
            if (!empty($sitesetting->youtube_link)) {
                $url = $sitesetting->youtube_link;
                if (strpos($url, 'youtu.be/') !== false) {
                    $videoId = \Illuminate\Support\Str::after($url, 'youtu.be/');
                    $videoId = strtok($videoId, '?'); // Agar ?si=... ho to cut kar dega
                }
                elseif (strpos($url, 'v=') !== false) {
                    $videoId = \Illuminate\Support\Str::after($url, 'v=');
                    $videoId = strtok($videoId, '&'); // Agar aur params ho to remove
                }
            }
        @endphp
        @if(!empty($videoId))
        <div class="video-container">
            <div class="video-header">
                <h4>
                    <i class="fas fa-play-circle"></i>
                    {{ $sitesetting->youtube_title }}
                </h4>
            </div>
            <div class="video-wrapper">
                <!-- Demo YouTube Video - Replace with your dynamic content -->
                <iframe
                    src="https://www.youtube.com/embed/{{ $videoId }}"
                    allowfullscreen>
                </iframe>
            </div>
        </div>
        @endif
    </div>
        {{-- <div class="container">
            <div class="row justify-content-center" >
                <div class="col-12">
                    <div class="logo-container">
                        <img src="{{(!empty($sitesetting) && !empty($sitesetting->image))?$sitesetting->image_url:''}}" style="width:90px;height:90px;" alt="header-logo">
                    </div>
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    <form class="reset_password_form" method="POST"action="{{ route('password.email') }}">
                    @csrf
                        <h2 class="form-title">{{ __('Reset Password') }}</h2>
                        
                        <div class="form-floating mb-4">
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                            <label for="email">{{ __('Email Address') }}</label>
                        </div>
                        @error('email')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-lg submit-btn"> {{ __('Send Password Reset Link') }}</button>
                        </div>
                    </form>
                </div>
                @php
                    $videoId = null;
                    if (!empty($sitesetting->youtube_link)) {
                        $url = $sitesetting->youtube_link;
                        if (strpos($url, 'youtu.be/') !== false) {
                            $videoId = \Illuminate\Support\Str::after($url, 'youtu.be/');
                            $videoId = strtok($videoId, '?'); // Agar ?si=... ho to cut kar dega
                        }
                        elseif (strpos($url, 'v=') !== false) {
                            $videoId = \Illuminate\Support\Str::after($url, 'v=');
                            $videoId = strtok($videoId, '&'); // Agar aur params ho to remove
                        }
                    }
                @endphp
                @if(!empty($videoId))
                <div class="video_container my-4">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="mb-3 text-center text-dark">{{ $sitesetting->youtube_title }}</h4>
                        </div>
                        <div class="">
                            <iframe class="embed-responsive-item"
                                height="200"
                                width="100%"
                                src="https://www.youtube.com/embed/{{ $videoId }}"
                                allowfullscreen>
                            </iframe>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div> --}}
        <script>
        document.getElementById('global-loader').style.display = 'flex';
        
        window.addEventListener('load', function() {
            setTimeout(() => {
                document.getElementById('global-loader').style.display = 'none';
            }, 1000);
        });
        
        document.querySelectorAll('.form-control').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'scale(1.02)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'scale(1)';
            });
        });

    </script>
    </body>
</html>
