@extends('user.layout.app')
@php $sitesetting = \App\Models\Sitesetting::first(); @endphp
@section('meta')
<meta name="description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
<meta name="author" content="{{$sitesetting->comp_name}}" />
<meta name="robots" content="index, follow" />
<link rel="canonical" href="{{url('/')}}" />
<meta property="og:title" content="{{$sitesetting->comp_name}} | Member Grid" />
<meta property="og:description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta property="og:image" content="{{$sitesetting->image_url}}" />
<meta property="og:url" content="{{ url('/') }}" />
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="website" />
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{$sitesetting->comp_name}} | Member Grid" />
<meta name="twitter:description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta name="twitter:image" content="{{$sitesetting->image_url}}" />
<meta name="twitter:image:width" content="1200">
<meta name="twitter:image:height" content="675">
@endsection

@section('pagetitle')
<title>Member Grid | {{$sitesetting->web_title}} </title>
@endsection
@section('content')
<div class="page-header-section" style="background-image: url('{{ url('public/assets/user/images/contact-page-bg.jpg') }}');">
    <div class="container">
        <div class="row">
            <div class="col-xl-6 col-lg-8">
                <div class="page-header-heading animate fadeInLeft wow" data-wow-duration="2000ms">
                    <h2>Member Grid</h2>
                </div>
            </div>
        </div>
        <ul class="breadcrumb">
            <li>
                <a href="{{url('/')}}">Home</a>
            </li>
            <li>
                <img src="{{url('public/assets/user')}}/images/arrow-brudcrumb.svg" alt="icon">
            </li>
            <li>
                <span>Member Grid</span>
            </li>
        </ul>
    </div>
</div>

<div class="video_section">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="video">
                    <video src="{{url('public/assets/user')}}/video/singi_video_1.mp4" controls autoplay ></video>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection
