@php 
   $sitesetting = \App\Models\Sitesetting::first();
   @endphp

<header class="main-header">
    <div class="container-fluid">
        <nav class="main-menu">
            <div class="main-menu-logo">
                <a href="{{url('/')}}">
                    <img src="{{(!empty($sitesetting) && !empty($sitesetting->image))?$sitesetting->image_url:''}}" class="sidemenu-comp-logo" alt="header-logo">
                </a>
            </div>
            <div class="main-menu-inner">
                <ul class="main-menu-list">
                    <li class="menu-item-children {{ Request::is('/') ? 'active' : '' }}">
                        <a href="{{ url('/') }}">Home</a>
                    </li>
                
                    <li class="menu-item-children {{ Request::is('testimonial') ? 'active' : '' }}">
                        <a href="{{ url('testimonial') }}">Member’s Corner</a>
                    </li>
                
                    <li class="menu-item-children {{ Request::is('service') ? 'active' : '' }}">
                        <a href="{{ url('service') }}">Services</a>
                    </li>
                
                    <li class="menu-item-children {{ Request::is('terms-and-conditions') ? 'active' : '' }}">
                        <a href="{{ url('terms-and-conditions') }}">Terms & Conditions</a>
                    </li>
                
                    <li class="menu-item-children {{ Request::is('privacy-policy') ? 'active' : '' }}">
                        <a href="{{ url('privacy-policy') }}">Privacy Policy</a>
                    </li>
                
                    <li class="menu-item-children {{ Request::is('contact') ? 'active' : '' }}">
                        <a href="{{ url('contact') }}">Contact Us</a>
                    </li>
                
                    <li class="menu-item-children {{ Request::is('about') ? 'active' : '' }}">
                        <a href="{{ url('about') }}">About</a>
                    </li>
                
                    <li class="menu-item-children {{ Request::is('download') ? 'active' : '' }}">
                        <a href="{{ url('download') }}">Downloads</a>
                    </li>
                </ul>
                
                <div class="main-menu-right">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#employeeregistration" class="btn btn-light btn-theme">Career</a>
                    <div class="header-side-menu">
                        <span class="line-1"></span>
                        <span class="line-2"></span>
                    </div>
                    <button class="btn btn-light btn-theme d-xl-none" onclick="toggleSidebar()">Login</button>
                </div>
                <div class="header-menu-collaps">
                    <span class="line-1"></span>
                    <span class="line-2"></span>
                    <span class="line-3"></span>
                </div>
            </div>
        </nav>
    </div>
</header>

<div id="mobileSidebar">
    <button class="close-btn" onclick="toggleSidebar()">&times;</button>
    <div class="side-menu-logo-box text-center mb-2">
        <a href="{{url('/')}}"><img src="{{(!empty($sitesetting) && !empty($sitesetting->image))?$sitesetting->image_url:''}}" class="sidemenu-comp-logo" alt="logo"></a>
    </div>
    <div class="mt-3 mb-3">
        <p>{{$sitesetting->comp_name}} - Business Consulting WordPress Theme for professionals, services, and solutions.</p>
        @if(session('danger'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('danger') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif
    </div>
    <form action="{{route('memberlogin')}}" method="post">
        {{csrf_field()}}
        
        <div class="mb-3">
            <label class="form-label w-100 text-start text-dark">Mobile Number <span class="text-danger">*</span></label>
            <input type="text" name="mobile" placeholder="Enter Your Mobile Number" value="{{old('mobile')}}" autocomplete="one-time-code" class="form-control" required>
            @if($errors->has('mobile'))
            <div class="text-danger">
            {{ $errors->first('mobile') }}
            </div>
            @endif
        </div>
        <div class="mb-3">
            <label class="form-label w-100 text-start text-dark">Password <span class="text-danger">*</span></label>
            <input type="password" placeholder="Enter Your Password" name="password" value="{{old('password')}}" autocomplete="one-time-code" class="form-control" required>
            @if($errors->has('password'))
            <div class="text-danger">
            {{ $errors->first('password') }}
            </div>
            @endif
        </div>

        <div class="buttons">
            <button type="submit" class="btn btn-theme btn-secondary w-100 mb-3">Login</button>
            <a href="#" data-bs-toggle="modal" data-bs-target="#memberRegistrationModal" class="btn btn-primary btn-theme w-100">Member Registration</a>
        </div>
        <div class="text-center mt-2">
            <a href="{{url('password/email')}}" class="account__login--forgot" type="button">
                Forgot Your Password?
            </a>
        </div>
    </form>
</div>

<script>
    
function previewImage(input, previewId) {
  const file = input.files[0];
  if (file) {
    const reader = new FileReader();
    reader.onload = function(e) {
      document.getElementById(previewId).src = e.target.result;
      document.getElementById(previewId).style.display = 'block';
    }
    reader.readAsDataURL(file);
  }
}
</script>