@extends('user.layout.app')
@php $sitesetting = \App\Models\Sitesetting::first(); @endphp
@section('meta')
<meta name="description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
<meta name="author" content="{{$sitesetting->comp_name}}" />
<meta name="robots" content="index, follow" />
<link rel="canonical" href="{{url('/')}}" />
<meta property="og:title" content="{{$sitesetting->comp_name}} | Download" />
<meta property="og:description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta property="og:image" content="{{$sitesetting->image_url}}" />
<meta property="og:url" content="{{ url('/') }}" />
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="website" />
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{$sitesetting->comp_name}} | Download" />
<meta name="twitter:description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta name="twitter:image" content="{{$sitesetting->image_url}}" />
<meta name="twitter:image:width" content="1200">
<meta name="twitter:image:height" content="675">
@endsection

@section('pagetitle')
<title>Downloads | {{$sitesetting->web_title}} </title>
@endsection
@section('content')
    <div class="page-header-section">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-8">
                    <div class="page-header-heading animate fadeInLeft wow" data-wow-duration="2000ms">
                        <h2>Downloads</h2>
                        <p class="lead">We Provide User Friendly Platform For Our Members To Promote Their Product To Next Level. We Endeavour At Every Stage To Satisfy Sur Members.</p>
                    </div>
                </div>
            </div>
            <ul class="breadcrumb">
                <li>
                    <a href="{{url('/')}}">Home</a>
                </li>
                <li>
                    <img src="{{url('public/assets/user')}}/images/arrow-brudcrumb.svg" alt="icon">
                </li>
                <li>
                    <span>Download</span>
                </li>
            </ul>
        </div>
    </div>


    <div class="container py-3">
        <div>
            <div class="section-title text-center mb-50">
                <h2> Downloads</h2>
            </div>
        </div>
        <div class="row">
            @foreach($download as $down)
                <!-- Repeat this column 15 times -->
                <div class="col-12 col-md-6 col-lg-4 mb-4" data-aos="fade-up">
                    <div class="card custom-card">
                        <div class="card-body">
                            <h5 class="card-title">{{$down->name}}</h5>
                            <a  href="{{$down->image_url}}" target="_blank" download class="btn download-btn">Download</a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        {{$download->links()}}
        
    </div>

@endsection