@extends('user.layout.app')
@php $sitesetting = \App\Models\Sitesetting::first(); @endphp
@section('meta')
<meta name="description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
<meta name="author" content="{{$sitesetting->comp_name}}" />
<meta name="robots" content="index, follow" />
<link rel="canonical" href="{{url('/')}}" />
<meta property="og:title" content="{{$sitesetting->comp_name}} | Contact" />
<meta property="og:description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta property="og:image" content="{{$sitesetting->image_url}}" />
<meta property="og:url" content="{{ url('/') }}" />
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="website" />
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{$sitesetting->comp_name}} | Contact" />
<meta name="twitter:description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta name="twitter:image" content="{{$sitesetting->image_url}}" />
<meta name="twitter:image:width" content="1200">
<meta name="twitter:image:height" content="675">
@endsection

@section('pagetitle')
<title>Contact | {{$sitesetting->web_title}} </title>
@endsection
@section('content')
<!-- page header start -->
    <div class="page-header-section" style="background-image: url('{{ url('public/assets/user/images/contact-page-bg.jpg') }}');">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-8">
                    <div class="page-header-heading animate fadeInLeft wow" data-wow-duration="2000ms">
                        <h2>Contact Us</h2>
                        <p class="lead">We Are Committed To Provide Technical Support To Our Memebers Aat Any Point Of Time.  </p>
                    </div>
                </div>
            </div>
            <ul class="breadcrumb">
                <li>
                    <a href="{{url('/')}}">Home</a>
                </li>
                <li>
                    <img src="{{url('public/assets/user')}}/images/arrow-brudcrumb.svg" alt="icon">
                </li>
                <li>
                    <span>Contact Us</span>
                </li>
            </ul>
        </div>
    </div>
    <!-- page header start -->
    <!-- contact  start -->
    <div class="contact-section">
        <div class="container">
            <div class="row">
                <div class="col-xl-5 col-lg-6">
                    <div class="contact-info animate fadeInLeft wow" data-wow-duration="1500ms" data-wow-delay="200ms">
                        <div class="heading-box">
                            <span class="sub-title animate fadeInUp wow" data-wow-duration="1500ms">Contact</span>
                            <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms"
                                data-wow-delay="200ms">Singi Marketing</h2>
                        </div>
                        <ul>
                            <li>
                                <img src="{{url('public/assets/user')}}/images/addres-icon-2.svg" alt="icon">
                                <div class="contact-title">
                                    <h6>Address Business</h6>
                                    <p>{!! $sitesetting->comp_address !!} </p>
                                </div>
                            </li>
                            <li>
                                <img src="{{url('public/assets/user')}}/images/mail-icon-2.svg" alt="icon">
                                <div class="contact-title">
                                    <h6>Email Address</h6>
                                    <a href="mailto:{{$sitesetting->comp_email}}" target="_blank">{{$sitesetting->comp_email}}</a>
                                 
                                </div>
                            </li>
                            <li>
                                <img src="{{url('public/assets/user')}}/images/call-icon-2.svg" alt="icon">
                                <div class="contact-title">
                                    <h6>Phone Number</h6>
                                    <a href="tel:{{$sitesetting->comp_phone}}" target="_blank">Call Consulting: {{$sitesetting->comp_phone}}</a>
                                   
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-7 col-lg-6">
               
                             
                            
                   
                        @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong>Success!</strong> {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        @endif
                        
                    <div class="contact-form animate fadeInRight wow" data-wow-duration="1500ms" data-wow-delay="200ms">
                    <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms"
                                data-wow-delay="200ms">Write to us
                                </h2>
                   
                        <form action="{{url('inquirysave')}}" method="post">
                        {{csrf_field()}}
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="form-group mb-0 position-relative">
                                    <input type="text" name="name" class="form-control mb-0" value="{{old('name')}}" placeholder="Name">
                                      <span class="text-danger position-absolute star-icon-contact">*</span>    
                                </div>
                                 @error('name')
                                      <div class="text-danger">{{ $message }}</div>
                                 @enderror
                            </div>     
                            <div class="col-md-6 mb-3">
                                <div class="form-group mb-0 position-relative">
                                    <input type="number" name="mobile" class="form-control mb-0" value="{{old('mobile')}}" placeholder="Phone number">
                                      <span class="text-danger position-absolute star-icon-contact">*</span>
                                   
                                </div>
                                 @error('mobile')
                                      <div class="text-danger">{{ $message }}</div>
                                    @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-group mb-0 position-relative">
                                    <input type="email" name="email" class="form-control mb-0" value="{{old('email')}}" placeholder="Email">
                                      <span class="text-danger position-absolute star-icon-contact">*</span>
                                  
                                </div>
                                  @error('email')
                                      <div class="text-danger">{{ $message }}</div>
                                    @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-group mb-0 position-relative">
                                  <input type="text" name="subject" class="form-control mb-0" value="{{old('subject')}}" placeholder="what are you needs ">
                                    <span class="text-danger position-absolute star-icon-contact">*</span>
                                  
                                </div>
                                 @error('subject')
                                      <div class="text-danger">{{ $message }}</div>
                                    @enderror
                            </div>
                            <div class="col-md-6 mb-3">
                                <div class="form-group mb-0 position-relative">
                                    <textarea name="description" class="form-control mb-0" placeholder="Message" rows="4">{{old('description')}}</textarea>
                                      <span class="text-danger position-absolute star-icon-contact">*</span>
                                    
                                </div>
                                 @error('description')
                                      <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <button type="submit" class="btn btn-secondary btn-theme">Send</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
  
    {{-- <div class="map-section">
        <div class="container-fluid p-0">
            <div class="map"></div>
        </div>
    </div> --}}
    
@endsection