@extends('user.layout.app')
@php $sitesetting = \App\Models\Sitesetting::first(); @endphp
@section('meta')
<meta name="description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
<meta name="author" content="{{$sitesetting->comp_name}}" />
<meta name="robots" content="index, follow" />
<link rel="canonical" href="{{url('/')}}" />
<meta property="og:title" content="{{$sitesetting->comp_name}} | Branding Partner" />
<meta property="og:description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta property="og:image" content="{{$sitesetting->image_url}}" />
<meta property="og:url" content="{{ url('/') }}" />
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="website" />
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{$sitesetting->comp_name}} | Branding Partner" />
<meta name="twitter:description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta name="twitter:image" content="{{$sitesetting->image_url}}" />
<meta name="twitter:image:width" content="1200">
<meta name="twitter:image:height" content="675">
@endsection

@section('pagetitle')
<title>Branding Partner | {{$sitesetting->comp_name}}</title>
@endsection
@section('content')


    <div class="page-header-section" style="background-image: url('{{ url('public/assets/user/images/contact-page-bg.jpg') }}');">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-8">
                    <div class="page-header-heading animate fadeInLeft wow" data-wow-duration="2000ms">
                        <h2>Branding Partner</h2>
                        <p class="lead">We Are Committed To Provide Technical Support To Our Memebers Aat Any Point Of Time.  </p>
                    </div>
                </div>
            </div>
            <ul class="breadcrumb">
                <li>
                    <a href="{{url('/')}}">Home</a>
                </li>
                <li>
                    <img src="{{url('public/assets/user')}}/images/arrow-brudcrumb.svg" alt="icon">
                </li>
                <li>
                    <span>Branding Partner</span>
                </li>
            </ul>
        </div>
    </div>

    <div class="branding_partner_container">
        <div class="branding_partner_header">
            <h1 class="branding_partner_title">Our Brand Partners</h1>
            <p class="branding_partner_subtitle">Trusted by industry leaders worldwide. Together, we're building the future of innovation and excellence.</p>
        </div>

        <div class="branding_partner_grid">
            <div class="branding_partner_card">
                <div class="branding_partner_logo">TN</div>
                <h3 class="branding_partner_name">TechNova</h3>
            </div>

            <div class="branding_partner_card">
                <div class="branding_partner_logo">QS</div>
                <h3 class="branding_partner_name">QuantumSoft</h3>
            </div>

            <div class="branding_partner_card">
                <div class="branding_partner_logo">AP</div>
                <h3 class="branding_partner_name">ApexPro</h3>
            </div>

            <div class="branding_partner_card">
                <div class="branding_partner_logo">DS</div>
                <h3 class="branding_partner_name">DataSphere</h3>
            </div>

            <div class="branding_partner_card">
                <div class="branding_partner_logo">CW</div>
                <h3 class="branding_partner_name">CloudWave</h3>
            </div>

            <div class="branding_partner_card">
                <div class="branding_partner_logo">NX</div>
                <h3 class="branding_partner_name">NexusCore</h3>
            </div>

            <div class="branding_partner_card">
                <div class="branding_partner_logo">VT</div>
                <h3 class="branding_partner_name">VelocityTech</h3>
            </div>

            <div class="branding_partner_card">
                <div class="branding_partner_logo">IF</div>
                <h3 class="branding_partner_name">InnovateFlex</h3>
            </div>
        </div>
    </div>


@endsection
