@extends('user.layout.app')
@php $sitesetting = \App\Models\Sitesetting::first(); @endphp
@section('meta')
<meta name="description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
<meta name="author" content="{{$sitesetting->comp_name}}" />
<meta name="robots" content="index, follow" />
<link rel="canonical" href="{{url('/')}}" />
<meta property="og:title" content="{{$sitesetting->comp_name}} | About" />
<meta property="og:description" content="{{strip_tags($sitesetting->comp_name)}}" />
<meta property="og:image" content="{{$sitesetting->image_url}}" />
<meta property="og:url" content="{{ url('/') }}" />
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="website" />
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{$sitesetting->comp_name}} | About" />
<meta name="twitter:description" content="{substr(strip_tags($sitesetting->comp_name),0,150)}}" />
<meta name="twitter:image" content="{{$sitesetting->image_url}}" />
<meta name="twitter:image:width" content="1200">
<meta name="twitter:image:height" content="675">
@endsection

@section('pagetitle')
<title>About | {{$sitesetting->web_title}} </title>
@endsection
@section('content')

<!-- page header start -->
    <div class="page-header-section">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-8">
                    <div class="page-header-heading animate fadeInLeft wow" data-wow-duration="2000ms">
                        <h2>We Are A Renowned Marketing Company Committed  To Strengthen Businesses And Services Across India.</h2>
                        <p class="lead">We Help Our Clients To Overcome Critical Challenges Of Marketing And Find New Opportunities For Their Businesses Or Services.</p>
                    </div>
                </div>
            </div>
            <ul class="breadcrumb">
                <li>
                    <a href="index.html">Home</a>
                </li>
                <li>
                    <img src="{{url('public/assets/user')}}/images/arrow-brudcrumb.svg" alt="icon">
                </li>
                <li>
                    <span>About us</span>
                </li>
            </ul>
        </div>
    </div>
    <div class="about-lower">
        <div class="container-fluid">
            <div class="row banner-box-outer-five">
                <div class="col-lg-4 col-md-6">
                    <div class="banner-box-five">
                        <div class="banner-box-icon-five">
                        <img src="{{(!empty($about) && !empty($about->image1))?url('/'.$about->image1):''}}" alt="About Image 1">
                        </div>
                        <div class="banner-box-details-five">
                            <h4>{{$about->about1_title}}</h4>
                            <p class="lead">{!! $about->about_description1 !!} </p>
                            
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="banner-box-five">
                        <div class="banner-box-icon-five">
                            <img src="{{(!empty($about) && !empty($about->image2))?url('/'.$about->image2):''}}" alt="About Image 2">
                        </div>
                        <div class="banner-box-details-five">
                            <h4>{{$about->about2_title}}</h4>
                            <p class="lead">{!! $about->about_description2 !!} </p>
                           
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="banner-box-five">
                        <div class="banner-box-icon-five">
                        <img src="{{(!empty($about) && !empty($about->image3))?url('/'.$about->image3):''}}" alt="About Image 3">
                        </div>
                        <div class="banner-box-details-five">
                            <h4>{{$about->about3_title}}</h4>
                            <p class="lead">{!! $about->about_description3 !!}</p>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- page header start -->
    <!-- about one start -->
    <div class="about-section-one">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-8">
                    <div class="about-left-one">
                        <img src="{{url('/'.$sitesetting->about_image)}}"  alt="About Image">
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="about-right-one">
                        <div class="heading-box">
                            <span class="sub-title animate fadeInUp wow" data-wow-duration="1500ms">About Us</span>
                            <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms" data-wow-delay="200ms">{{$sitesetting->about_title}}</span></h2>
                        </div>
                        <div class="about-details-one animate fadeInUp wow" data-wow-duration="1500ms" data-wow-delay="300ms">
                            <p class="lead">{!! $sitesetting->about_desc !!}</p>
                           
                            
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- about one end -->
    <!-- why-choose two start -->
    <div class="why-choose-section-two about-why-choose">
        <div class="container">
            <div class="why-choose-image-two">
                <img src="{{url('public/assets/user')}}/images/why-choose-two-1.png" alt="why-choose" class="animate zoomIn wow" data-wow-duration="2500ms">
            </div>
            <div class="row">
                <div class="col-lg-6 m-auto">
                    <div class="heading-box light text-center">
                        <span class="sub-title animate fadeInUp wow" data-wow-duration="1500ms">Why choose  Us</span>
                        <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms" data-wow-delay="200ms">{{$about->main_title}}</h2>
                    </div>
                </div>
            </div>
            <div class="row justify-content-between">
                <div class="col-lg-4">
                    <div class="why-choose-left-two">
                        <div class="why-choose-box-two animate fadeInLeft wow" data-wow-duration="1500ms" data-wow-delay="200ms">
                            <div class="why-choose-icon-two">
                                <svg width="53" height="49" viewBox="0 0 53 49" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M3.125 9.5H49.875C51.0486 9.5 52 10.4514 52 11.625V45.625C52 46.7986 51.0486 47.75 49.875 47.75H3.125C1.95139 47.75 1 46.7986 1 45.625V11.625C1 10.4514 1.95139 9.5 3.125 9.5Z"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path
                                        d="M15.875 9.5V5.25C15.875 4.12283 16.3228 3.04183 17.1198 2.2448C17.9168 1.44777 18.9978 1 20.125 1H32.875C34.0022 1 35.0832 1.44777 35.8802 2.2448C36.6772 3.04183 37.125 4.12283 37.125 5.25V9.5"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path
                                        d="M1 23.926C8.74942 28.4098 17.5469 30.764 26.5 30.7499C35.4527 30.7642 44.2501 28.4109 52 23.9287"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path d="M30.75 22.25H22.25" stroke="white" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <h4>{{$about->title1}}</h4>
                            <p ><div class="aboutdes">{!! $about->description1 !!}</div></p>
                        </div>
                        <div class="why-choose-box-two animate fadeInUp wow" data-wow-duration="1500ms" data-wow-delay="400ms">
                            <div class="why-choose-icon-two">
                                <svg width="48" height="53" viewBox="0 0 48 53" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M44.9091 5.18182H3.09091C1.93613 5.18182 1 6.11796 1 7.27273V49.0909C1 50.2457 1.93613 51.1818 3.09091 51.1818H44.9091C46.0639 51.1818 47 50.2457 47 49.0909V7.27273C47 6.11796 46.0639 5.18182 44.9091 5.18182Z"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path d="M36.5449 1V9.36364" stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path d="M11.4551 1V9.36364" stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path
                                        d="M24.0005 36.1639L31.7552 40.7273L29.646 32.2095L36.546 26.5117L27.4897 25.8139L24.0005 17.7273L20.5113 25.8139L11.4551 26.5117L18.3551 32.2095L16.2459 40.7273L24.0005 36.1639Z"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                </svg>
                            </div>
                            <h4>{{$about->title2}}</h4>
                            <p ><div class="aboutdes">{!! $about->description2 !!}</div></p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="why-choose-right-two">
                        <div class="why-choose-box-two animate fadeInRight wow" data-wow-duration="1500ms" data-wow-delay="200ms">
                            <div class="why-choose-icon-two">
                                <svg width="51" height="51" viewBox="0 0 51 51" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M25.5 50C39.031 50 50 39.031 50 25.5C50 11.969 39.031 1 25.5 1C11.969 1 1 11.969 1 25.5C1 39.031 11.969 50 25.5 50Z"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path
                                        d="M35.7077 25.5C35.7077 41.8333 25.4993 50 25.4993 50C25.4993 50 15.291 41.8333 15.291 25.5C15.291 9.16667 25.4993 1 25.4993 1C25.4993 1 35.7077 9.16667 35.7077 25.5Z"
                                        stroke="white" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path d="M2.39258 17.3334H48.6057" stroke="white" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M2.39258 33.6666H48.6057" stroke="white" stroke-width="1.5"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <h4>{{$about->title3}}</h4>
                            <p><div class="aboutdes">{!! $about->description3 !!}</div></p>
                        </div>
                        <div class="why-choose-box-two animate fadeInRight wow" data-wow-duration="1500ms" data-wow-delay="400ms">
                            <div class="why-choose-icon-two">
                                <svg width="52" height="52" viewBox="0 0 52 52" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M25.75 50.5C39.419 50.5 50.5 39.419 50.5 25.75C50.5 12.081 39.419 1 25.75 1C12.081 1 1 12.081 1 25.75C1 39.419 12.081 50.5 25.75 50.5Z"
                                        stroke="white" stroke-width="2" stroke-linecap="round"
                                        stroke-linejoin="round" />
                                    <path d="M25.75 1L35.2066 27.4773" stroke="white" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M4.31641 13.375L31.9745 18.423" stroke="white" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M4.31641 38.125L22.518 16.6982" stroke="white" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M25.7495 50.5L16.293 24.0226" stroke="white" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M47.1855 38.125L19.5273 33.077" stroke="white" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                    <path d="M47.184 13.375L28.9824 34.8018" stroke="white" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" />
                                </svg>
                            </div>
                            <h4>{{$about->title4}}</h4>
                            <p ><div class="aboutdes">{!! $about->description4 !!}</div></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- why-choose two end -->
    <!-- team one start -->
    <div class="team-section-one">
        <div class="container">
            <div class="row">
                <div class="col-xl-5 m-auto">
                    <div class="heading-box text-center">
                        <span class="sub-title animate fadeInUp wow" data-wow-duration="1500ms">Team</span>
                        <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms" data-wow-delay="200ms">About Director</h2>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center gutter-y-60">
                @foreach($team as $t)
                <div class="col-lg-4 col-md-6">
                    <div class="team-box-one animate fadeInUp wow" data-wow-duration="1500ms">
                        <div class="team-image-one">
                            <a href=""><img src="{{$t->image_url}}" alt="team-image"></a>
                        </div>
                        <div class="team-details-one">
                            <h4><a href="">{{$t->name}}</a></h4>
                            <p>{{$t->designation}}</p>
                        </div>
                        <div class="team-description-one text-center px-3 pb-3 border-top">
                            <p class="pt-3 mb-0 text-dark">{!! $t->description !!}</p>
                        </div>
                       
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- team one end -->
    <!-- testimonial one start -->
    <div class="testimonial-section-one">
        <div class="container">
            <div class="heading-box text-center">
                <span class="sub-title">our client say</span>
            </div>
            <div class="row">
                <div class="col-lg-8 m-auto">
                    <div class="testimonial-slider-one">
                        @foreach($testimonial as $tes)
                        <div class="testimonial-item-one">
                            <div class="testimonial-author-image">
                                <img src="{{$tes->image_url}}" alt="Testimonial Image">
                            </div>
                            <h5>{{$tes->short_description}}</h5>
                            <img src="{{url('public/assets/user')}}/images/cote.svg" alt="icon">
                            <p>{{$tes->name}}</p>
                        </div>
                        @endforeach
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- testimonial one end -->
    
    <!-- why-choose four start -->
    <div class="why-choose-section-four about-why-choose-three">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 m-auto">
                    <div class="heading-box text-center">
                        <span class="sub-title animate fadeInUp wow" data-wow-duration="1500ms">OUR SKILL</span>
                        <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms" data-wow-delay="200ms">Our skills are the reasons why <span>clients choose us</span></h2>
                    </div>
                </div>
            </div>
            <div class="row justify-content-between gutter-y-30">
                <div class="col-12">
                    <div class="why-choose-video-four">
                        <div class="why-choose-image-four">
                        </div>
                        <a href="https://www.youtube.com/watch?v=rzfmZC3kg3M" class="why-choose-play-btn"><i
                                class="fa-solid fa-play"></i></a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="why-choose-left-four animate fadeInLeft wow" data-wow-duration="1500ms" data-wow-delay="200ms">
                        <p><span class="counter">430</span> <span>K</span></p>
                        <h5>Projects completed in last 5 years</h5>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-6">
                    <ul class="why-choose-list-four">
                    @foreach($project as $pro)
                        <li class="animate fadeInRight wow" data-wow-duration="1500ms" data-wow-delay="200ms">
                            <div class="why-choose-order-list">
                                <p>{{$pro->number_of_projects}}</p>
                            </div>
                            <div class="why-choose-details-four">
                                <h4>{{$pro->name}}</h4>
                                <p class="lead">{!! $pro->description !!}</p>
                            </div>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- why-choose four end -->
    <!-- cta  two start -->
    <div class="cta-section-three">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-10 m-auto">
                    <div class="heading-box text-center">
                        <h2 class="heading-title animate fadeInUp wow" data-wow-duration="1500ms" data-wow-delay="200ms">Get free Marketing Ideas…</h2>
                    </div>
                    <a href="{{url('contact')}}" class="btn btn-primary btn-theme animate fadeInUp wow" data-wow-duration="1500ms" data-wow-delay="400ms">Get Started +</a>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
<script src="{{url('public/assets/user')}}/js/jquery.circleType.js"></script>
<script src="{{url('public/assets/user')}}/js/jquery.circleGraph.js"></script>
<script src="{{url('public/assets/user')}}/js/jquery.appear.min.js"></script>
@endsection