<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title ?? 'Singi Marketing' }}</title>
    <!-- Font Awesome 5.11 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.11.2/css/all.min.css">
    <style>
        /* Reset styles for email clients */
        body, table, td, p, a, li, blockquote {
            -webkit-text-size-adjust: 100%;
            -ms-text-size-adjust: 100%;
        }
        
        table, td {
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
            border-collapse: collapse;
        }
        
        img {
            -ms-interpolation-mode: bicubic;
            border: 0;
            height: auto;
            line-height: 100%;
            outline: none;
            text-decoration: none;
            display: block;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #333333;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
        }
        
        .email-wrapper {
            background-color: #f8f9fa;
            padding: 20px 0;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border:1px solid #eee;
            overflow: hidden;
        }
        
        /* Header Styles */
        .header-gradient {
            background-color:rgb(24, 42, 55); 
            padding: 30px 30px;
            text-align: center;
        }
        
        .logo-container {
            background-color:#fff;
            border-radius: 16px;
            padding: 10px;
            display: inline-block;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
        
        .logo-text {
            color: #ffffff;
            font-size: 28px;
            font-weight: 700;
            margin: 0px 0 5px 0;
            padding: 0;
            letter-spacing: 0.5px;
        }
        
        .tagline-text {
            color: rgba(255, 255, 255, 0.85);
            font-size: 16px;
            font-weight: 400;
            margin: 0;
            padding: 0;
            letter-spacing: 0.3px;
        }
        
        /* Welcome Section Styles */
        .welcome-title {
            font-size: 28px;
            font-weight: 700;
            color: #1977BB;
            margin: 0 0 20px 0;
            padding: 0;
            position: relative;
            display: inline-block;
        }
        
        .welcome-title:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 60px;
            height: 3px;
            background: #1977BB;
            border-radius: 3px;
        }
        
        .welcome-text {
            font-size: 16px;
            color: #000;
            font-weight:200;
            margin: 0 0 30px 0;
            line-height: 1.4;
        }
        
        .highlight-box {
            background: linear-gradient(135deg, rgba(50, 165, 222, 0.08) 0%, rgba(25, 119, 187, 0.08) 100%);
            background-color: rgba(50, 165, 222, 0.08); /* Fallback */
            border-left: 4px solid #32A5DE;
            border-radius: 0 8px 8px 0;
            padding: 25px;
            margin: 30px 0;
            position: relative;
        }
        
        .highlight-box:before {
            content: '"';
            position: absolute;
            top: 15px;
            left: 15px;
            font-size: 50px;
            color: rgba(50, 165, 222, 0.2);
            font-family: Georgia, serif;
            line-height: 1;
        }
        
        .highlight-text {
            font-size: 18px;
            color: #1977BB;
            font-weight: 600;
            margin: 0;
            padding: 0 0 0 20px;
            font-style: italic;
        }
        
        /* CTA Button */
        .cta-button {
            background-color: #1977BB; /* Fallback */
            color: #ffffff !important;
            text-decoration: none;
            padding: 10px 22px;
            border-radius: 50px;
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: inline-block;
            transition: all 0.3s ease;
            border: none;
            cursor: pointer;
        }
        
        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(25, 119, 187, 0.4);
        }
        
        /* Credentials Section */
        .credentials-box {
            background-color: #fff; 
            border: 2px solid #e6f2fa;
            border-radius: 12px;
            padding: 20px;
            position: relative;
            overflow: hidden;
        }
        
        .credentials-box:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: #1977BB;
        }
        
        .credentials-title {
            font-size: 20px;
            color: #1977BB;
            margin: 0 0 20px 0;
            font-weight: 700;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .credential-item {
            background-color: #ffffff;
            border: 1px solid rgba(50, 165, 222, 0.15);
            border-radius: 8px;
            margin: 12px 0;
            padding: 16px 20px;
            text-align: left;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
            transition: all 0.2s ease;
        }
        
        .credential-item:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            transform: translateY(-1px);
        }
        
        .credential-label {
            font-size: 12px;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin: 0 0 6px 0;
            font-weight: 600;
            display: flex;
            align-items: center;
        }
        
        .credential-value {
            font-size: 16px;
            color: #1977BB;
            font-weight: 700;
            margin: 0;
            font-family: 'Courier New', monospace;
            word-break: break-all;
            padding-left: 22px;
        }
        
        .status-box {
            padding: 20px;
            border-radius: 8px;
            margin: 20px 0;
            text-align: center;
            background-color: {{ ($status ?? '') == 'Active' ? 'rgba(40, 167, 69, 0.1)' : 'rgba(220, 53, 69, 0.1)' }};
            border: 1px solid {{ ($status ?? '') == 'Active' ? 'rgba(40, 167, 69, 0.2)' : 'rgba(220, 53, 69, 0.2)' }};
        }
        
        .password-notice {
            background-color: #f5f5f5;
            padding:8px 16px;
            border-radius: 8px;
            margin: 15px 0;
            border-left: 4px solid #1977BB;
        }
        
        .security-notice {
            background-color: rgba(255, 193, 7, 0.1);
            border-left: 4px solid #ffc107;
            padding:8px 16px;
            margin: 20px 0 10px;
            border-radius: 0 8px 8px 0;
            display: flex;
            align-items: flex-start;
        }
        
        .security-text {
            font-size: 14px;
            color: #856404;
            margin: 0;
            line-height: 1.5;
        }
        
        .security-icon {
            color: #ffc107;
            margin-right: 12px;
            font-size: 18px;
            flex-shrink: 0;
            margin-top: 2px;
        }
        
        /* Features Section */
        .features-bg {
            background-color: #f9fbfd;
            position: relative;
        }
        
        .features-bg:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: #1977BB;
        }
        
        .features-title {
            font-size: 24px;
            color: #1977BB;
            margin: 0 0 20px 0;
            font-weight: 700;
            position: relative;
            display: inline-block;
        }
        
        .features-title:after {
            content: '';
            position: absolute;
            bottom: -12px;
            left: 50%;
            transform: translateX(-50%);
            width: 50px;
            height: 3px;
            background: #1977BB;
            border-radius: 3px;
        }
        
        .feature-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, #1977BB 0%, #32A5DE 100%);
            background-color: #1977BB; /* Fallback */
            border-radius: 50%;
            color: white;
            font-size: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px auto;
            box-shadow: 0 5px 15px rgba(25, 119, 187, 0.2);
            transition: all 0.3s ease;
        }
        
        .feature-icon:hover {
            transform: translateY(-3px) rotate(5deg);
            box-shadow: 0 8px 20px rgba(25, 119, 187, 0.3);
        }
        
        .contact-icon {
            color: #32A5DE;
            font-size: 16px;
            margin-right: 10px;
            vertical-align: middle;
            width: 20px;
            text-align: center;
        }
        
        .feature-title {
            font-size: 18px;
            font-weight: 600;
            color: #1977BB;
            margin: 15px 0 10px 0;
        }
        
        .feature-text {
            font-size: 14px;
            color: #666;
            line-height: 1.6;
            margin: 0;
            padding: 0 10px;
        }
        
        /* Contact Section */
        .contact-title {
            font-size: 22px;
            color: #1977BB;
            margin: 0 0 15px 0;
            font-weight: 700;
            position: relative;
            display: inline-block;
        }
        
        .contact-title:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 40px;
            height: 3px;
            background: #1977BB;
            border-radius: 3px;
        }
        
        .contact-info {
            color: #555;
            font-size: 15px;
            margin: 0 0 12px 0;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .social-link {
            display: inline-flex;
            width: 42px;
            height: 42px;
            background: linear-gradient(135deg, #1977BB 0%, #32A5DE 100%);
            background-color: #1977BB; /* Fallback */
            border-radius: 50%;
            margin: 0 6px;
            text-decoration: none;
            color: white !important;
            align-items: center;
            justify-content: center;
            font-size: 16px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 8px rgba(25, 119, 187, 0.2);
        }
        
        .social-link:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 12px rgba(25, 119, 187, 0.3);
        }
        
        /* Footer */
        .footer-bg {
            background: linear-gradient(135deg, #0d5a92 0%, #1977BB 100%);
            background-color: #0d5a92; /* Fallback */
            position: relative;
            overflow: hidden;
        }
        
        .footer-bg:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
        }
        
        .footer-text {
            color: rgba(255, 255, 255, 0.85);
            font-size: 13px;
            margin: 0;
            line-height: 1;
        }
        
        .footer-link {
            color: rgba(255, 255, 255, 0.9) !important;
            text-decoration: none;
            transition: all 0.2s ease;
        }
        
        .footer-link:hover {
            color: #fff !important;
            text-decoration: underline;
        }
        
        /* Decorative elements */
        .corner-decoration {
            position: absolute;
            width: 120px;
            height: 120px;
            opacity: 0.05;
        }
        
        .corner-top-right {
            top: -30px;
            right: -30px;
            background: linear-gradient(135deg, #32A5DE 0%, #1977BB 100%);
            border-radius: 50%;
        }
        
        .corner-bottom-left {
            bottom: -30px;
            left: -30px;
            background: linear-gradient(135deg, #32A5DE 0%, #1977BB 100%);
            border-radius: 50%;
        }
        
        /* Mobile Responsiveness */
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                max-width: 100% !important;
                border-radius: 0;
            }
            
            .mobile-padding {
                padding-left: 20px !important;
                padding-right: 20px !important;
            }
            
            .header-gradient {
                padding: 30px 20px !important;
            }
            
            .logo-container {
                padding: 15px !important;
            }
            
            .logo-text {
                font-size: 24px !important;
            }
            
            .welcome-title {
                font-size: 24px !important;
            }
            
            .mobile-stack {
                display: block !important;
                width: 100% !important;
            }
            
            .feature-mobile {
                padding-bottom: 30px !important;
                width: 100% !important;
            }
            
            .cta-button {
                padding: 14px 32px !important;
                font-size: 15px !important;
            }
            
            .credentials-box {
                padding: 20px 15px !important;
            }
            
            .credential-item {
                padding: 14px 16px !important;
            }
            
            .feature-icon {
                width: 60px !important;
                height: 60px !important;
                font-size: 24px !important;
            }
            
            .social-link {
                width: 38px !important;
                height: 38px !important;
                margin: 0 4px !important;
            }
        }
    </style>
</head>
<body>
    @php
        $sitesetting = App\Models\SiteSetting::first();
    @endphp
    <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" class="email-wrapper">
        <tr>
            <td align="center">
                <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="600" class="email-container">
                    
                    <!-- Header Section -->
                    <tr>
                        <td class="header-gradient">
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
                                <tr>
                                    <td align="center">
                                        <div class="logo-container">
                                            <a href="{{ url('/') }}" target="_blank"> 
                                                <img src="{{ asset($sitesetting->image) }}" alt="{{ $sitesetting->comp_name }}" 
                                                     style="max-width:80px; height:auto;">
                                            </a>
                                        </div>
                                        <h1 class="logo-text">
                                            <a href="{{ url('/') }}" target="_blank" style="text-decoration:none; color:inherit;">
                                                {{ $sitesetting->comp_name }}
                                            </a>
                                        </h1>
                                        <p class="tagline-text">Elevating Your Business Through Strategic Marketing</p>
                                    </td>
                                </tr>
                            </table>
                        </td>                        
                    </tr>                    
                    
                    <!-- Welcome Section -->
                    <tr>
                        <td style="padding: 20px 30px; text-align: center; border-bottom:1px solid #eee;" class="mobile-padding">
                            <p style="text-align:center; margin:0; font-size:30px; font-weight:600; line-height: 0;"><img style="width:10%; margin:0 auto;" src="{{ asset('assets/user/images/icon/icon-1.png') }}"></p>
                            <h1 class="welcome-title">Welcome to Singi Marketing.</h1>
                            <p class="welcome-text">
                                Thank you for joining SingiMarketing! We're thrilled to have you on board and excited to help you transform your business through innovative marketing strategies and exceptional telecalling services.
                            </p>
                            
                            <!-- Highlight Box -->
                            {{-- <div class="highlight-box">
                                <p class="highlight-text">
                                    "Your success is our mission. Together, we'll unlock new opportunities and drive remarkable growth for your business."
                                </p>
                            </div> --}}
                            <!-- User Credentials Section -->
                            <div class="credentials-box">
                                <h3 class="credentials-title">
                                    <img style="width:30px; height:30px; margin-right:10px;" src="{{ asset('assets/user/images/icon/icon-2.png') }}">
                                    Your Account Details
                                </h3>
                                
                                <!-- User ID -->
                                <div class="credential-item">
                                    <p class="credential-label"> <img style="width:15px; height:15px; margin-right:10px;" src="{{ asset('assets/user/images/icon/icon-3.png') }}"> User ID</p>
                                    <p class="credential-value">{{ $email ?? '' }}</p>
                                </div>

                                <!-- Account Status -->
                                {{-- <div class="status-box">
                                    <p style="font-size: 16px; color: {{ ($status ?? '') == 'Active' ? '#28a745' : '#dc3545' }}; margin: 0 0 10px 0;">
                                        <strong>Status:</strong> {{ $status ?? 'Unknown' }}
                                    </p>
                        
                                    @if($status === 'Active')
                                        <p style="font-size: 15px; margin: 10px 0;">
                                            Your account is now <strong>active</strong>. You can login here: 
                                            <a href="{{ url('/secure-dashboard/login') }}" target="_blank" class="cta-button">Login to Dashboard</a>
                                        </p>
                                    @else
                                        <p style="font-size: 15px; margin: 10px 0;">
                                            Your account status is now: <strong>{{ $status ?? 'Unknown' }}</strong>
                                        </p>
                                    @endif
                                </div> --}}

                                <div class="password-notice">
                                    <strong style="color: #004085;">Password Notice:</strong><br>
                                    Please contact your administrator to receive your login password.
                                </div>                                        
                                
                                <!-- Security Notice -->
                                <div class="security-notice">
                                    <img style="width:30px; height:30px; margin-right:10px;" src="{{ asset('assets/user/images/icon/icon-4.png') }}">
                                    <p class="security-text">
                                        <strong>Security Notice:</strong> Please change your password after your first login for enhanced security.
                                    </p>
                                </div>
                                @if($status === 'Active')
                                    <a href="{{ url('/secure-dashboard/login') }}" target="_blank" class="cta-button">Login to Dashboard</a>
                                    {{-- <div class="password-notice">
                                        <strong style="color: #004085;">Login Link:</strong><br>
                                    </div>  --}}
                                @endif                                        
                            </div>
                        </td>
                    </tr>
                    
                    <!-- Features Section -->
                    {{-- <tr>
                        <td class="features-bg" style="padding: 20px 30px;" class="mobile-padding">
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
                                <tr>
                                    <td align="center">
                                        <h2 class="features-title">What Makes Us Different</h2>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
                                            <tr>
                                                <!-- Feature 1 -->
                                                <td width="33.33%" align="center" style="padding: 0 15px 15px;" class="mobile-stack feature-mobile">
                                                    <h3 class="feature-title">Expert Telecalling</h3>
                                                    <p class="feature-text">Professional telecalling services that convert prospects into loyal customers</p>
                                                </td>
                                                
                                                <!-- Feature 2 -->
                                                <td width="33.33%" align="center" style="padding: 0 15px 15px;" class="mobile-stack feature-mobile">
                                                    <h3 class="feature-title">Growth Strategy</h3>
                                                    <p class="feature-text">Data-driven marketing strategies tailored to your business goals</p>
                                                </td>
                                                
                                                <!-- Feature 3 -->
                                                <td width="33.33%" align="center" style="padding: 0 15px 15px;" class="mobile-stack feature-mobile">
                                                    <h3 class="feature-title">Targeted Results</h3>
                                                    <p class="feature-text">Precision targeting to reach your ideal customers at the right time</p>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr> --}}
                    
                    <!-- Contact Section -->
                    <tr>
                        <td style="padding: 20px 30px; text-align: center; background-color: #ffffff;" class="mobile-padding">
                            <h2 class="contact-title" style="text-align: center;">Let's Connect!</h2>
                                <div style="width:50%; margin:0 auto;">
                                   
                            
                                    <p class="contact-info" style="text-align: center; margin: 5px 0;">
                                        <img style="width:30px; height:30px; margin-right:10px;" src="{{ asset('assets/user/images/icon/icon-6.png') }}">
                                        <a target="_blank" href="tel:{{ $sitesetting->comp_phone}}" 
                                        style="color: #000; text-decoration: none;">
                                            {{ $sitesetting->comp_phone}}
                                        </a>
                                    </p>
                                    <p class="contact-info" style="text-align: center; margin: 5px 0;">
                                        <img style="width:30px; height:30px; margin-right:10px;" src="{{ asset('assets/user/images/icon/icon-5.png') }}">
                                        <a target="_blank" href="mailto:{{ $sitesetting->comp_email}}" 
                                        style="color: #000; text-decoration: none;">
                                            {{ $sitesetting->comp_email}}
                                        </a>
                                    </p>
                            
                                    <p class="contact-info" style="text-align: center; margin: 5px 0;">
                                        <img style="width:30px; height:30px; margin-right:10px;" src="{{ asset('assets/user/images/icon/icon-7.png') }}">
                                        <a target="_blank" href="{{ $sitesetting->comp_website ?? 'https://singimarketing.com/' }}" 
                                        style="color: #000; text-decoration: none;">
                                            {{ $sitesetting->comp_website ?? 'www.singimarketing.com' }}
                                        </a>
                                    </p>
                                </div>
                    
                            @if(!empty($sitesetting->comp_fb) || !empty($sitesetting->linkdin_link) || !empty($sitesetting->comp_tweeter) || !empty($sitesetting->insta_link) || !empty($sitesetting->youtube_link) || !empty($sitesetting->pinterest_link))
                                <table role="presentation" cellspacing="0" cellpadding="0" border="0" style="margin: 25px auto;">
                                    <tr>
                                        <td align="center">
                                            @if(!empty($sitesetting->comp_fb))
                                                <a href="{{ $sitesetting->comp_fb }}" target="_blank" class="social-link">
                                                    <i class="fab fa-facebook-f"></i>
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->linkdin_link))
                                                <a href="{{ $sitesetting->linkdin_link }}" target="_blank" class="social-link">
                                                    <i class="fab fa-linkedin-in"></i>
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->comp_tweeter))
                                                <a href="{{ $sitesetting->comp_tweeter }}" target="_blank" class="social-link">
                                                    <i class="fab fa-twitter"></i>
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->insta_link))
                                                <a href="{{ $sitesetting->insta_link }}" target="_blank" class="social-link">
                                                    <i class="fab fa-instagram"></i>
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->youtube_link))
                                                <a href="{{ $sitesetting->youtube_link }}" target="_blank" class="social-link">
                                                    <i class="fab fa-youtube"></i>
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->pinterest_link))
                                                <a href="{{ $sitesetting->pinterest_link }}" target="_blank" class="social-link">
                                                    <i class="fab fa-pinterest-p"></i>
                                                </a>
                                            @endif
                                        </td>
                                    </tr>
                                </table>
                            @endif
                        </td>                        
                    </tr>
                    
                    
                    <!-- Footer -->
                    <tr>
                        <td class="footer-bg" style="padding: 15px; text-align: center;">
                            <p class="footer-text">© {{ date('Y') }} {{ $sitesetting->comp_name ?? 'SingiMarketing' }}. All rights reserved.</p>                            
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" style="margin: 15px auto 5px;">
                                <tr>
                                    <td align="center">
                                        <p class="footer-text">
                                            <a href="{{ url('/privacy-policy') }}" target="_blank" class="footer-link">
                                                Privacy Policy
                                            </a> | 
                                            <a href="{{ url('/terms-and-conditions') }}" target="_blank" class="footer-link">
                                                Terms of Service
                                            </a>
                                        </p>                                        
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                </table>
            </td>
        </tr>
    </table>
</body>
</html>