<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title ?? 'Singi Marketing' }}</title>
    <!-- Font Awesome 5.11 -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.11.2/css/all.min.css">
</head>
<body style="-webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Helvetica Neue', Arial, sans-serif; line-height: 1.6; color: #333333; background-color: #f8f9fa; margin: 0; padding: 0; width: 100%; height: 100%;">
    @php
        $sitesetting = App\Models\SiteSetting::first();
    @endphp
    <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse; background-color: #f8f9fa; padding: 20px 0;">
        <tr>
            <td align="center">
                <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="600" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse; max-width: 600px; margin: 0 auto; background-color: #ffffff; border: 1px solid #eee; overflow: hidden;">
                    
                    <!-- Header Section -->
                    <tr>
                        <td style="background-color: rgb(24, 42, 55); padding: 30px 30px; text-align: center;">
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse;">
                                <tr>
                                    <td align="center">
                                        <div style="background-color: #fff; border-radius: 16px; padding: 10px; display: inline-block; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);">
                                            <a href="{{ url('/') }}" target="_blank"> 
                                                <img src="{{ asset($sitesetting->image) }}" alt="{{ $sitesetting->comp_name }}" 
                                                     style="max-width: 80px; height: auto; -ms-interpolation-mode: bicubic; border: 0; line-height: 100%; outline: none; text-decoration: none; display: block;">
                                            </a>
                                        </div>
                                        <h1 style="color: #ffffff; font-size: 28px; font-weight: 700; margin: 0px 0 5px 0; padding: 0; letter-spacing: 0.5px;">
                                            <a href="{{ url('/') }}" target="_blank" style="text-decoration: none; color: inherit;">
                                                {{ $sitesetting->comp_name }}
                                            </a>
                                        </h1>
                                        <p style="color: rgba(255, 255, 255, 0.85); font-size: 16px; font-weight: 400; margin: 0; padding: 0; letter-spacing: 0.3px;">Elevating Your Business Through Strategic Marketing</p>
                                    </td>
                                </tr>
                            </table>
                        </td>                        
                    </tr>                    
                    
                    <!-- Welcome Section -->
                    <tr>
                        <td style="padding: 20px 30px; text-align: center; border-bottom: 1px solid #eee;">
                            <p style="text-align: center; margin: 0; font-size: 30px; font-weight: 600; line-height: 0;">
                                <img style="width: 10%; margin: 0 auto; -ms-interpolation-mode: bicubic; border: 0; height: auto; line-height: 100%; outline: none; text-decoration: none; display: block;" src="{{ asset('assets/user/images/icon/icon-1.png') }}">
                            </p>
                            <h1 style="font-size: 28px; font-weight: 700; color: #1977BB; margin: 0 0 20px 0; padding: 0; position: relative; display: inline-block;">Welcome to Singi Marketing.</h1>
                            <p style="font-size: 16px; color: #000; font-weight: 200; margin: 0 0 30px 0; line-height: 1.4;">
                                Thank you for joining SingiMarketing! We're thrilled to have you on board and excited to help you transform your business through innovative marketing strategies and exceptional telecalling services.
                            </p>
                            
                            <!-- User Credentials Section -->
                            <div style="background-color: #fff; border: 2px solid #e6f2fa; border-radius: 12px; padding: 20px; position: relative; overflow: hidden; border-top: 4px solid #1977BB;">
                                <h3 style="font-size: 20px; color: #1977BB; margin: 0 0 20px 0; font-weight: 700; display: flex; align-items: center; justify-content: center;">
                                    <img style="width: 30px; height: 30px; margin-right: 10px; -ms-interpolation-mode: bicubic; border: 0; line-height: 100%; outline: none; text-decoration: none; display: inline-block;" src="{{ asset('assets/user/images/icon/icon-2.png') }}">
                                    Your Account Details
                                </h3>
                                
                                <!-- User ID -->
                                <div style="background-color: #ffffff; border: 1px solid rgba(50, 165, 222, 0.15); border-radius: 8px; margin: 12px 0; padding: 16px 20px; text-align: left; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);">
                                    <p style="font-size: 12px; color: #666; text-transform: uppercase; letter-spacing: 1px; margin: 0 0 6px 0; font-weight: 600; display: flex; align-items: center; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                        <img style="width: 15px; height: 15px; margin-right: 10px; -ms-interpolation-mode: bicubic; border: 0; line-height: 100%; outline: none; text-decoration: none; display: inline-block;" src="{{ asset('assets/user/images/icon/icon-3.png') }}"> 
                                        User ID
                                    </p>
                                    <p style="font-size: 16px; color: #1977BB; font-weight: 700; margin: 0; font-family: 'Courier New', monospace; word-break: break-all; padding-left: 22px; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">{{ $email ?? '' }}</p>
                                </div>

                                <div style="background-color: #f5f5f5; padding: 8px 16px; border-radius: 8px; margin: 15px 0; border-left: 4px solid #1977BB;">
                                    <strong style="color: #004085;">Password Notice:</strong><br>
                                    Please contact your administrator to receive your login password.
                                </div>                                        
                                
                                <!-- Security Notice -->
                                <div style="background-color: rgba(255, 193, 7, 0.1); border-left: 4px solid #ffc107; padding: 8px 16px; margin: 20px 0 10px; border-radius: 0 8px 8px 0; display: flex; align-items: flex-start;">
                                    <img style="width: 30px; height: 30px; margin-right: 10px; -ms-interpolation-mode: bicubic; border: 0; line-height: 100%; outline: none; text-decoration: none; display: inline-block;" src="{{ asset('assets/user/images/icon/icon-4.png') }}">
                                    <p style="font-size: 14px; color: #856404; margin: 0; line-height: 1.5; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                        <strong>Security Notice:</strong> Please change your password after your first login for enhanced security.
                                    </p>
                                </div>
                                <a href="{{ url('/') }}" target="_blank" style="background-color: #1977BB; color: #ffffff !important; text-decoration: none; padding: 10px 22px; border-radius: 50px; font-size: 14px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px; display: inline-block; border: none; cursor: pointer;">Login to Dashboard</a>                                   
                            </div>
                        </td>
                    </tr>
                    
                    
                    <!-- Contact Section -->
                    <tr>
                        <td style="padding: 20px 30px; text-align: center; background-color: #ffffff;">
                            <h2 style="font-size: 22px; color: #1977BB; margin: 0 0 15px 0; font-weight: 700; position: relative; display: inline-block; text-align: center;">Let's Connect!</h2>
                            <div style="width: 50%; margin: 0 auto;">
                                <p style="color: #555; font-size: 15px; margin: 5px 0; display: flex; align-items: center; justify-content: center; text-align: center; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                    <img style="width: 30px; height: 30px; margin-right: 10px; -ms-interpolation-mode: bicubic; border: 0; line-height: 100%; outline: none; text-decoration: none; display: inline-block;" src="{{ asset('assets/user/images/icon/icon-6.png') }}">
                                    <a target="_blank" href="tel:{{ $sitesetting->comp_phone}}" 
                                    style="color: #000; text-decoration: none; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                        {{ $sitesetting->comp_phone}}
                                    </a>
                                </p>
                                <p style="color: #555; font-size: 15px; margin: 5px 0; display: flex; align-items: center; justify-content: center; text-align: center; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                    <img style="width: 30px; height: 30px; margin-right: 10px; -ms-interpolation-mode: bicubic; border: 0; line-height: 100%; outline: none; text-decoration: none; display: inline-block;" src="{{ asset('assets/user/images/icon/icon-5.png') }}">
                                    <a target="_blank" href="mailto:{{ $sitesetting->comp_email}}" 
                                    style="color: #000; text-decoration: none; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                        {{ $sitesetting->comp_email}}
                                    </a>
                                </p>
                        
                                <p style="color: #555; font-size: 15px; margin: 5px 0; display: flex; align-items: center; justify-content: center; text-align: center; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                    <img style="width: 30px; height: 30px; margin-right: 10px; -ms-interpolation-mode: bicubic; border: 0; line-height: 100%; outline: none; text-decoration: none; display: inline-block;" src="{{ asset('assets/user/images/icon/icon-7.png') }}">
                                    <a target="_blank" href="{{ $sitesetting->comp_website ?? 'https://singimarketing.com/' }}" 
                                    style="color: #000; text-decoration: none; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                        {{ $sitesetting->comp_website ?? 'www.singimarketing.com' }}
                                    </a>
                                </p>
                            </div>
                
                            @if(!empty($sitesetting->comp_fb) || !empty($sitesetting->linkdin_link) || !empty($sitesetting->comp_tweeter) || !empty($sitesetting->insta_link) || !empty($sitesetting->youtube_link) || !empty($sitesetting->pinterest_link))
                                <table role="presentation" cellspacing="0" cellpadding="0" border="0" style="margin: 25px auto; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse;">
                                    <tr>
                                        <td align="center">
                                            @if(!empty($sitesetting->comp_fb))
                                                <a href="{{ $sitesetting->comp_fb }}" target="_blank" style="display: inline-flex; width: 42px; height: 42px; background-color: #1977BB; border-radius: 50%; margin: 0 6px; text-decoration: none; color: white !important; align-items: center; justify-content: center; font-size: 16px; box-shadow: 0 4px 8px rgba(25, 119, 187, 0.2); -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                                    <img style="height:16px;" src="{{ asset('assets/user/images/facebook.svg') }}">
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->linkdin_link))
                                                <a href="{{ $sitesetting->linkdin_link }}" target="_blank" style="display: inline-flex; width: 42px; height: 42px; background-color: #1977BB; border-radius: 50%; margin: 0 6px; text-decoration: none; color: white !important; align-items: center; justify-content: center; font-size: 16px; box-shadow: 0 4px 8px rgba(25, 119, 187, 0.2); -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                                    <img style="height:16px;" src="{{ asset('assets/user/images/linkedin.svg') }}">
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->comp_tweeter))
                                                <a href="{{ $sitesetting->comp_tweeter }}" target="_blank" style="display: inline-flex; width: 42px; height: 42px; background-color: #1977BB; border-radius: 50%; margin: 0 6px; text-decoration: none; color: white !important; align-items: center; justify-content: center; font-size: 16px; box-shadow: 0 4px 8px rgba(25, 119, 187, 0.2); -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                                    <img style="height:16px;" src="{{ asset('assets/user/images/twitter.svg') }}">
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->insta_link))
                                                <a href="{{ $sitesetting->insta_link }}" target="_blank" style="display: inline-flex; width: 42px; height: 42px; background-color: #1977BB; border-radius: 50%; margin: 0 6px; text-decoration: none; color: white !important; align-items: center; justify-content: center; font-size: 16px; box-shadow: 0 4px 8px rgba(25, 119, 187, 0.2); -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                                    <img style="height:16px;" src="{{ asset('assets/user/images/instagram.svg') }}">
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->youtube_link))
                                                <a href="{{ $sitesetting->youtube_link }}" target="_blank" style="display: inline-flex; width: 42px; height: 42px; background-color: #1977BB; border-radius: 50%; margin: 0 6px; text-decoration: none; color: white !important; align-items: center; justify-content: center; font-size: 16px; box-shadow: 0 4px 8px rgba(25, 119, 187, 0.2); -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                                    <img style="height:16px;" src="{{ asset('assets/user/images/youtube_svg.svg') }}">
                                                </a>
                                            @endif
                                            @if(!empty($sitesetting->pinterest_link))
                                                <a href="{{ $sitesetting->pinterest_link }}" target="_blank" style="display: inline-flex; width: 42px; height: 42px; background-color: #1977BB; border-radius: 50%; margin: 0 6px; text-decoration: none; color: white !important; align-items: center; justify-content: center; font-size: 16px; box-shadow: 0 4px 8px rgba(25, 119, 187, 0.2); -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                                    <i class="fab fa-pinterest-p"></i>
                                                </a>
                                            @endif
                                        </td>
                                    </tr>
                                </table>
                            @endif
                        </td>                        
                    </tr>
                    
                    
                    <!-- Footer -->
                    <tr>
                        <td style="background-color: #0d5a92; position: relative; overflow: hidden; padding: 15px; text-align: center;">
                            <p style="color: rgba(255, 255, 255, 0.85); font-size: 13px; margin: 0; line-height: 1; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">© {{ date('Y') }} {{ $sitesetting->comp_name ?? 'SingiMarketing' }}. All rights reserved.</p>                            
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" style="margin: 15px auto 5px; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-collapse: collapse;">
                                <tr>
                                    <td align="center">
                                        <p style="color: rgba(255, 255, 255, 0.85); font-size: 13px; margin: 0; line-height: 1; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                            <a href="{{ url('/privacy-policy') }}" target="_blank" style="color: rgba(255, 255, 255, 0.9) !important; text-decoration: none; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                                Privacy Policy
                                            </a> | 
                                            <a href="{{ url('/terms-and-conditions') }}" target="_blank" style="color: rgba(255, 255, 255, 0.9) !important; text-decoration: none; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100;">
                                                Terms of Service
                                            </a>
                                        </p>                                        
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                </table>
            </td>
        </tr>
    </table>

    <!-- Mobile Responsiveness Media Query (Email client support varies) -->
    <style type="text/css">
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
                max-width: 100% !important;
                border-radius: 0;
            }
            
            .mobile-padding {
                padding-left: 20px !important;
                padding-right: 20px !important;
            }
            
            .header-gradient {
                padding: 30px 20px !important;
            }
            
            .logo-container {
                padding: 15px !important;
            }
            
            .logo-text {
                font-size: 24px !important;
            }
            
            .welcome-title {
                font-size: 24px !important;
            }
            
            .mobile-stack {
                display: block !important;
                width: 100% !important;
            }
            
            .feature-mobile {
                padding-bottom: 30px !important;
                width: 100% !important;
            }
            
            .cta-button {
                padding: 14px 32px !important;
                font-size: 15px !important;
            }
            
            .credentials-box {
                padding: 20px 15px !important;
            }
            
            .credential-item {
                padding: 14px 16px !important;
            }
            
            .social-link {
                width: 38px !important;
                height: 38px !important;
                margin: 0 4px !important;
            }
        }
    </style>
</body>
</html>