<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Campaign Report Email</title>
    <!--[if mso]>
    <noscript>
        <xml>
            <o:OfficeDocumentSettings>
                <o:PixelsPerInch>96</o:PixelsPerInch>
            </o:OfficeDocumentSettings>
        </xml>
    </noscript>
    <![endif]-->
    
</head>
<body style="margin: 0; padding: 0; width: 100%; height: 100%; font-family: Arial, sans-serif; font-size: 14px; line-height: 1.4; color: #333333; background-color: #f4f4f4; -webkit-text-size-adjust: 100%; -ms-text-size-adjust: 100%; ">
    <!-- Main Container Table -->
    <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f4f4f4; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width:100%;">
        <tr>
            <td align="center" style="padding: 20px 10px;">
                <!-- Email Container Table -->
                <table cellpadding="0" cellspacing="0" border="0" class="mobile-container" style="max-width: 600px; margin: 0 auto; background-color: #ffffff; overflow: hidden; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
                    
                    <!-- Header -->
                    <tr>
                        <td style="background-color: rgb(24, 42, 55); padding: 30px 30px; text-align: center;" class="mobile-header-padding">
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
                                <tr>
                                    <td align="center">
                                        <div style="background-color: #fff; border-radius: 16px; padding: 10px; display: inline-block; box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);">
                                            <a href="{{ url('/') }}" target="_blank"> 
                                                <img src="{{ asset($sitesetting->image) }}" alt="{{ $sitesetting->comp_name }}" 
                                                     style="max-width: 80px; height: auto; display: block; border: 0; outline: none; text-decoration: none; -ms-interpolation-mode: bicubic;" class="mobile-logo">
                                            </a>
                                        </div>
                                        <h1 style="color: #ffffff; font-size: 28px; font-weight: 700; margin: 0px 0 5px 0; padding: 0; letter-spacing: 0.5px;" class="mobile-logo-text">
                                            <a href="{{ url('/') }}" target="_blank" style="text-decoration: none; color: inherit;">
                                                {{ $sitesetting->comp_name }}
                                            </a>
                                        </h1>
                                        <p style="color: rgba(255, 255, 255, 0.85); font-size: 16px; font-weight: 400; margin: 0; padding: 0; letter-spacing: 0.3px;" class="mobile-tagline">Elevating Your Business Through Strategic Marketing</p>
                                    </td>
                                </tr>
                            </table>
                        </td>                        
                    </tr>  
                    
                    <!-- Campaign Information -->
                    <tr>
                        <td style="padding: 20px;" class="mobile-padding">
                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #ecf0f1; border-radius: 5px; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
                                <tr>
                                    <td style="padding: 15px;">
                                        <h2 style="margin: 0 0 10px 0; color: #2c3e50; font-size: 18px;" class="mobile-title">Campaign Details</h2>
                                        <p style="margin: 5px 0; color: #555555; font-size: 14px;" class="mobile-text"><strong>Campaign Name:</strong> Summer Sales Drive 2024</p>
                                        <p style="margin: 5px 0; color: #555555; font-size: 14px;" class="mobile-text"><strong>Report Generated:</strong> August 29, 2025 at 2:30 PM</p>
                                        <p style="margin: 5px 0; color: #555555; font-size: 14px;" class="mobile-text"><strong>Start Date:</strong> August 1, 2025</p>
                                        <p style="margin: 5px 0; color: #555555; font-size: 14px;" class="mobile-text"><strong>End Date:</strong> August 28, 2025</p>
                                        <p style="margin: 5px 0; color: #555555; font-size: 14px;" class="mobile-text"><strong>Duration:</strong> 27 days</p>
                                        <p style="margin: 5px 0; color: #555555; font-size: 14px;" class="mobile-text"><strong>Status:</strong> Completed</p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Campaign Summary -->
                    <tr>
                        <td style="padding: 0 20px 20px 20px;" class="mobile-padding">
                            <h3 style="color: #2c3e50; margin: 25px 0 15px 0; font-size: 18px;" class="mobile-title">Campaign Summary</h3>
                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border-collapse: collapse; background-color: #ffffff; box-shadow: 0 1px 3px rgba(0,0,0,0.1); mso-table-lspace: 0pt; mso-table-rspace: 0pt; width:100%;">
                                <tr>
                                    <td style="background-color: #34495e; color: #ffffff; padding: 12px 8px; font-weight: bold; font-size: 12px; text-transform: uppercase; border-bottom: 1px solid #2c3e50;" class="mobile-table-header">Metric</td>
                                    <td style="background-color: #34495e; color: #ffffff; padding: 12px 8px; text-align: right; font-weight: bold; font-size: 12px; text-transform: uppercase; border-bottom: 1px solid #2c3e50;" class="mobile-table-header">Value</td>
                                </tr>
                                <tr style="background-color: #f8f9fa;">
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; font-weight: bold; font-size: 14px;" class="mobile-table-cell">Total Calls</td>
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; text-align: right; font-weight: bold; font-size: 14px;" class="mobile-table-cell">1,847</td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; font-weight: bold; font-size: 14px;" class="mobile-table-cell">Sell Price</td>
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; text-align: right; color: #27ae60; font-weight: bold; font-size: 14px;" class="mobile-table-cell">₹45,230.50</td>
                                </tr>
                                <tr style="background-color: #f8f9fa;">
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; font-weight: bold; font-size: 14px;" class="mobile-table-cell">Commission Total</td>
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; text-align: right; color: #27ae60; font-weight: bold; font-size: 14px;" class="mobile-table-cell">₹6,784.58</td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; font-weight: bold; font-size: 14px;" class="mobile-table-cell">Working Earnings</td>
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; text-align: right; color: #27ae60; font-weight: bold; font-size: 14px;" class="mobile-table-cell">₹12,456.75</td>
                                </tr>
                                <tr style="background-color: #f8f9fa;">
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; font-weight: bold; font-size: 14px;" class="mobile-table-cell">Lead Earnings</td>
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; text-align: right; color: #27ae60; font-weight: bold; font-size: 14px;" class="mobile-table-cell">₹3,892.25</td>
                                </tr>
                                <tr>
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; font-weight: bold; font-size: 14px;" class="mobile-table-cell">Total Call Time</td>
                                    <td style="padding: 10px 8px; border-bottom: 1px solid #ecf0f1; text-align: right; font-size: 14px;" class="mobile-table-cell">248:35:42</td>
                                </tr>
                                <tr style="background-color: #f8f9fa;">
                                    <td style="padding: 10px 8px; font-weight: bold; font-size: 14px;" class="mobile-table-cell">Penalty</td>
                                    <td style="padding: 10px 8px; text-align: right; color: #e74c3c; font-size: 14px;" class="mobile-table-cell">₹425.00</td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Detailed Records Title -->
                    <tr>
                        <td style="padding: 0 20px;" class="mobile-padding">
                            <h3 style="color: #2c3e50; margin: 25px 0 15px 0; font-size: 18px;" class="mobile-title">Detailed Records</h3>
                        </td>
                    </tr>
                    
                    <!-- Record 1 - John Smith -->
                    <tr>
                        <td style="padding: 0 20px 25px 20px;" class="mobile-record-padding">
                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="border: 1px solid #ddd; border-radius: 5px; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
                                <tr>
                                    <td colspan="2" style="background-color: #34495e; color: white; padding: 10px; font-weight: bold; font-size: 14px;" class="mobile-table-cell">John Smith</td>
                                </tr>
                                <tr>
                                    <td style="background-color: #f8f9fa; padding: 8px 12px; border-bottom: 1px solid #ecf0f1; border-right: 2px solid #27ae60; font-weight: bold; color: #2c3e50; font-size: 14px;" class="mobile-table-cell">Commission</td>
                                    <td style="padding: 8px 12px; border-bottom: 1px solid #ecf0f1; color: #27ae60; font-weight: bold; font-size: 14px;" class="mobile-table-cell">₹446.82</td>
                                </tr>
                                <tr>
                                    <td style="background-color: #f8f9fa; padding: 8px 12px; border-bottom: 1px solid #ecf0f1; border-right: 2px solid #27ae60; font-weight: bold; color: #2c3e50; font-size: 14px;" class="mobile-table-cell">Working Earn</td>
                                    <td style="padding: 8px 12px; border-bottom: 1px solid #ecf0f1; color: #27ae60; font-weight: bold; font-size: 14px;" class="mobile-table-cell">₹850.50</td>
                                </tr>
                                <tr>
                                    <td style="background-color: #f8f9fa; padding: 8px 12px; border-bottom: 1px solid #ecf0f1; border-right: 2px solid #27ae60; font-weight: bold; color: #2c3e50; font-size: 14px;" class="mobile-table-cell">Lead Earn</td>
                                    <td style="padding: 8px 12px; border-bottom: 1px solid #ecf0f1; color: #27ae60; font-weight: bold; font-size: 14px;" class="mobile-table-cell">₹376.00</td>
                                </tr>
                                <tr>
                                    <td style="background-color: #f8f9fa; padding: 8px 12px; border-bottom: 1px solid #ecf0f1; border-right: 2px solid #27ae60; font-weight: bold; color: #2c3e50; font-size: 14px;" class="mobile-table-cell">Call Time</td>
                                    <td style="padding: 8px 12px; border-bottom: 1px solid #ecf0f1; font-size: 14px;" class="mobile-table-cell">45:50:19</td>
                                </tr>
                                <tr>
                                    <td style="background-color: #f8f9fa; padding: 8px 12px; border-right: 2px solid #27ae60; font-weight: bold; color: #2c3e50; font-size: 14px;" class="mobile-table-cell">Penalty</td>
                                    <td style="padding: 8px 12px; color: #e74c3c; font-size: 14px;" class="mobile-table-cell">₹175.00</td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Additional Notes -->
                    <tr>
                        <td style="padding: 0 20px 20px 20px;" class="mobile-padding">
                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #fff3cd; border-left: 4px solid #ffc107; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
                                <tr>
                                    <td style="padding: 15px; color: #856404;">
                                        <p style="margin: 0; font-size: 12px; line-height: 1.4;" class="mobile-text">
                                            <strong>Note:</strong> This is an automated report generated upon campaign completion. 
                                            All monetary values are displayed in Ruppes(₹). Call times are shown in HH:MM:SS format.
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td style="padding: 15px; text-align: center; background: #0d5a92;">
                            <p style="color: #fff; margin: 0; font-size: 13px; line-height: 1.4;" class="mobile-text">© 2025 {{ $sitesetting->comp_name }}. All rights reserved.</p>                            
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" style="margin: 15px auto 5px; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt;">
                                <tr>
                                    <td align="center">
                                        <p style="color: #fff; margin: 0; font-size: 13px; line-height: 1.4;" class="mobile-text">
                                            <a href="{{ url('/privacy-policy') }}" style="color: #fff; margin: 0; text-decoration: none;" target="_blank">
                                                Privacy Policy
                                            </a> | 
                                            <a href="{{ url('/terms-and-conditions') }}" target="_blank" style="color: #fff; margin: 0; text-decoration: none;">
                                                Terms of Service
                                            </a> | 
                                            <a href="{{ url('/') }}" target="_blank" style="color: #fff; margin: 0; text-decoration: none;">
                                                Login To Dashboard
                                            </a>
                                        </p>                                        
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    
                </table>
            </td>
        </tr>
    </table>
    <style type="text/css">
        /* Mobile Styles */
        @media only screen and (max-width: 600px) {
            .mobile-container {
                width: 100% !important;
                max-width: 100% !important;
            }
            .mobile-padding {
                padding: 15px !important;
            }
            .mobile-header-padding {
                padding: 20px 15px !important;
            }
            .mobile-text {
                font-size: 13px !important;
                line-height: 1.4 !important;
            }
            .mobile-title {
                font-size: 16px !important;
            }
            .mobile-table-cell {
                padding: 6px 4px !important;
                font-size: 12px !important;
            }
            .mobile-table-header {
                padding: 8px 4px !important;
                font-size: 11px !important;
            }
            .mobile-record-padding {
                padding: 0 15px 20px 15px !important;
            }
            .mobile-logo {
                max-width: 60px !important;
            }
            .mobile-logo-text {
                font-size: 20px !important;
            }
            .mobile-tagline {
                font-size: 13px !important;
            }
        }
        
        /* Outlook specific fixes */
        table {
            border-collapse: collapse;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
        }
        
        /* Remove blue links in devices */
        a[x-apple-data-detectors] {
            color: inherit !important;
            text-decoration: none !important;
        }
    </style>
</body>
</html>