<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title }}</title>
</head>
<body style="margin: 0; padding: 0; width: 100%; font-family: Arial, sans-serif; font-size: 14px; line-height: 1.4; color: #333; background-color: #f4f4f4;">

    <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #f4f4f4; width:100%;">
        <tr>
            <td align="center" style="padding: 20px 10px;">
                <table cellpadding="0" cellspacing="0" border="0" style="max-width: 600px; margin: 0 auto; background-color: #ffffff; border-radius: 8px; overflow: hidden;">
                    
                    <!-- Header -->
                    <tr>
                        <td style="background-color: rgb(24,42,55); padding: 25px; text-align: center; color: #fff;">
                            <a href="{{ url('/') }}" target="_blank">
                                <img src="{{ asset($sitesetting->image) }}" alt="{{ $sitesetting->comp_name }}" style="max-width: 80px; display: block; margin: 0 auto; border-radius: 10px;">
                            </a>
                            <h1 style="margin: 10px 0 0; font-size: 22px; font-weight: bold;">
                                {{ $sitesetting->comp_name }}
                            </h1>
                            <p style="margin: 5px 0 0; font-size: 14px; color: rgba(255,255,255,0.85);">New Career Application Submitted</p>
                        </td>
                    </tr>

                    <!-- Career Details -->
                    <tr>
                        <td style="padding: 20px;">
                            <table width="100%" cellpadding="0" cellspacing="0" border="0" style="background-color: #ecf0f1; border-radius: 5px; padding: 15px;">
                                <tr>
                                    <td style="padding: 5px 0;"><strong>Name:</strong> {{ $career->name }}</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0;"><strong>Mobile:</strong> {{ $career->mobile }}</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0;"><strong>Email:</strong> {{ $career->email }}</td>
                                </tr>
                               <tr>
                                    <td style="padding: 5px 0;"><strong>City:</strong> {{ $career->city_name ?? '' }}</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0;"><strong>Address:</strong> {{ $career->address }}</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0;"><strong>Job Type:</strong> {{ $career->jobtype_name ?? '' }}</td>
                                </tr>
                                <tr>
                                    <td style="padding: 5px 0;"><strong>Aadhar Card:</strong> {{ $career->aadhar_card }}</td>
                                </tr>
                                @if(!empty($career->pancard))
                                <tr>
                                    <td style="padding: 5px 0;"><strong>PAN Card:</strong> {{ $career->pancard }}</td>
                                </tr>
                                @endif
                                @if(!empty($career->image))
                                <tr>
                                    <td style="padding: 5px 0;">
                                        <strong>Resume:</strong> 
                                        <a href="{{ asset('storage/' . $career->image) }}" target="_blank">View / Download</a>
                                    </td>
                                </tr>
                                @endif

                            </table>
                        </td>
                    </tr>

                    <!-- Footer -->
                    <tr>
                        <td style="padding: 15px; text-align: center; background-color: #0d5a92; color: #fff; font-size: 13px;">
                            © {{ date('Y') }} {{ $sitesetting->comp_name }}. All rights reserved.
                            <br>
                            <a href="{{ url('/') }}" style="color: #fff; text-decoration: underline;">Visit Website</a>
                        </td>
                    </tr>

                </table>
            </td>
        </tr>
    </table>

    <style type="text/css">
        @media only screen and (max-width: 600px) {
            table { width: 100% !important; }
            h1 { font-size: 20px !important; }
        }
    </style>

</body>
</html>
