@extends('admin.layout.app')

@section('content')
<style>

        .visual_meeting_container {
            display: flex;
            flex-direction: column;
            padding: 20px;
        }

        .meeting-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(15px);
            border-radius: 20px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .meeting-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
        }

        .meeting-details h2 {
            font-size: 2rem;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 8px;
        }

        .meeting-id {
            color: #7f8c8d;
            font-size: 1rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .participants-count {
            background: linear-gradient(135deg, #3498db, #2980b9);
            color: white;
            padding: 8px 16px;
            border-radius: 25px;
            font-weight: 600;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .meeting-controls {
            display: flex;
            gap: 15px;
            align-items: center;
        }

        .control-btn {
            background: linear-gradient(135deg, #3498db, #2980b9);
            border: none;
            border-radius: 50%;
            width: 55px;
            height: 55px;
            color: white;
            font-size: 1.3rem;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 5px 20px rgba(52, 152, 219, 0.3);
        }

        .control-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 30px rgba(52, 152, 219, 0.4);
        }

        .control-btn.active {
            background: linear-gradient(135deg, #e74c3c, #c0392b);
            box-shadow: 0 5px 20px rgba(231, 76, 60, 0.3);
        }

        .control-btn.muted {
            background: linear-gradient(135deg, #95a5a6, #7f8c8d);
        }

        .conference-room {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            min-height: 650px;
            padding: 40px;
        }

        .conference-table {
            position: relative;
            width: 500px;
            height: 700px;
            border-radius: 40px;
            backdrop-filter: blur(15px);
            border: 2px solid rgba(255, 255, 255, 0.3);
            overflow: visible;
        }

        .table-surface {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 82%;
            height: 80%;
            background: #16324e;
            border-radius: 25px;
            box-shadow: inset 0 8px 25px rgba(0, 0, 0, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.4rem;
            color: #fff;
            font-weight: 600;
            text-align: center;
        }

        .logo-watermark {
            color: #fff;
            font-size: 3rem;
        }

        .participant {
            position: absolute;
            height: 50px;
            width: 50px;
            cursor: pointer;
            border-radius: 50%;
            transition: all 0.3s ease;
            overflow: visible;
        }

        .participant:hover {
            transform: scale(1.1);
        }

        .participant-avatar.speaking {
            border-color: #2ecc71;
            box-shadow: 0 0 0 4px rgba(46, 204, 113, 0.3), 0 10px 30px rgba(0, 0, 0, 0.15);
            animation: pulse-speaking 1.5s infinite;
        }

        @keyframes pulse-speaking {
            0%, 100% { box-shadow: 0 0 0 4px rgba(46, 204, 113, 0.3), 0 10px 30px rgba(0, 0, 0, 0.15); }
            50% { box-shadow: 0 0 0 8px rgba(46, 204, 113, 0.5), 0 15px 40px rgba(0, 0, 0, 0.2); }
        }

        .participant-avatar {
            z-index: 100;
            height: 50px;
            width: 50px;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            border-radius: 50%;
            background: linear-gradient(135deg, #3498db, #2980b9);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            position: absolute;
            font-size: 1rem;
            margin-bottom: 5px;
        }
        .participant-avatar.one,.participant-avatar.two,.participant-avatar.three,.participant-avatar.four,.participant-avatar.five{
            transform:unset;
            left:99%;
            top:35%;
        }
        .participant-avatar.six,.participant-avatar.seven,.participant-avatar.eight,.participant-avatar.nine,.participant-avatar.ten{
            transform:unset;
            left:65%;
            top:33%;
        }

        .participant-name {
            font-size: 0.7rem;
            font-weight: 600;
            color: #2c3e50;
            text-align: center;
            max-width: 80px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .participant-status {
            position: absolute;
            top: -5px;
            right: -5px;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            background: #2ecc71;
            border: 3px solid white;
            display: none;
        }

        .participant-avatar.speaking .participant-status {
            display: block;
            animation: blink 1s infinite;
        }

        @keyframes blink {
            0%, 50% { opacity: 1; }
            51%, 100% { opacity: 0.3; }
        }

        .participant:nth-child(1) { top: -45px; left: 50%; transform: translateX(-50%); }
        .participant:nth-child(2) { bottom: 6px; left: 50%; transform: translateX(-50%); }
        
        .participant:nth-child(3) { top: 70px; left: -68px; }
        .participant:nth-child(4) { top: 170px; left: -68px; }
        .participant:nth-child(5) { top: 270px; left: -68px; }
        .participant:nth-child(6) { top: 370px; left: -68px; }
        .participant:nth-child(7) { top: 470px; left: -68px; }
        
        .participant:nth-child(8) { top: 70px; right: 12px; }
        .participant:nth-child(9) { top: 170px; right: 12px; }
        .participant:nth-child(10) { top: 270px; right: 12px; }
        .participant:nth-child(11) { top: 370px; right: 12px; }
        .participant:nth-child(12) { top: 470px; right: 12px; }

        .tooltip-custom {
            position: absolute;
            background: rgba(46, 204, 113, 0.95);
            color: white;
            padding: 8px 12px;
            border-radius: 8px;
            font-size: 0.85rem;
            font-weight: 600;
            white-space: nowrap;
            z-index: 1000;
            opacity: 0;
            pointer-events: none;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .tooltip-custom.show {
            opacity: 1;
        }

        .tooltip-custom::after {
            content: '';
            position: absolute;
            top: 100%;
            left: 50%;
            transform: translateX(-50%);
            border: 5px solid transparent;
            border-top-color: rgba(46, 204, 113, 0.95);
        }
        .participant_image{
            height: 100px;
            width: 100px;
            left: 50%;
            transform: translate(-50%, -10px);
        }
        .participant_image.one, .participant_image.two, .participant_image.three, .participant_image.four,.participant_image.five{
            transform:rotate(90deg);
            height:80px;
            width:80px;
        }
        .participant_image.two,.participant_image.three,.participant_image.four,.participant_image.five{
            transform:rotate(90deg);
        }
        .participant_image.six,.participant_image.seven,.participant_image.eight,.participant_image.nine,.participant_image.ten{
            transform:rotate(270deg);
            height:80px;
            width:80px;
        }
        @media (max-width: 768px) {
            .visual_meeting_container {
                padding: 15px;
            }
            
            .conference-table {
                width: 90%;
                height: 400px;
            }
            
            .participant {
                width: 70px;
                height: 70px;
            }
            
            .participant-avatar {
                width: 40px;
                height: 40px;
                font-size: 1rem;
            }
            
            .meeting-details h2 {
                font-size: 1.5rem;
            }
        }

        .fade-in {
            animation: fadeIn 0.8s ease-in;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>

<div class="main-content app-content">
    <div class="visual_meeting_container">
        <!-- Meeting Header -->
        <!-- <div class="meeting-header fade-in">
            <div class="meeting-info">
                <div class="meeting-details">
                    <h2><i class="fas fa-video me-3"></i>TeleCall Pro Conference</h2>
                    <div class="meeting-id">
                        <i class="fas fa-link"></i>
                        Meeting ID: TC-2025-VIP-001
                    </div>
                </div>
                <div class="participants-count">
                    <i class="fas fa-users"></i>
                    <span id="participantCount">12 Participants</span>
                </div>
                <div class="meeting-controls">
                    <button class="control-btn" id="micBtn" title="Microphone">
                        <i class="fas fa-microphone"></i>
                    </button>
                    <button class="control-btn" id="cameraBtn" title="Camera">
                        <i class="fas fa-video"></i>
                    </button>
                    <button class="control-btn" id="screenBtn" title="Screen Share">
                        <i class="fas fa-desktop"></i>
                    </button>
                    <button class="control-btn active" id="endBtn" title="End Call">
                        <i class="fas fa-phone-slash"></i>
                    </button>
                </div>
            </div>
        </div> -->

        <!-- Conference Room -->
        <div class="conference-room">
            <div class="conference-table ">
                <div class="table-surface">
                    <div class="logo-watermark mx-2">
                        <i class="fas fa-phone-alt"></i>
                    </div>
                    TeleCall Pro<br>Conference
                </div>

                <!-- Participants around the table -->
                <div class="participant" data-name="John Smith" data-role="Host">
                    <div class="participant-avatar">JS</div>
                    <div class="position-absolute participant_image"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                    <div class="participant-status"></div>
                </div>

                <div class="participant" data-name="Sarah Johnson" data-role="Presenter">
                    <div class="participant-avatar one">SJ
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image one"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                </div>

                <div class="participant" data-name="Mike Chen" data-role="Sales">
                    <div class="participant-avatar two">MC
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image two"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                </div>

                <div class="participant" data-name="Emily Davis" data-role="Manager">
                    <div class="participant-avatar three">ED
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image three"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                </div>

                <div class="participant" data-name="Robert Wilson" data-role="Client">
                    <div class="participant-avatar four">RW
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image four"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                </div>

                <div class="participant" data-name="Lisa Brown" data-role="Support">
                    <div class="participant-avatar five">LB
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image five"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>

                </div>

                <div class="participant" data-name="David Lee" data-role="Tech">
                    <div class="participant-avatar six">DL
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image six"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                </div>

                <div class="participant" data-name="Anna Garcia" data-role="Marketing">
                    <div class="participant-avatar seven">AG
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image seven"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                </div>

                <div class="participant" data-name="Tom Anderson" data-role="Lead">
                    <div class="participant-avatar eight">TA
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image eight"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                </div>

                <div class="participant" data-name="Rachel White" data-role="Analyst">
                    <div class="participant-avatar nine">RW
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image nine"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                </div>

                <div class="participant" data-name="Kevin Moore" data-role="Designer">
                    <div class="participant-avatar ten">KM
                        <div class="participant-status"></div>
                    </div>
                    <div class="position-absolute participant_image ten"><img src="https://singimarketing.com/public/assets/admin/images/chair_image.png"></div>
                </div>
            </div>
        </div>

        <!-- Custom Tooltip -->
        <div class="tooltip-custom" id="customTooltip"></div>
    </div>
</div> 
@endsection
@section('js')
<script>
        class ConferenceMeeting {
            constructor() {
                this.participants = document.querySelectorAll('.participant');
                this.participantsAvatar = document.querySelectorAll('.participant-avatar');
                this.tooltip = document.getElementById('customTooltip');
                this.currentSpeaker = null;
                this.speakingInterval = null;
                
                this.init();
            }

            init() {
                this.setupParticipantEvents();
                this.startRandomSpeaking();
            }

            setupParticipantEvents() {
                this.participantsAvatar.forEach(participant => {
                    participant.addEventListener('mouseenter', (e) => {
                        this.showTooltip(e.target);
                    });

                    participant.addEventListener('mouseleave', () => {
                        this.hideTooltip();
                    });

                    participant.addEventListener('click', (e) => {
                        this.toggleSpeaking(e.target);
                    });
                });
            }

            showTooltip(participantsAvatar) {
                const participantElement = participantsAvatar.closest('.participant');
                const name = participantElement?.dataset.name || 'Unknown';
                const role = participantElement?.dataset.role || 'Unknown';
                const isSpeaking = participantsAvatar.classList.contains('speaking');

                let tooltipText = `${name} (${role})`;
                if (isSpeaking) {
                    tooltipText += ' - Currently Speaking';
                }

                this.tooltip.textContent = tooltipText;
                this.tooltip.className = 'tooltip-custom show';

                if (isSpeaking) {
                    this.tooltip.style.background = 'rgba(46, 204, 113, 0.95)';
                } else {
                    this.tooltip.style.background = 'rgba(52, 73, 94, 0.95)';
                }

                const rect = participantsAvatar.getBoundingClientRect();
                const tooltipRect = this.tooltip.getBoundingClientRect();

                this.tooltip.style.left = `${rect.left + rect.width / 2 - tooltipRect.width / 2}px`;
                this.tooltip.style.top = `${rect.top - tooltipRect.height - 10}px`;
            }

            hideTooltip() {
                this.tooltip.classList.remove('show');
            }

            toggleSpeaking(participantsAvatar) {
                this.participantsAvatar.forEach(p => p.classList.remove('speaking'));
                
                participantsAvatar.classList.add('speaking');
                this.currentSpeaker = participantsAvatar;

                if (this.tooltip.classList.contains('show')) {
                    this.showTooltip(participantsAvatar);
                }
            }

            startRandomSpeaking() {
                this.speakingInterval = setInterval(() => {
                    const randomIndex = Math.floor(Math.random() * this.participantsAvatar.length);
                    const randomParticipant = this.participantsAvatar[randomIndex];
                    
                    this.participantsAvatar.forEach(p => p.classList.remove('speaking'));
                    
                    randomParticipant.classList.add('speaking');
                    this.currentSpeaker = randomParticipant;

                    setTimeout(() => {
                        randomParticipant.classList.remove('speaking');
                    }, Math.random() * 3000 + 2000);

                }, Math.random() * 5000 + 3000);
            }

            endMeeting() {
                if (confirm('Are you sure you want to end the meeting?')) {
                    clearInterval(this.speakingInterval);
                    alert('Meeting ended. Thank you for using TeleCall Pro!');
                }
            }

            addParticipant(name, role) {
                const participant = document.createElement('div');
                participant.className = 'participant fade-in';
                participant.dataset.name = name;
                participant.dataset.role = role;
                
                const initials = name.split(' ').map(n => n[0]).join('');
                participant.innerHTML = `
                    <div class="participant-avatar">${initials}</div>
                    <div class="participant-name">${name.split(' ')[0]} ${name.split(' ')[1] ? name.split(' ')[1][0] + '.' : ''}</div>
                    <div class="participant-status"></div>
                `;

                document.querySelector('.conference-table').appendChild(participant);
                this.updateParticipantCount();
            }

            removeParticipant(participantElement) {
                participantElement.remove();
                this.updateParticipantCount();
            }

            updateParticipantCount() {
                const count = document.querySelectorAll('.participant').length;
                document.getElementById('participantCount').textContent = `${count} Participants`;
            }
        }

        document.addEventListener('DOMContentLoaded', () => {
            const meeting = new ConferenceMeeting();
        });
    </script>
@endsection

