
<div class="row">

      <div class="row g-3 m-2 mb-2">

            <div class="col-md-6">
                <label class="form-label">Vendor Name <span class="text-danger">*</span></label>
                <input type="text" name="name" class="form-control"
                        value="{{ old('name', $vendor->name ?? '') }}" required>
                @error('name')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
            </div>
            <div class="col-md-6">
                <label class="form-label">Billing Name <span class="text-danger">*</span></label>
                <input type="text" name="billing_name" class="form-control"
                        value="{{ old('billing_name', $vendor->billing_name ?? '') }}">
                @error('billing_name')
                    <div class="invalid-feedback">
                        {{ $message }}
                    </div>
                @enderror
            </div>

            <div class="col-md-4">
                <label class="form-label">Group Name</label>
                <input type="text" name="group_name" class="form-control"
                        value="{{ old('group_name', $vendor->group_name ?? '') }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">Opening Balance</label>
                <input type="number" step="0.01" name="opening_balance" class="form-control"
                        value="{{ old('opening_balance', $vendor->opening_balance ?? 0) }}">
            </div>
            <div class="col-md-2">
                <label class="form-label">Last Year Closing</label>
                <input type="number" step="0.01" name="last_year_closing" class="form-control"
                        value="{{ old('last_year_closing', $vendor->last_year_closing ?? 0) }}">
            </div>

    </div>


    <ul class="nav nav-tabs mb-3 mt-2 custom_tab_nav" id="accountTabs" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" id="office-tab" data-bs-toggle="tab"
                    data-bs-target="#office" type="button">Office Details</button>
        </li>
        <li class="nav-item">
            <button class="nav-link" id="other-tab" data-bs-toggle="tab"
                    data-bs-target="#other" type="button">Other Details</button>
        </li>
        <li class="nav-item">
            <button class="nav-link" id="export-tab" data-bs-toggle="tab"
                    data-bs-target="#export" type="button">Export Details</button>
        </li>
    </ul>


    <div class="tab-content border rounded p-3 bg-light" id="accountTabsContent">
        {{-- ================= OFFICE DETAILS ================= --}}
        <div class="tab-pane fade show active" id="office">
            <div class="row g-4">
                <!-- LEFT SIDE -->
                <div class="col-md-6 border-end pe-md-4">

                    <div class="mb-3">
                        <label class="form-label">Short Name <span class="text-danger">*</span></label>
                        <input type="text" name="short_name" class="form-control"
                            value="{{ old('short_name', $vendor->short_name ?? '') }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Kind Atten.</label>
                        <input type="text" name="kind_atten" class="form-control"
                            value="{{ old('kind_atten', $vendor->kind_atten ?? '') }}">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Address</label>
                        <textarea name="address" class="form-control" rows="6">{{ old('address', $vendor->address ?? '') }}</textarea>
                    </div>

                </div>

                <!-- RIGHT SIDE -->
                <div class="col-md-6 ps-md-4">

                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">City</label>
                            <input type="text" name="city" class="form-control"
                                value="{{ old('city', $vendor->city ?? '') }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">District</label>
                            <input type="text" name="district" class="form-control"
                                value="{{ old('district', $vendor->district ?? '') }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">State</label>
                            <input type="text" name="state" class="form-control"
                                value="{{ old('state', $vendor->state ?? '') }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Pincode</label>
                            <input type="text" name="pin_code" class="form-control"
                                value="{{ old('pin_code', $vendor->pin_code ?? '') }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Email <span class="text-danger">*</span></label>
                            <input type="email" name="email" class="form-control"
                                value="{{ old('email', $vendor->email ?? '') }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">PAN No</label>
                            <input type="text" name="pan_no" class="form-control"
                                value="{{ old('pan_no', $vendor->pan_no ?? '') }}">
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Mobile</label>
                            <input type="text" name="mobile" class="form-control"
                                value="{{ old('mobile', $vendor->mobile ?? '') }}">
                        </div>
                    </div>

                </div>
            </div>
        </div>

        {{-- ================= OTHER DETAILS ================= --}}
        <div class="tab-pane fade" id="other">
            <div class="row g-4">
                <!-- LEFT SIDE -->
                <div class="col-md-6 border-end pe-md-4">
                    <div class="mb-3">
                        <label class="form-label">Area Name</label>
                        <input type="text" name="area_name" class="form-control"
                            value="{{ old('area_name', $vendor->area_name ?? '') }}">
                    </div>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Bank Name</label>
                            <input type="text" name="bank_name" class="form-control"
                                value="{{ old('bank_name', $vendor->bank_name ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Account No</label>
                            <input type="text" name="account_no" class="form-control"
                                value="{{ old('account_no', $vendor->account_no ?? '') }}">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">IFSC Code</label>
                            <input type="text" name="ifsc_code" class="form-control"
                                value="{{ old('ifsc_code', $vendor->ifsc_code ?? '') }}">
                        </div>
                    </div>

                </div>

                <!-- RIGHT SIDE -->
                <div class="col-md-6 ps-md-4">

                    <div class="row g-3">
                        <div class="col-md-6 col-xxl-4">
                            <label class="form-label">GST No</label>
                            <input type="text" name="gst_no" class="form-control"
                                value="{{ old('gst_no', $vendor->gst_no ?? '') }}">
                        </div>

                        <div class="col-md-6 col-xxl-4">
                            <label class="form-label">Due Days</label>
                            <input type="number" name="due_days" class="form-control"
                                value="{{ old('due_days', $vendor->due_days ?? 0) }}">
                        </div>

                        <div class="col-md-6 col-xxl-4">
                            <label class="form-label">Lock By</label>
                            <select name="lock_by" class="form-select">
                                @foreach(['No','Yes'] as $opt)
                                    <option value="{{ $opt }}" {{ old('lock_by', $vendor->lock_by ?? '') == $opt ? 'selected' : '' }}>
                                        {{ $opt }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-6 col-xxl-4">
                            <label class="form-label">Days Limit</label>
                            <input type="number" name="days_limit" class="form-control"
                                value="{{ old('days_limit', $vendor->days_limit ?? 0) }}">
                        </div>

                        <div class="col-md-6 col-xxl-4">
                            <label class="form-label">Rs Limit</label>
                            <input type="number" step="0.01" name="rs_limit" class="form-control"
                                value="{{ old('rs_limit', $vendor->rs_limit ?? 0) }}">
                        </div>

                        <div class="col-md-6 col-xxl-4">
                            <label class="form-label">P.F. %</label>
                            <input type="number" step="0.001" name="pf_percent" class="form-control"
                                value="{{ old('pf_percent', $vendor->pf_percent ?? 0) }}">
                        </div>
                    </div>

                </div>
            </div>
        </div>

        {{-- ================= EXPORT DETAILS ================= --}}
        <div class="tab-pane fade" id="export">
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Country Name</label>
                    <input type="text" name="country_name" class="form-control"
                           value="{{ old('country_name', $vendor->country_name ?? '') }}">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Credit Condition</label>
                    <input type="text" name="credit_condition" class="form-control"
                           value="{{ old('credit_condition', $vendor->credit_condition ?? '') }}">
                </div>

                <div class="col-12 mt-3">
                    <h6>By Sea</h6>
                    <div class="row g-2">
                        <div class="col-md-3"><input type="text" name="sea_loading" placeholder="Loading" class="form-control" value="{{ old('sea_loading', $vendor->sea_loading ?? '') }}"></div>
                        <div class="col-md-3"><input type="text" name="sea_discharge" placeholder="Discharge" class="form-control" value="{{ old('sea_discharge', $vendor->sea_discharge ?? '') }}"></div>
                        <div class="col-md-3"><input type="text" name="sea_destination" placeholder="Destination" class="form-control" value="{{ old('sea_destination', $vendor->sea_destination ?? '') }}"></div>
                        <div class="col-md-3"><input type="text" name="sea_condition1" placeholder="Condition 1" class="form-control" value="{{ old('sea_condition1', $vendor->sea_condition1 ?? '') }}"></div>
                    </div>
                </div>

                <div class="col-12 mt-3">
                    <h6>By Road</h6>
                    <div class="row g-2">
                        <div class="col-md-3"><input type="text" name="road_loading" placeholder="Loading" class="form-control" value="{{ old('road_loading', $vendor->road_loading ?? '') }}"></div>
                        <div class="col-md-3"><input type="text" name="road_discharge" placeholder="Discharge" class="form-control" value="{{ old('road_discharge', $vendor->road_discharge ?? '') }}"></div>
                        <div class="col-md-3"><input type="text" name="road_destination" placeholder="Destination" class="form-control" value="{{ old('road_destination', $vendor->road_destination ?? '') }}"></div>
                        <div class="col-md-3"><input type="text" name="road_condition1" placeholder="Condition 1" class="form-control" value="{{ old('road_condition1', $vendor->road_condition1 ?? '') }}"></div>
                    </div>
                </div>

                <div class="col-12 mt-3">
                    <h6>By Air</h6>
                    <div class="row g-2">
                        <div class="col-md-3"><input type="text" name="air_loading" placeholder="Loading" class="form-control" value="{{ old('air_loading', $vendor->air_loading ?? '') }}"></div>
                        <div class="col-md-3"><input type="text" name="air_discharge" placeholder="Discharge" class="form-control" value="{{ old('air_discharge', $vendor->air_discharge ?? '') }}"></div>
                        <div class="col-md-3"><input type="text" name="air_destination" placeholder="Destination" class="form-control" value="{{ old('air_destination', $vendor->air_destination ?? '') }}"></div>
                        <div class="col-md-3"><input type="text" name="air_condition1" placeholder="Condition 1" class="form-control" value="{{ old('air_condition1', $vendor->air_condition1 ?? '') }}"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="text-end mt-4">
        <button type="submit" class="btn btn-primary px-4" id="submitBtn">
            {{ $vendor ? 'Update Vendor' : 'Save Vendor' }}
        </button>
        <a href="{{ route('admin.vendor.index') }}" class="btn btn-secondary">Cancel</a>
    </div>
</div>