@extends('admin.layout.app')

@section('content')
<div class="main-content app-content global">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">User Details</h4>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    @if(rolemanagement('User', 2))
                        <a href="{{ url('secure-dashboard/user/create') }}"><button type="button" class="btn btn-primary">Add User</button></a>
                    @endif
				 </div>
            </div>
        </div>
        <div>
            <ul class="nav nav-tabs mb-3" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="hr-tab" data-bs-toggle="tab" data-bs-target="#hr" type="button" role="tab" aria-controls="hr" aria-selected="true">
                    User Lists
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="chart-tab" data-bs-toggle="tab" data-bs-target="#chart" type="button" role="tab" aria-controls="chart" aria-selected="false">
                    Chart
                    </button>
                </li>
            </ul>
        </div>
        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="hr" role="tabpanel" aria-labelledby="list-home-list">
                <div class="row row-sm">
                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                        <div class="card">
                            <div class="card-header pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4 class="card-title mg-b-0">User Details</h4>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                        <thead>
                                            <tr>
                                                <th >Role</th>
                                                <th class="d-block">Name</th>
                                                <th >Mobile Number</th>
                                                <th >Email</th>
                                                <th >State</th>
                                                <th >City</th>
                                                <th >Status</th>
                                                <th >Created At</th>
                                                <th >Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                       
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade chart_container" id="chart" role="tabpanel" aria-labelledby="list-profile-list">
                <div class="card ">
                    <div class="card-header">
                    </div>
                    <div class="card-body ">
                        <div class="row g-4">
                            <div class="col-12 col-md-6 col-xxl-3">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5 class="card-title">Member Count by State</h5>
                                        <div class="chart-container">
                                            <canvas id="stateChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-12 col-md-6 col-xxl-3">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5 class="card-title">Member Count by Role</h5>
                                        <div class="chart-container">
                                            <canvas id="roleChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-12 col-md-6 col-xxl-3">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5 class="card-title">Account Status</h5>
                                        <div class="chart-container">
                                            <canvas id="statusChart"></canvas>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">User Details</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <div id="salesuser_detail_append"></div>
        </div>
        <div class="modal-footer">
             <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
</div>

<div class="modal fade" id="transferModal" tabindex="-1" aria-labelledby="transferModalLabel" aria-hidden="true" style="z-index: 99990 !important;">
    <div class="modal-dialog">
        <div class="modal-content rounded-3">
            <div class="modal-header">
                <h5 class="modal-title" id="transferModalLabel">Transfer Employee</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div class="modal-body">
                <div class="mb-3">
                    <label class="fw-bold">Select Transfer Type</label><br>
                    <input type="radio" name="transfer_type" id="transfer_employee" value="employee" checked>
                    <label for="transfer_employee">Employee</label>
                    <input type="radio" name="transfer_type" id="transfer_agency" value="agency" class="ms-3">
                    <label for="transfer_agency">Agency</label>
                </div>

                <div class="mb-3">
                    <label for="transfer_mobile" class="form-label">Mobile Number</label>
                    <input type="text" class="form-control" id="transfer_mobile" placeholder="Enter Mobile Number">
                </div>

                <div class="mb-3">
                    <label for="transfer_password" class="form-label">Password</label>
                    <input type="text" class="form-control" id="transfer_password" placeholder="Enter Password">
                </div>
            </div>

            <div class="modal-footer">
                <button type="button" id="transferBtn" class="btn btn-success">Transfer</button>
            </div>
        </div>
    </div>
</div>

@endsection
@section('js')
<script>
    // Chart.defaults.font.family = '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif';
    // Chart.defaults.plugins.legend.display = false;

    // let stateChart, roleChart, statusChart;

    /*function initializeCharts() {
        const stateCtx = document.getElementById('stateChart').getContext('2d');
        stateChart = new Chart(stateCtx, {
            type: 'doughnut',
            data: {
                labels: [],
                datasets: [{
                    data: [],
                    backgroundColor: ['#3B82F6', '#06B6D4', '#10B981', '#F59E0B', '#EF4444'],
                    borderWidth: 0,
                    cutout: '70%'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'bottom',
                        labels: {
                            usePointStyle: true,
                            padding: 20,
                            font: { size: 12 }
                        }
                    }
                }
            }
        });

        const roleCtx = document.getElementById('roleChart').getContext('2d');
        roleChart = new Chart(roleCtx, {
            type: 'bar',
            data: {
                labels: [],
                datasets: [{
                    data: [],
                    backgroundColor: ['#3B82F6', '#06B6D4', '#10B981', '#F59E0B', '#EF4444'],
                    borderRadius: 6,
                    borderSkipped: false,
                    maxBarThickness: 40
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: { display: false },
                        ticks: { display: false }
                    },
                    x: {
                        grid: { display: false },
                        ticks: {
                            font: { size: 10 },
                            callback: function(value, index, values) {
                                return index === Math.floor(values.length / 2) ? 'User Roles' : '';
                            }
                        }
                    }
                },
                plugins: {
                    legend: { display: false }
                }
            }
        });

        const statusCtx = document.getElementById('statusChart').getContext('2d');
        statusChart = new Chart(statusCtx, {
            type: 'doughnut',
            data: {
                labels: ['Active', 'Inactive'],
                datasets: [{
                    data: [0, 0],
                    backgroundColor: ['#3B82F6', '#F59E0B'],
                    borderWidth: 0,
                    cutout: '70%'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: true,
                        position: 'bottom',
                        labels: {
                            usePointStyle: true,
                            padding: 20,
                            font: { size: 12 }
                        }
                    }
                }
            }
        });
    }*/

    function updateCharts() {
        $.ajax({
            url: "{{ url('secure-dashboard/user') }}",
            method: 'GET',
            data: {
                _token: "{{ csrf_token() }}",
                chart_data: true
            },
            success: function(response) {
                const data = response.data;
                const stateCount = {};
                data.forEach(item => {
                    const stateName = item.state_id?.trim() || 'Unknown';
                    stateCount[stateName] = (stateCount[stateName] || 0) + 1;
                });

                if (Object.keys(stateCount).length === 0) {
                    stateChart.data.labels = ["No Data"];
                    stateChart.data.datasets[0].data = [1];
                    stateChart.data.datasets[0].backgroundColor = ['#E5E7EB'];
                } else {
                    stateChart.data.labels = Object.keys(stateCount);
                    stateChart.data.datasets[0].data = Object.values(stateCount);
                    stateChart.data.datasets[0].backgroundColor = ['#3B82F6', '#06B6D4', '#10B981', '#F59E0B', '#EF4444'];
                }
                stateChart.update();

                const roleCount = {};
                data.forEach(item => {
                    const roleName = item.role?.trim() || 'Unknown';
                    roleCount[roleName] = (roleCount[roleName] || 0) + 1;
                });

                roleChart.data.labels = Object.keys(roleCount);
                roleChart.data.datasets[0].data = Object.values(roleCount);
                roleChart.data.datasets[0].backgroundColor = Object.keys(roleCount).map((_, i) => {
                    const colors = ['#3B82F6', '#06B6D4', '#10B981', '#F59E0B', '#EF4444'];
                    return colors[i % colors.length];
                });

                const statusCount = { active: 0, inactive: 0 };
                data.forEach(item => {
                    const statusStr = item.status?.toLowerCase() || '';
                    if (statusStr.includes('active')) {
                        statusCount.active++;
                    } else {
                        statusCount.inactive++;
                    }
                });

                if (statusCount.active === 0 && statusCount.inactive === 0) {
                    statusChart.data.labels = ['No Data'];
                    statusChart.data.datasets[0].data = [1];
                    statusChart.data.datasets[0].backgroundColor = ['#E5E7EB'];
                } else {
                    statusChart.data.labels = ['Active', 'Inactive'];
                    statusChart.data.datasets[0].data = [statusCount.active, statusCount.inactive];
                    statusChart.data.datasets[0].backgroundColor = ['#3B82F6', '#F59E0B'];
                }
                statusChart.update();

            },
            error: function(xhr, status, error) {
                console.error('Error fetching chart data:', error);
                console.log('Response:', xhr.responseText);
            }
        });
    }
</script>
<script>
jQuery(document).ready(function () {
    // initializeCharts();
    // updateCharts();
    var oTable = $('#example1').DataTable({
            "responsive": false, "lengthChange": true, "autoWidth": false, "pageLength": 10,
            "buttons": [],
            stateSave: true,
            processing: true,
            serverSide: true,
            dom:'lBfrtip',
            ajax:{ 
                url: "{{ url('secure-dashboard/user') }}",
                type: 'get',
                data: function (d) {
                    d._token = "{{ csrf_token() }}";
                },
                
                },
            columns: [
                {data: 'role', name: 'role', className: 'text-center ', orderable: false, searchable: false, defaultContent:'-'},
                {data: 'name', name: 'name', className: 'text-center user_body custom_width', orderable: false, searchable: false, defaultContent:'-'},
                {data: 'mobile', name: 'mobile', className: 'text-center', orderable: false, searchable: false, defaultContent:'-'},
                {data: 'email', name: 'email', className: 'text-center', orderable: false, searchable: false, defaultContent:'-'},
                {data: 'state_id', name: 'state_id', className: 'text-center', orderable: false, searchable: false, defaultContent:'-'},
                {data: 'city', name: 'city', className: 'text-center', orderable: false, searchable: false, defaultContent:'-'},
                {data: 'status', name: 'status', className: 'text-center check-align-center', orderable: false, searchable: false, defaultContent:'-'},
                {data: 'created_at', name: 'created_at', className: 'text-center custom_width', orderable: false, searchable: false, defaultContent:'-'},
                {data: 'action', name: 'action', className: 'text-center', orderable: false, searchable: false, defaultContent:'-'},
            ]
            
    });
    $("body").on("change", "#statusToggle", function () {
        var toggleButton = $(this);
        var id = $(this).data('id');
        var currentStatus = jQuery(this).data('status');
        Swal.fire({
            title: "Are you sure?",
            text: "you want to change this status ?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, confirm it!"
            }).then((result) => {
            if (result.isConfirmed) {
                jQuery.ajax({
                    url: "{{ url('secure-dashboard/user') }}/" + id ,
                    type: 'PUT',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "id": id,
                        "currentStatus": currentStatus,
                    },
                    success: function (data) {
                        if(data.success == true){
                            toastr.success(data.message);
                            oTable.ajax.reload();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            }else{
                // oTable.ajax.reload();
                if(currentStatus == 'Active'){
                    $(this).prop('checked',true);
                }else{
                    $(this).prop('checked',false);
                }
            }
        });
    });
    $("body").on("click", ".data-delete", function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                    jQuery.ajax({
                        type: "DELETE",
                        url: "{{ url('secure-dashboard/user')  }}/" + id,
                        data: {
                            id: id,
                            _token: "{{ csrf_token() }}"
                        },
                        dataType: 'json',
                        beforeSend: function () {
                            // Use the stored reference to the clicked element
                            obj.attr('disabled', true);
                            jQuery('.alert .msg-content').html('');
                            jQuery('.alert').hide();
                        },
                        success: function (resp) {
                            if(resp.success == true)
                            {
                                toastr.success(resp.message);
                                oTable.ajax.reload();
                            }
                        }
                        
                    });
            }else{
                oTable.ajax.reload();
            }
        });
    });
});

let transferUserName = null;

$(document).on("blur", "#transfer_mobile", function () {
    let transfer_type = $("input[name='transfer_type']:checked").val();
    let mobile = $("#transfer_mobile").val();

    if (mobile === "") return;

    $.ajax({
        url: "{{ url('secure-dashboard/check-user-mobile') }}",
        type: "POST",
        data: {
            _token: "{{ csrf_token() }}",
            transfer_type: transfer_type,
            mobile: mobile
        },
        success: function (response) {
            if (response.success) {
                transferUserName = response.name;
                toastr.success(`${response.name} found for ${transfer_type}.`);
            } else {
                transferUserName = null;
                toastr.error(response.message);
            }
        },
        error: function () {
            transferUserName = null;
            toastr.error("Error checking mobile number.");
        }
    });
});


$(document).on("click", "#transferBtn", function () {
    let transfer_type = $("input[name='transfer_type']:checked").val();
    let mobile = $("#transfer_mobile").val();
    let password = $("#transfer_password").val();

    if (mobile === "" || password === "") {
        toastr.error("Please enter mobile number and password.");
        return;
    }

    if (!transferUserName) {
        toastr.error("Invalid mobile number. Please enter a valid one.");
        return;
    }

    let typeLabel = (transfer_type === "employee") ? "Employee" : "Agency";

    Swal.fire({
        title: "Are you sure?",
        text: `Do you want to transfer ${transferUserName} (${typeLabel}) under your account?`,
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, Transfer it!"
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "{{ url('secure-dashboard/transfer-employee') }}",
                type: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    transfer_type: transfer_type,
                    mobile: mobile,
                    password: password
                },
                success: function (response) {
                    if (response.success) {
                        toastr.success(response.message);
                        $("#transferModal").modal('hide');
                    } else {
                        toastr.error(response.message);
                    }
                },
                error: function (xhr) {
                    let err = "Something went wrong!";
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        err = xhr.responseJSON.message;
                    }
                    toastr.error(err);
                }
            });
        }
    });
});

$('#transferModal').on('hidden.bs.modal', function () {
    $('#transfer_mobile').val('');
    $('#transfer_password').val('');
});
</script>
@endsection