@extends('admin.layout.app')
@section('content')
<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">User</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ Create User</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <p class="mb-2"></p>
                    </div>
                 
                    {{ html()->modelForm($user ?? new App\Models\User, $user ? 'PUT' : 'POST', $user ? route('admin.user.update', $user->id) : route('admin.user.store'))
                        ->attribute('enctype', 'multipart/form-data')->attribute('id', 'userForm')->open() }}
                    
                        <div class="card-body pt-0">
                            @include('admin.user.form')
                        </div>
                        <div class="card-footer ">
                            <a href="{{url('secure-dashboard/user')}}" class="btn btn-secondary">Back</a>
                            <button type="submit" id="submit" class="btn btn-primary float-end">Submit</button>
                        </div>
                    {{ html()->closeModelForm() }}

                </div>
            </div>
        </div>
	</div>
</div>

@endsection

@section('js')
<script>

</script>
@endsection
