@extends('admin.layout.app')
@section('content')
<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Tax Details</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ @if(empty($category)) New   @else Edit @endif Tax Details</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">@if(empty($tax)) New   @else Edit @endif Tax Details</h4>
                        <p class="mb-2"></p>
                    </div>
                 
                    {{ html()->modelForm($tax ?? new App\Models\Tax, $tax ? 'PUT' : 'POST', $tax ? route('tax.update', $tax->id) : route('tax.store'))->open() }}
                        <div class="card-body pt-0">
                            @include('admin.tax.form')
                        </div>
                        <div class="card-footer ">
                            <a href="{{url('admin/tax')}}" class="btn btn-secondary mb-3">Back</a>
                            {{ html()->submit('Submit')->class('btn btn-primary float-end mb-3') }}
                        </div>
                    {{ html()->closeModelForm() }}

                </div>
            </div>
        </div>
	</div>
</div>

@endsection