@extends('admin.layout.app')

@section('content')
<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="left-content">
                @php  
                    $user = Auth::guard('admin')->user();
                @endphp
              
                <div>
                    <h2 class="main-content-title tx-24 mg-b-1 mg-b-lg-1 animate-charcter" >Hi,{{$user->name}} !</h2>
                </div>
            </div>
        </div>
    </div>


    <div class="container-fluid my-2">
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">Admin</h2>
            </div>
            <div class="card-body">
                <div class="settings_container_box row">
                    @if(rolemanagement('Category', 1))
                    <div class="col-md-4 col-xl-3 mb-3">
                        <a class=" {{request()->is('admin/category*') ?'active':''}} w-100" href="{{route('admin.category.index')}}" >
                            <div class="settings_container_box_item px-3 py-2 rounded">
                                <h3><i class="fas fa-layer-group fa-lg"></i> Category</h3>
                            </div>
                        </a>
                    </div>
                    @endif
                    @if(rolemanagement('Purchase Group', 1))
                    <div class="col-md-4 col-xl-3 mb-3">
                        <a class=" {{request()->is('admin/purchasegroup*') ?'active':''}} w-100" href="{{route('admin.purchasegroup.index')}}" >
                            <div class="settings_container_box_item px-3 py-2 rounded">
                                <h3> <i class="fas fa-shopping-cart fa-lg"></i> Purchase Group </h3>
                            </div>
                        </a>
                    </div>
                    @endif
                    @if(rolemanagement('Permission', 1))
                    <div class="col-md-4 col-xl-3 mb-3">
                        <a class=" {{request()->is('admin/permission*') ?'active':''}} w-100" href="{{route('admin.permission.index')}}" >
                            <div class="settings_container_box_item px-3 py-2 rounded">
                                <h3> <i class="fas fa-lock "></i> Permission </h3>
                            </div>
                        </a>
                    </div>
                    @endif
                    @if(rolemanagement('Role', 1))
                    <div class="col-md-4 col-xl-3 mb-3">
                        <a class="{{request()->is('admin/role*') ?'active':''}} w-100" href="{{route('admin.role.index')}}" >
                            <div class="settings_container_box_item px-3 py-2 rounded">
                                <h3> <i class="fab fa-critical-role "></i> Role</h3>
                            </div>
                        </a>
                    </div>
                    @endif
                    @if(rolemanagement('Site Setting', 1)) 
                        <div class="col-md-4 col-xl-3 mb-3">
                            <a class="{{url()->current() == url('secure-dashboard/sitesetting')?'active':''}} w-100" data-bs-toggle="slide" href="{{route('admin.sitesetting')}}">
                                <div class="settings_container_box_item px-3 py-2 rounded">
                                    <h3> <i class="fas fa-cog "></i> Site Setting</h3>
                                </div>
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
<script>
    


 


function encrypt(password, key) {
    var fromChar;
    var toChar;
    var l_length;
    var l_count = 0;
    if (password.length > key.length) {
        l_length = password.length;
    } else {
        l_length = key.length;
    }
    var encryptedString = new Array(l_length);
    var retString = "";
    for (i = 0; i < l_length; i++) {
        l_count++;
        if (i >= password.length) {
            fromChar = 10;
        } else {
            fromChar = password.charCodeAt(i);
        }
        if (i >= key.length) {
            toChar = 9;
        } else {
            toChar = key.charCodeAt(i);
        }
        if (toChar == 9) {
            encryptedString[i] = toChar;
        } else {
            if (fromChar == 10) {
                l_count--;
                break;
            }
        }
        encryptedString[i] = fromChar ^ toChar;
        if (i == 0) {
            retString = encryptedString[i];
        } else {
            retString = retString + "a" + encryptedString[i];
        }
    }
    return retString;
}
</script>
@endsection