@extends('admin.layout.app')
@section('content')
<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Section Details</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ @if(empty($section)) New   @else Edit @endif Section Details</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">@if(empty($section)) New   @else Edit @endif Section Details</h4>
                        <p class="mb-2"></p>
                    </div>
                 
                    {{ html()->modelForm($section ?? new App\Models\Section, $section ? 'PUT' : 'POST', $section ? route('section.update', $section->id) : route('section.store'))
                    ->attribute('enctype', 'multipart/form-data')
                    ->open() }}
                        <div class="card-body pt-0">
                            @include('admin.section.form')
                        </div>
                        <div class="card-footer ">
                            <a href="{{url('admin/section')}}" class="btn btn-secondary mb-3">Back</a>
                            {{ html()->submit('Submit')->class('btn btn-primary float-end mb-3') }}
                        </div>
                    {{ html()->closeModelForm() }}

                </div>
            </div>
        </div>
	</div>
</div>

@endsection