<form id="editform">
    <div class="modal-body">
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="">Name <span class="text-danger">*</span></label>
                <input type="text" name="name" class="form-control" id="name" value="{{$record->name}}" >
                <input type="hidden" name="id" class="form-control" id="id" value="{{$record->id}}" >
            </div>
            <div class="col-md-6 mb-3">
                <label>Search Permission</label>
                <input type="text" name="search" class="form-control" id="search-role" placeholder="Search Permission">
            </div>
            <div class="col-md-12 d-flex align-items-center justify-content-between">
                <div class=" mb-4">
                    <label class="control-label" style="font-size:18px;">Select Permissions <span class="text-danger">*</span></label>
                    <br><a class="btn btn-primary btn-sm text-white role-font" id="check_all" >Check All</a>
                    <a class="btn btn-primary btn-sm text-white role-font" id="uncheck_all" >Uncheck All</a><br>
                </div >
                <div class="">
                    <button type="submit" id="submit"  class="btn btn-primary" >Submit</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
            <div class="col-md-12">
                @php $permissions = App\Models\Permission::get(); @endphp
                <div class="row">
                    @foreach($permissions as $key => $permission)
                        <div class="permission-group row mb-2" data-name="{{ strtolower($permission->name) }}">
                            <div class="col-md-3 mt-2">
                                <div class="form-check">
                                    <input name="modul_name[{{$key}}]" type="checkbox" class="checkbox roalchack"
                                        value="{{$permission->name}}" id="checkebox-{{$key}}"
                                        @foreach ($permissionsArray as $perm)
                                            @if(array_key_exists($permission->name, $perm)) checked @endif
                                        @endforeach>
                                    <label class="checkbox-inline role-font-2" for="checkebox-{{$key}}">
                                        {{$permission->name}}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-9 mt-2">
                                @php
                                    $permission_types = explode(',', $permission->permission_type_id);
                                @endphp
                                <div class="row">
                                    @foreach($permission_types as $ke => $permission_type)
                                        @php 
                                            $permission_type_name = App\Models\PermissionType::find($permission_type);
                                            $isChecked = false;
                                            foreach ($permissionsArray as $perm) {
                                                if (array_key_exists($permission->name, $perm) && in_array($permission_type, $perm[$permission->name])) {
                                                    $isChecked = true;
                                                    break;
                                                }
                                            }
                                        @endphp
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input name="permission_id[{{$key}}][]" type="checkbox"
                                                    id="flexCheckDefault-{{$ke}}-{{$permission->name}}" class="checkbox roalchack"
                                                    value="{{$permission_type}}" @if($isChecked) checked @endif>
                                                <label class="form-check-label role-font-2" for="flexCheckDefault-{{$ke}}-{{$permission->name}}">
                                                    {{$permission_type_name->name}}
                                                </label>
                                            </div>
                                            <br>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <hr>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="submit" id="submit"  class="btn btn-primary" >Submit</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
    </div>
</form>
<script>
    
    $(document).ready(function() {
        $("#check_all").on('click', function() {
            $(".checkbox").prop('checked', true);
        });
        $("#uncheck_all").on('click', function() {
            $(".checkbox").prop('checked', false);
        });
        $('input[name^="modul_name"]').on('change', function() {
            var key = $(this).attr('name').replace('modul_name[', '').replace(']', '');
            if ($(this).is(':checked')) {
                $('input[name="permission_id[' + key + '][]"]').prop('checked', true);
            } else {
                $('input[name="permission_id[' + key + '][]"]').prop('checked', false);
            }
        });
        
        $('input[name^="permission_id"]').on('change', function() {
            var key = $(this).attr('name').replace('permission_id[', '').replace('][]', '');
            var checkboxes = $('input[name="permission_id[' + key + '][]"]');
            if (checkboxes.filter(':checked').length > 0) {
                $('input[name="modul_name[' + key + ']"]').prop('checked', true);
            } else {
                $('input[name="modul_name[' + key + ']"]').prop('checked', false);
            }
        });
        $('#search-role').on('keyup', function () {
            var searchText = $(this).val().toLowerCase();
            $('.permission-group').each(function () {
                var name = $(this).data('name');
                var innerText = $(this).text().toLowerCase();
                if (name.includes(searchText) || innerText.includes(searchText)) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });
        });
    });
</script>