<form id="form">
    <div class="modal-body">
        <div class="row">
            <div class="col-md-12 mb-2">
                <label for="">Name <span class="text-danger">*</span></label>
                <input type="text" name="name" class="form-control" id="name" >
            </div>
            <div class="col-md-12 mb-2">
                <label class="control-label role-font-2" >Select Permissions <span class="text-danger">*</span></label>
                <br><a class="btn btn-primary btn-sm text-white role-font" id="check_all" >Check All</a>
                <a class="btn btn-primary btn-sm text-white role-font" id="uncheck_all" >Uncheck All</a><br>
            </div>
            
            <div class="col-md-12 mb-2">
                @php $permissions = App\Models\Permission::get(); @endphp
                <div class="row">
                    @foreach($permissions as $key => $permission)
                        <div class="col-md-3 mt-2">
                            <!-- <div class="form-check form-check-md d-flex align-items-center"> 
                                <input name="modul_name[{{$key}}]" type="checkbox" class="form-check-input checkbox roalchack" value="{{$permission->name}}">
                                <label class="form-check-label" for="checkebox-md">{{$permission->name}}</label>
                            </div> -->
                            <div class="form-check form-check-md d-flex align-items-center"> 
                                <input name="modul_name[{{$key}}]" class="me-1 checkbox roalchack" type="checkbox" value="{{$permission->name}}" id="checkebox-{{$key}}" > 
                                <label class="form-check-label role-font-2" for="checkebox-{{$key}}"> {{$permission->name}} </label> 
                            </div>
                        </div>
                        <div class="col-md-9 mt-2">
                            @php
                                $permission_types = explode(',', $permission->permission_type_id);
                            @endphp
                            <div class="row">
                                @foreach($permission_types as $ke => $permission_type)
                                    @php 
                                        $permission_type_name = App\Models\PermissionType::where('id',$permission_type)->first(); 
                                    @endphp
                                    <div class="col-md-3">
                                        <div class="form-check" >
                                            <input name="permission_id[{{$key}}][]" type="checkbox" id="flexCheckDefault-{{$ke}}-{{$permission->name}}" class=" checkbox roalchack" value="{{$permission_type}}">
                                            <label class="form-check-label role-font-2" for="flexCheckDefault-{{$ke}}-{{$permission->name}}">
                                                {{$permission_type_name->name}}
                                            </label>
                                            </div><br>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <hr>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="submit" id="submit"  class="btn btn-primary" >Submit</button>
        <button type="button" class="btn btn-secondary" onclick="closeModal();">Close</button>
    </div>
</form>
<script>
    
    $(document).ready(function() {
        $("#check_all").on('click', function() {
            $(".checkbox").prop('checked', true);
        });
        $("#uncheck_all").on('click', function() {
            $(".checkbox").prop('checked', false);
        });
        $('input[name^="modul_name"]').on('change', function() {
            var key = $(this).attr('name').replace('modul_name[', '').replace(']', '');
            if ($(this).is(':checked')) {
                $('input[name="permission_id[' + key + '][]"]').prop('checked', true);
            } else {
                $('input[name="permission_id[' + key + '][]"]').prop('checked', false);
            }
        });
        $('input[name^="permission_id"]').on('change', function() {
            var key = $(this).attr('name').replace('permission_id[', '').replace('][]', '');
            var checkboxes = $('input[name="permission_id[' + key + '][]"]');
            if (checkboxes.filter(':checked').length > 0) {
                $('input[name="modul_name[' + key + ']"]').prop('checked', true);
            } else {
                $('input[name="modul_name[' + key + ']"]').prop('checked', false);
            }
        });
    });
</script>