<!DOCTYPE html>
<html lang="en">

<head>

	<meta charset="UTF-8">
	<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="Description" content="Vipnumber | ERP">
	<meta name="Author" content="">
	<meta name="Keywords"
		content="" />
	<title>  Singi Marketing | ERP</title>
	<link rel="icon" href="{{url($sitesetting->fevicon)}}" type="image/x-icon"/>
	<link href="{{ url('assets/admin') }}/css/icons.css" rel="stylesheet">
	<link href="{{ url('assets/admin') }}/css/style.css" rel="stylesheet">	
	<link href="{{ url('assets/admin') }}/css/reset-password.css" rel="stylesheet">	
</head>
<body class="ltr error-page1 main-body bg_light text-dark error-3">
    <!-- Global Loader -->
    <div id="global-loader" style="display: none;">
        <div class="loader-img">
            <i class="fas fa-spinner fa-spin" style="font-size: 30px; color: white;"></i>
        </div>
    </div>

    <div class="page">
        <!-- Reset Password Form -->
        <div class="form-container">
            <div class="glass-card">
                <div class="form-header">
                    <div class="reset-icon">
                        <img src="{{$sitesetting->image_url}}" alt="Logo">
                    </div>
                    <h2>
                        Reset Password
                    </h2>
                    <p>Enter your email address and we'll send you a link to reset your password</p>
                </div>
                @if (session('status'))
                    <div class="alert">
                        <i class="fas fa-check-circle"></i>
                        {{ session('status') }}
                    </div>
                @endif

                <form method="POST" action="{{ url('secure-dashboard/password/email') }}">
                    {{ csrf_field() }}
                    
                    <div class="form-group {{ $errors->has('email') ? ' has-error' : '' }}">
                        <label for="email">Email Address</label>
                        <div class="input-container">
                            <i class="input-icon fas fa-envelope"></i>
                            <input 
                                class="form-control" 
                                id="email"
                                placeholder="Enter your email address" 
                                type="email" 
                                value="{{old('email')}}" 
                                name="email"
                                required
                            >
                        </div>
                       <span class="help-block text-danger" ><strong>{{ $errors->first('email') }}</strong></span>
                    </div>

                    <button type="submit" class="btn-primary">
                        <i class="fas fa-paper-plane"></i>
                        Send Password Reset Link
                    </button>
                </form>

                <!-- Back to Login -->
                <div style="text-align: center; margin-top: 25px;">
                    <a href="{{ url('secure-dashboard/login') }}" style="color: rgba(255, 255, 255, 0.8); text-decoration: none; font-size: 14px; transition: color 0.3s ease;">
                        <i class="fas fa-arrow-left"></i>
                        Back to Login
                    </a>
                </div>
            </div>
        </div>

        <!-- Video Section -->
         @php
            $videoId = null;
            if (!empty($sitesetting->youtube_link)) {
                $url = $sitesetting->youtube_link;
                if (strpos($url, 'youtu.be/') !== false) {
                    $videoId = \Illuminate\Support\Str::after($url, 'youtu.be/');
                    $videoId = strtok($videoId, '?'); 
                }
                elseif (strpos($url, 'v=') !== false) {
                    $videoId = \Illuminate\Support\Str::after($url, 'v=');
                    $videoId = strtok($videoId, '&');
                }
            }
        @endphp
        @if(!empty($videoId))
        <div class="video-container">
            <div class="video-header">
                <h4>
                    <i class="fas fa-play-circle"></i>
                    Featured Video
                </h4>
            </div>
            <div class="video-wrapper">
                <iframe
                    src="https://www.youtube.com/embed/{{ $videoId }}"
                    allowfullscreen>
                </iframe>
            </div>
        </div>
        @endif
    </div>

    <script>
        document.getElementById('global-loader').style.display = 'flex';
        
        window.addEventListener('load', function() {
            setTimeout(() => {
                document.getElementById('global-loader').style.display = 'none';
            }, 1000);
        });

        document.querySelectorAll('.form-control').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'scale(1.02)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'scale(1)';
            });
        });

    </script>
</body>
</html>