@extends('admin.layout.app')

@section('content')
<div class="main-content app-content global">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Firms Details</h4>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
                <div class="pe-1 mb-xl-0">
                    @if(rolemanagement('Firm', 2))
                        <a href="{{ route('admin.firms.create') }}">
                            <button type="button" class="btn btn-primary">Add Firm</button>
                        </a>
                    @endif
                </div>
            </div>
        </div>

        <div>
            <ul class="nav nav-tabs mb-3" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="list-tab" data-bs-toggle="tab"
                            data-bs-target="#list" type="button" role="tab"
                            aria-controls="list" aria-selected="true">
                        Firms List
                    </button>
                </li>
            </ul>
        </div>

        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="list" role="tabpanel" aria-labelledby="list-tab">
                <div class="row row-sm">
                    <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                        <div class="card">
                            <div class="card-header pb-0">
                                <div class="d-flex justify-content-between">
                                    <h4 class="card-title mg-b-0">Firms Details</h4>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped" id="firms_table">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Firm Name</th>
                                                <th>Firm Type</th>
                                                <th>Owner Name</th>
                                                <th>Mobile No.</th>
                                                <th>GST No.</th>
                                                <th>PAN No.</th>
                                                <th>State</th>
                                                <th>City</th>
                                                <th>Status</th>
                                                <th>Created At</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


@section('js')
<script>
    jQuery(document).ready(function () {

        $('#firms_table').DataTable({
            responsive: false,
            lengthChange: true,
            autoWidth: false,
            pageLength: 10,
            buttons: [],
            stateSave: true,
            processing: true,
            serverSide: true,
            dom: 'lBfrtip',
            ajax: {
                url: "{{ route('admin.firms.index') }}",
                type: 'GET',
                data: function (d) { d._token = "{{ csrf_token() }}"; }
            },
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', className: 'text-center', orderable: false, searchable: false },
                { data: 'firm_name', name: 'firm_name', defaultContent: '-', className: 'text-center' , orderable: false},
                { data: 'firm_type', name: 'firm_type', defaultContent: '-', className: 'text-center' , orderable: false},
                { data: 'owner_name', name: 'owner_name', defaultContent: '-', className: 'text-center' , orderable: false},
                { data: 'mobile_number', name: 'mobile_number', defaultContent: '-', className: 'text-center' , orderable: false},
                { data: 'gst_number', name: 'gst_number', defaultContent: '-', className: 'text-center' , orderable: false},
                { data: 'pan_number', name: 'pan_number', defaultContent: '-', className: 'text-center' , orderable: false},
                { data: 'state', name: 'state', defaultContent: '-', className: 'text-center' , orderable: false},
                { data: 'city', name: 'city', defaultContent: '-', className: 'text-center' , orderable: false},
                { data: 'status', name: 'status', defaultContent: '-', className: 'text-center', orderable: false, searchable: false },
                { data: 'created_at', name: 'created_at', defaultContent: '-', className: 'text-center' , orderable: false},
                { data: 'action', name: 'action', defaultContent: '-', className: 'text-center', orderable: false, searchable: false },
            ]
        });

        $("body").on("change", ".status-toggle", function () {
            const $toggle = $(this);
            const id = $toggle.data('id');
            const currentStatus = $toggle.is(':checked') ? 1 : 0;

            Swal.fire({
                title: "Are you sure?",
                text: "Change firm status?",
                icon: "question",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, change it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ url('secure-dashboard/firms') }}/" + id + "/toggle-status",
                        type: "POST",
                        data: {
                            _token: "{{ csrf_token() }}"
                        },
                        success: function (response) {
                            if (response.success) {
                                toastr.success(response.message);
                                $('#firms_table').DataTable().ajax.reload(null, false);
                            } else {
                                toastr.error("Failed to update status.");
                                $toggle.prop('checked', !currentStatus);
                            }
                        },
                        error: function () {
                            toastr.error("Something went wrong!");
                            $toggle.prop('checked', !currentStatus);
                        }
                    });
                } else {
                    $toggle.prop('checked', !currentStatus);
                }
            });
        });

        $("body").on("click", ".data-delete", function () {
            const id = $(this).data('id');

            Swal.fire({
                title: "Delete?",
                text: "This action cannot be undone.",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, delete"
            }).then(result => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('admin.firms.destroy', ':id') }}".replace(':id', id),
                        type: 'DELETE',
                        data: { _token: "{{ csrf_token() }}", id: id },
                        success: function (r) {
                            if (r.success) {
                                toastr.success(r.message);
                                $('#firms_table').DataTable().ajax.reload();
                            } else {
                                toastr.error(r.message || "Something went wrong.");
                            }
                        },
                        error: function () {
                            toastr.error("Failed to delete firm.");
                        }
                    });
                }
            });
        });

    });
</script>
@endsection