<section class="firm_details_form_container">
    <div class="card personal_details_container">
        <div class="card-header"><h4 class="card-title">Firm Details</h4></div>
        <div class="card-body">
            <div class="row">

                <div class="col-md-4 mb-3">
                    <label class="form-label">Firm Name <span class="text-danger">*</span></label>
                    <input type="text" name="firm_name" value="{{ old('firm_name', $firm->firm_name ?? '') }}" placeholder="Enter Firm Name" class="form-control" required>
                    @error('firm_name') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Firm Type <span class="text-danger">*</span></label>
                    <input type="text" name="firm_type"
                           value="{{ old('firm_type', $firm->firm_type ?? '') }}"
                           placeholder="Enter Firm Type" class="form-control">
                    @error('firm_type') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Registration Number <span class="text-danger">*</span></label>
                    <input type="text" name="registration_number"
                           value="{{ old('registration_number', $firm->registration_number ?? '') }}"
                           placeholder="Enter Registration Number" class="form-control">
                    @error('registration_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Date of Establishment</label>
                    <input type="date" name="date_of_establishment"
                           value="{{ old('date_of_establishment', $firm->date_of_establishment ?? '') }}"
                           class="form-control salary-datepicker">
                    @error('date_of_establishment') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Owner Name <span class="text-danger">*</span></label>
                    <input type="text" name="owner_name"
                           value="{{ old('owner_name', $firm->owner_name ?? '') }}"
                           placeholder="Enter Owner Name" class="form-control">
                    @error('owner_name') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Designation</label>
                    <input type="text" name="designation"
                           value="{{ old('designation', $firm->designation ?? '') }}"
                           placeholder="Enter Designation" class="form-control">
                    @error('designation') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Email <span class="text-danger">*</span></label>
                    <input type="email" name="email"
                           value="{{ old('email', $firm->email ?? '') }}"
                           placeholder="Enter Email" class="form-control">
                    @error('email') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Mobile Number <span class="text-danger">*</span></label>
                    <input type="text" name="mobile_number"
                           value="{{ old('mobile_number', $firm->mobile_number ?? '') }}"
                           placeholder="Enter Mobile Number" class="form-control" required>
                    @error('mobile_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Alternate Mobile Number</label>
                    <input type="text" name="alternate_mobile_number"
                           value="{{ old('alternate_mobile_number', $firm->alternate_mobile_number ?? '') }}"
                           placeholder="Enter Alternate Mobile Number" class="form-control">
                    @error('alternate_mobile_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">GST Number <span class="text-danger">*</span></label>
                    <input type="text" name="gst_number"
                           value="{{ old('gst_number', $firm->gst_number ?? '') }}"
                           placeholder="e.g. 22AAAAA0000A1Z5" class="form-control" required>
                    @error('gst_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">PAN Number <span class="text-danger">*</span></label>
                    <input type="text" 
                        name="pan_number" 
                        value="{{ old('pan_number', $firm->pan_number ?? '') }}"
                        placeholder="e.g. ABCDE1234F" 
                        class="form-control" 
                        maxlength="10" 
                        style="text-transform: uppercase;" 
                        required>
                    @error('pan_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Aadhar Number <span class="text-danger">*</span></label>
                    <input type="text" 
                        name="aadhar_number" 
                        value="{{ old('aadhar_number', $firm->aadhar_number ?? '') }}"
                        placeholder="Enter 12-digit Aadhar Number" 
                        class="form-control" 
                        maxlength="12" 
                        required>
                    @error('aadhar_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">TAN Number</label>
                    <input type="text" name="tan_number"
                           value="{{ old('tan_number', $firm->tan_number ?? '') }}"
                           placeholder="Enter TAN Number" class="form-control">
                    @error('tan_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">CIN Number</label>
                    <input type="text" name="cin_number"
                           value="{{ old('cin_number', $firm->cin_number ?? '') }}"
                           placeholder="Enter CIN Number" class="form-control">
                    @error('cin_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">MSME Number</label>
                    <input type="text" name="msme_number"
                           value="{{ old('msme_number', $firm->msme_number ?? '') }}"
                           placeholder="Enter MSME Number" class="form-control">
                    @error('msme_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Address <span class="text-danger">*</span></label>
                    <textarea name="address_line1" class="form-control" required
                              placeholder="Enter Full Address">{{ old('address_line1', $firm->address_line1 ?? '') }}</textarea>
                    @error('address_line1') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Address Line 2</label>
                    <textarea name="address_line2" class="form-control"
                              placeholder="Enter Additional Address">{{ old('address_line2', $firm->address_line2 ?? '') }}</textarea>
                    @error('address_line2') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">District</label>
                    <input type="text" name="district"
                           value="{{ old('district', $firm->district ?? '') }}"
                           placeholder="Enter District" class="form-control">
                    @error('district') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">State <span class="text-danger">*</span></label>
                    <select name="state" id="state" class="form-control my-select" required>
                        <option value="">--Select State--</option>
                        @foreach($states as $state)
                            <option value="{{ $state->id }}"
                                    {{ old('state', $firm->state ?? '') == $state->id ? 'selected' : '' }}>
                                {{ $state->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('state') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">City <span class="text-danger">*</span></label>
                    <select name="city" id="city" class="form-control my-select" required>
                        <option value="">--Select City--</option>
                        @foreach($cities as $cityItem)
                            <option value="{{ $cityItem->id }}"
                                    {{ old('city', $firm->city ?? '') == $cityItem->id ? 'selected' : '' }}>
                                {{ $cityItem->name }}
                            </option>
                        @endforeach
                    </select>
                    @error('city') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Country <span class="text-danger">*</span></label>
                    <input type="text" name="country"
                           value="{{ old('country', $firm->country ?? 'India') }}"
                           placeholder="Enter Country" class="form-control">
                    @error('country') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Pincode</label>
                    <input type="text" name="pincode"
                           value="{{ old('pincode', $firm->pincode ?? '') }}"
                           placeholder="Enter Pincode" class="form-control">
                    @error('pincode') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Bank Name</label>
                    <input type="text" name="bank_name"
                           value="{{ old('bank_name', $firm->bank_name ?? '') }}"
                           placeholder="Enter Bank Name" class="form-control">
                    @error('bank_name') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Branch Name</label>
                    <input type="text" name="branch_name"
                           value="{{ old('branch_name', $firm->branch_name ?? '') }}"
                           placeholder="Enter Branch Name" class="form-control">
                    @error('branch_name') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Account Holder Name</label>
                    <input type="text" name="account_holder_name"
                           value="{{ old('account_holder_name', $firm->account_holder_name ?? '') }}"
                           placeholder="Enter Account Holder Name" class="form-control">
                    @error('account_holder_name') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Account Number</label>
                    <input type="text" name="account_number"
                           value="{{ old('account_number', $firm->account_number ?? '') }}"
                           placeholder="Enter Account Number" class="form-control">
                    @error('account_number') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">IFSC Code</label>
                    <input type="text" name="ifsc_code"
                           value="{{ old('ifsc_code', $firm->ifsc_code ?? '') }}"
                           placeholder="Enter IFSC Code" class="form-control">
                    @error('ifsc_code') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">UPI ID</label>
                    <input type="text" name="upi_id"
                           value="{{ old('upi_id', $firm->upi_id ?? '') }}"
                           placeholder="Enter UPI ID" class="form-control">
                    @error('upi_id') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Firm Logo</label>
                    <input type="file" name="logo" class="form-control" accept="image/*">
                    @error('logo') <span class="text-danger">{{ $message }}</span> @enderror
                    @if($firm->logo ?? false)
                        <img class="image-preview mt-2" src="{{ asset($firm->logo) }}" style="width:100px;height:100px;object-fit:cover;">
                    @else
                        <img class="image-preview mt-2" src="{{ url('assets/admin/images/not-available (1).jpg') }}" style="width:100px;height:100px;object-fit:cover;display:none;">
                    @endif
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">PAN Card Image</label>
                    <input type="file" name="pan_card_image" class="form-control" accept="image/*">
                    @error('pan_card_image') <span class="text-danger">{{ $message }}</span> @enderror
                    @if($firm->pan_card_image ?? false)
                        <img class="image-preview mt-2" src="{{ asset($firm->pan_card_image) }}" style="width:100px;height:100px;object-fit:cover;">
                    @endif
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Aadhar Card Image</label>
                    <input type="file" name="aadhar_card_image" class="form-control" accept="image/*">
                    @error('aadhar_card_image') <span class="text-danger">{{ $message }}</span> @enderror
                    @if($firm->aadhar_card_image ?? false)
                        <img class="image-preview mt-2" src="{{ asset($firm->aadhar_card_image) }}"
                             style="width:100px;height:100px;object-fit:cover;">
                    @endif
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">GST Certificate</label>
                    <input type="file" name="gst_certificate" class="form-control" accept="image/*,application/pdf">
                    @error('gst_certificate') <span class="text-danger">{{ $message }}</span> @enderror
                    @if($firm->gst_certificate ?? false)
                        <a href="{{ asset($firm->gst_certificate) }}" target="_blank" class="d-block mt-2 text-primary">
                            View Document
                        </a>
                    @endif
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Bank Passbook Image</label>
                    <input type="file"  name="bank_passbook_image" class="form-control" accept="image/*">
                    @error('bank_passbook_image') <span class="text-danger">{{ $message }}</span> @enderror
                    @if($firm->bank_passbook_image ?? false)
                        <img class="image-preview mt-2" src="{{ asset($firm->bank_passbook_image) }}"
                             style="width:100px;height:100px;object-fit:cover;">
                    @endif
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Registration Certificate</label>
                    <input type="file" name="registration_certificate" class="form-control" accept="image/*,application/pdf">
                    @error('registration_certificate') <span class="text-danger">{{ $message }}</span> @enderror
                    @if($firm->registration_certificate ?? false)
                        <a href="{{ asset($firm->registration_certificate) }}" target="_blank" class="d-block mt-2 text-primary">
                            View Document
                        </a>
                    @endif
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Website URL</label>
                    <input type="url" name="website_url"
                           value="{{ old('website_url', $firm->website_url ?? '') }}"
                           placeholder="https://example.com" class="form-control">
                    @error('website_url') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Facebook URL</label>
                    <input type="url" name="facebook_url"
                           value="{{ old('facebook_url', $firm->facebook_url ?? '') }}"
                           placeholder="https://facebook.com/..." class="form-control">
                    @error('facebook_url') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Instagram URL</label>
                    <input type="url" name="instagram_url"
                           value="{{ old('instagram_url', $firm->instagram_url ?? '') }}"
                           placeholder="https://instagram.com/..." class="form-control">
                    @error('instagram_url') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">LinkedIn URL</label>
                    <input type="url" name="linkedin_url"
                           value="{{ old('linkedin_url', $firm->linkedin_url ?? '') }}"
                           placeholder="https://linkedin.com/..." class="form-control">
                    @error('linkedin_url') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-8 mb-3">
                    <label class="form-label">Remarks</label>
                    <textarea name="remarks" class="form-control" rows="3"
                              placeholder="Any additional remarks">{{ old('remarks', $firm->remarks ?? '') }}</textarea>
                    @error('remarks') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="col-md-4 mb-3">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-control">
                        <option value="Active" {{ old('status', $firm->status ?? 'Active') == 'Active' ? 'selected' : '' }}>Active</option>
                        <option value="Inactive" {{ old('status', $firm->status ?? 'Active') == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                    @error('status') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

            </div>
        </div>
    </div>
</section>

@section('js')
<script>
    jQuery(document).ready(function () {

        $(".salary-datepicker").flatpickr({
            maxDate: "today",
            dateFormat: "d-m-Y", 
            allowInput: true,
            onReady: function (selectedDates, dateStr, instance) {
                let futureDays = instance.calendarContainer.querySelectorAll(".flatpickr-day");
                futureDays.forEach((day) => {
                    if (day.dateObj > new Date()) {
                        day.classList.add("flatpickr-disabled", "disabled");
                    }
                });
            },
            allowInput: true 
        });
        
    });
</script>
@endsection