<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome to Our Platform</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            line-height: 1.6;
            color: #333333;
            background-color: #f8f9fa;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }
        
        .header {
            background: linear-gradient(135deg, #1177BC 0%, #2CA7DF 100%);
            padding: 40px 30px;
        }
        
        .logo {
            font-size: 28px;
            font-weight: bold;
            color: #ffffff;
            margin-bottom: 10px;
        }
        
        .header-subtitle {
            color: #e8eaff;
            font-size: 16px;
        }
        
        .content {
            padding: 40px 30px;
        }
        
        .welcome-title {
            font-size: 24px;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .welcome-message {
            font-size: 16px;
            color: #4a5568;
            margin-bottom: 30px;
            text-align: center;
        }
        
        .credentials-container {
            background-color: #f7fafc;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 25px;
            margin: 30px 0;
        }
        
        .credentials-title {
            font-size: 18px;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .credential-row {
            margin-bottom: 15px;
        }
        
        .credential-label {
            font-size: 14px;
            font-weight: 600;
            color: #4a5568;
            margin-bottom: 5px;
        }
        
        .credential-value {
            background-color: #ffffff;
            border: 1px solid #cbd5e0;
            border-radius: 6px;
            padding: 12px 15px;
            font-size: 16px;
            color: #2d3748;
            font-family: 'Courier New', monospace;
            word-break: break-all;
        }
        
        .login-button {
            text-align: center;
            margin: 30px 0;
        }
        
        .btn {
            display: inline-block;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #ffffff;
            text-decoration: none;
            padding: 15px 40px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            text-align: center;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        }
        
        .security-notice {
            background-color: #fff5f5;
            border-left: 4px solid #fc8181;
            padding: 15px 20px;
            margin: 25px 0;
            border-radius: 0 6px 6px 0;
        }
        
        .security-notice-title {
            font-size: 14px;
            font-weight: 600;
            color: #c53030;
            margin-bottom: 5px;
        }
        
        .security-notice-text {
            font-size: 14px;
            color: #742a2a;
        }
        
        .next-steps {
            background-color: #f0fff4;
            border-radius: 8px;
            padding: 20px;
            margin: 25px 0;
        }
        
        .next-steps-title {
            font-size: 16px;
            font-weight: 600;
            color: #22543d;
            margin-bottom: 10px;
        }
        
        .next-steps-list {
            color: #2f855a;
            font-size: 14px;
        }
        
        .footer {
            background-color: #2d3748;
            padding: 30px;
            text-align: center;
        }
        
        .footer-text {
            color: #a0aec0;
            font-size: 14px;
            margin-bottom: 10px;
        }
        
        .footer-links {
            margin-top: 15px;
        }
        
        .footer-link {
            color: #81c1f7;
            text-decoration: none;
            margin: 0 15px;
            font-size: 14px;
        }
        
        .footer-link:hover {
            color: #63b3ed;
        }
        
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100% !important;
            }
            
            .header, .content, .footer {
                padding: 20px !important;
            }
            
            .credentials-container {
                padding: 20px !important;
            }
            
            .btn {
                padding: 12px 30px !important;
                font-size: 14px !important;
            }
        }
    </style>
</head>
<body>
    <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="background-color: #f8f9fa;">
        <tr>
            <td align="center" style="padding: 20px 0;">
                <table class="email-container" role="presentation" cellspacing="0" cellpadding="0" border="0" width="600" style="max-width: 600px; background-color: #ffffff; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 20px rgba(0,0,0,0.1);">
                    <tr>
                        <td class="header" style="background: linear-gradient(135deg, #1177BC 0%, #2CA7DF 100%); padding: 15px 30px; ">
                            <a href="{{url('/')}}" style="width: 50%;">
                                <img src="{{url('public/uploads/sitesetting/21353648041749786675.png')}}" alt="Singimarketing Logo" class="logo" style="width: 100px;">
                            </a>
                            <div class="contact-info" style="text-align: end; color: white;    float: right;">
                                <p>Phone: <a href="tel:+{{$sitesetting->comp_phone}}" style="text-decoration: none;color: white;">{{$sitesetting->comp_phone}}</a><br>Email: <a href="mailto:{{$sitesetting->comp_email}}" style="text-decoration: none;color: white;">{{$sitesetting->comp_email}}</a></p>
                                <p>Shop No.S116, First Floor, Gate No.2<br>Marketing Yard, Bedi, Rajkot - 360003</p>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td class="content" style="padding: 40px 30px;">
                            
                            <h1 class="welcome-title" style="font-size: 24px; font-weight: 600; color: #2d3748; margin-bottom: 20px; text-align: center;">
                                <i class="fas fa-party-horn" style="color: #667eea; margin-right: 10px;"></i>Welcome!
                            </h1>
                            
                            <p class="welcome-message" style="font-size: 16px; color: #4a5568; margin-bottom: 30px; text-align: center;">
                                Your account has been successfully created. Below are your login credentials to get started with our platform.
                            </p>
                            
                            <!-- Credentials Container -->
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
                                <tr>
                                    <td class="credentials-container" style="background-color: #f7fafc; border: 2px solid #e2e8f0; border-radius: 12px; padding: 25px;">
                                        
                                        <h2 class="credentials-title" style="font-size: 18px; font-weight: 600; color: #2d3748; margin-bottom: 20px; text-align: center;">
                                            <i class="fas fa-key" style="color: #667eea; margin-right: 8px;"></i>Your Login Credentials
                                        </h2>
                                        
                                        <!-- User ID -->
                                        <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="margin-bottom: 15px;">
                                            <tr>
                                                <td class="credential-label" style="font-size: 14px; font-weight: 600; color: #4a5568; margin-bottom: 5px; padding-bottom: 5px;">
                                                    <i class="fas fa-user" style="color: #667eea; margin-right: 8px;"></i>User ID / Email:
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="credential-value" style="background-color: #ffffff; border: 1px solid #cbd5e0; border-radius: 6px; padding: 12px 15px; font-size: 16px; color: #2d3748; font-family: 'Courier New', monospace;text-decoration: none;">
                                                    {{$user->email}}
                                                </td>
                                            </tr>
                                        </table>
                                        
                                        <!-- Password -->
                                        <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%" style="margin-bottom: 15px;">
                                            <tr>
                                                <td class="credential-label" style="font-size: 14px; font-weight: 600; color: #4a5568; margin-bottom: 5px; padding-bottom: 5px;">
                                                    <i class="fas fa-lock" style="color: #667eea; margin-right: 8px;"></i>Password:
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="credential-value" style="background-color: #ffffff; border: 1px solid #cbd5e0; border-radius: 6px; padding: 12px 15px; font-size: 16px; color: #2d3748; font-family: 'Courier New', monospace;">
                                                    {{$password}}
                                                </td>
                                            </tr>
                                        </table>
                                        
                                        <!-- Login URL -->
                                        <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
                                            <tr>
                                                <td class="credential-label" style="font-size: 14px; font-weight: 600; color: #4a5568; margin-bottom: 5px; padding-bottom: 5px;">
                                                    <i class="fas fa-link" style="color: #667eea; margin-right: 8px;"></i>Login URL:
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="credential-value" style="background-color: #ffffff; border: 1px solid #cbd5e0; border-radius: 6px; padding: 12px 15px; font-size: 16px; color: #2d3748; font-family: 'Courier New', monospace; word-break: break-all;text-decoration: none;">
                                                    {{url('/')}}
                                                </td>
                                            </tr>
                                        </table>
                                        
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Login Button -->
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
                                <tr>
                                    <td class="login-button" style="text-align: center; padding: 30px 0;">
                                        <a href="https://app.yourdomain.com/login" class="btn" style="display: inline-block; background: linear-gradient(135deg, #1177BC 0%, #2CA7DF 100%); color: #ffffff; text-decoration: none; padding: 15px 40px; border-radius: 8px; font-size: 16px; font-weight: 600;">
                                            <i class="fas fa-sign-in-alt" style="margin-right: 8px;"></i>Login to Your Account
                                        </a>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Security Notice -->
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
                                <tr>
                                    <td class="security-notice" style="background-color: #fff5f5; border-left: 4px solid #fc8181; padding: 15px 20px; border-radius: 0 6px 6px 0;">
                                        <div class="security-notice-title" style="font-size: 14px; font-weight: 600; color: #c53030; margin-bottom: 5px;">
                                            <i class="fas fa-shield-alt" style="margin-right: 8px;"></i>Security Notice
                                        </div>
                                        <div class="security-notice-text" style="font-size: 14px; color: #742a2a;">
                                            Please change your password after your first login for security purposes. Never share your credentials with anyone.
                                        </div>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Next Steps -->
                            <table role="presentation" cellspacing="0" cellpadding="0" border="0" width="100%">
                                <tr>
                                    <td class="next-steps" style="background-color: #f0fff4; border-radius: 8px; padding: 20px; margin: 25px 0;">
                                        <div class="next-steps-title" style="font-size: 16px; font-weight: 600; color: #22543d; margin-bottom: 10px;">
                                            <i class="fas fa-list-check" style="margin-right: 8px;"></i>Next Steps:
                                        </div>
                                        <div class="next-steps-list" style="color: #2f855a; font-size: 14px;">
                                            <i class="fas fa-arrow-right" style="margin-right: 5px; color: #38a169;"></i>Click the login button above or visit the login URL<br>
                                            <i class="fas fa-arrow-right" style="margin-right: 5px; color: #38a169;"></i>Enter your credentials to access your account<br>
                                            <i class="fas fa-arrow-right" style="margin-right: 5px; color: #38a169;"></i>Update your password in Account Settings<br>
                                            <i class="fas fa-arrow-right" style="margin-right: 5px; color: #38a169;"></i>Complete your profile setup<br>
                                            <i class="fas fa-arrow-right" style="margin-right: 5px; color: #38a169;"></i>Start exploring our platform features
                                        </div>
                                    </td>
                                </tr>
                            </table>
                            
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td class="footer" style="background-color: #2d3748; padding: 30px; text-align: center;">
                            <div class="footer-text" style="color: #a0aec0; font-size: 14px; margin-bottom: 10px;">
                                <i class="fas fa-headset" style="margin-right: 5px;"></i>Need help? We're here to assist you.
                            </div>
                            <div class="footer-text" style="color: #a0aec0; font-size: 14px; margin-bottom: 10px;">
                                © {{date('Y')}} Singi Marketing. All rights reserved.
                            </div>
                            <div class="footer-text" style="color: #a0aec0; font-size: 14px; margin-bottom: 10px;">
                                <a href="{{url('/')}}" class="footer-link" style="color: #81c1f7; text-decoration: none; margin: 0 15px; font-size: 14px;"><i class="fas fa-life-ring" style="margin-right: 5px;"></i>Support</a><br>
                                <a href="mailto:{{$sitesetting->comp_email}}" style="color: #81c1f7; text-decoration: none; margin: 0 15px; font-size: 14px;">{{$sitesetting->comp_email}}</a><br>
                                <a href="tel:+{{$sitesetting->comp_phone}}" style="color: #81c1f7; text-decoration: none; margin: 0 15px; font-size: 14px;">{{$sitesetting->comp_phone}}</a>
                            </div>
                            <div class="footer-links" style="margin-top: 15px;">
                                <a href="{{url('privacy-policy')}}" class="footer-link" style="color: #81c1f7; text-decoration: none; margin: 0 15px; font-size: 14px;"><i class="fas fa-user-shield" style="margin-right: 5px;"></i>Privacy Policy</a>
                                <a href="{{url('terms-of-service')}}" class="footer-link" style="color: #81c1f7; text-decoration: none; margin: 0 15px; font-size: 14px;"><i class="fas fa-file-contract" style="margin-right: 5px;"></i>Terms of Service</a>
                            </div>
                        </td>
                    </tr>
                    
                </table>
                
            </td>
        </tr>
    </table>
</body>
</html>