<?php

use App\Http\Middleware\RedirectIfAuthenticatedAdmin;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
        using: function () {

            Route::middleware('web')
                ->prefix('secure-dashboard')
                ->as('admin.')
                ->group(base_path('routes/admin.php'));

            Route::middleware('web')
                ->group(base_path('routes/web.php'));

            Route::middleware('web')
                ->prefix('member-portal')
                ->as('member.')
                ->group(base_path('routes/member.php'));

        },
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'is_admin' => RedirectIfAuthenticatedAdmin::class,
        ]);
        $middleware->web(append: [

        ]);

        $middleware->validateCsrfTokens(except: [
            'webhook',

        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
