<?php
namespace App\Services;

use App\Models\Sitesetting; 
use Illuminate\Support\Facades\Http;
use App\Imports\CampaignReportImport;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\Campaign;
use ZipArchive;
use Exception;
use File;

class CampaignApiService
{
    private $count = 0;
    public function generatereport($campaignDetailId)
    {
        $sitesetting = Sitesetting::first();
        $responseData = json_decode($sitesetting->token_resonse, true);
        $data = [
            "campaignId" => (int)$campaignDetailId,
            "reportType" => "full",
        ];
        $ch = curl_init("https://obdapi2.ivrsms.com/api/obd/report/generate");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Authorization: Bearer " . $responseData['token'],
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

        $response = json_decode($response, true);
        $this->get_single_report($response['reportId'],$data['campaignId']);

        return 1;
    }

    public function get_single_report($reportId,$campaignId){

        sleep(5);
        $sitesetting = Sitesetting::first();
        $responseData = json_decode($sitesetting->token_resonse, true);
        
        $ch = curl_init("https://obd3api.expressivr.com/api/obd/report/$reportId");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
      
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Bearer " . $responseData['token'],
            "Content-Type: application/json"
        ]);
        $response = curl_exec($ch);
       
        curl_close($ch);

        $response = json_decode($response, true);
    
        //if status is 0 then call get_single_report function again max 10 time
       
        if($response['status'] == 0){
            $this->count++;
            if($this->count > 10){
                return 'Failed to generate report';
            }

            return $this->get_single_report($reportId,$campaignId);
        }
        
        $zip_file_name = 'report_'. $response['reportId'] . '_' . time() . '.zip';
        $zip_file_path = public_path('temp_files/' . $zip_file_name);

        
        $file_content = Http::get($response['reportUrl'])->body();
        file_put_contents($zip_file_path, $file_content);

        $zip = new ZipArchive;
        $extract_path = public_path('temp_files/extracted_' . $response['reportId']);
    
        $open_result = $zip->open($zip_file_path);
        if ($open_result === true) {
            $zip->extractTo($extract_path);
            $zip->close();
        } else {
            $error_codes = [
                ZipArchive::ER_EXISTS => 'File already exists',
                ZipArchive::ER_INCONS => 'Inconsistent ZIP file',
                ZipArchive::ER_INVAL => 'Invalid argument',
                ZipArchive::ER_MEMORY => 'Memory allocation failure',
                ZipArchive::ER_NOENT => 'No such file',
                ZipArchive::ER_NOZIP => 'Not a ZIP archive',
                ZipArchive::ER_OPEN => 'Cannot open file',
                ZipArchive::ER_READ => 'Read error',
                ZipArchive::ER_SEEK => 'Seek error',
            ];
            $error_message = isset($error_codes[$open_result]) ? $error_codes[$open_result] : 'Unknown error';
            throw new Exception('Failed to open ZIP file. Error code: ' . $open_result . ' (' . $error_message . ')');
        }


        $excel_file = null;
        $files = scandir($extract_path.'/campaign');
       
        foreach ($files as $file) {
            $extension = pathinfo($file, PATHINFO_EXTENSION);
            if (in_array($extension, ['xlsx', 'csv'])) {
                $excel_file = $extract_path . '/campaign/' . $file;
                break;
            }
        }


        if (!$excel_file) {
            throw new Exception('No Excel file found in the ZIP.');
        }

        //store excel file in database
        $campaign = Campaign::where('campaignId_from_api', $response['campaignId'])->first();
        if (!$campaign) {
            throw new Exception('Campaign not found');
        }


       

        //file save in public path
        $file_name = 'campaign_report_'. $campaignId .'_'.time().'.csv';
        $file_path = public_path('uploads/campaign_report_csv/'.$file_name);

        file_put_contents($file_path, file_get_contents($excel_file));

        
        
        $campaign->update([
            'call_status_report_excel' => 'uploads/campaign_report_csv/'.$file_name
        ]);
        Excel::import(new CampaignReportImport($campaignId), $excel_file);

        // delete temp in public path
        File::deleteDirectory(public_path('temp_files/'.basename($extract_path)));
        File::delete(public_path('temp_files/'.basename($zip_file_path)));

        // return response()->json(['message' => 'File imported successfully']);
        return ['message' => 'File imported successfully'];
        
    }
}
